/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class UtilNamespaceHandler
extends NamespaceHandlerSupport {
    private static final String SCOPE_ATTRIBUTE = "scope";
    static /* synthetic */ Class class$org$springframework$beans$factory$config$FieldRetrievingFactoryBean;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$PropertyPathFactoryBean;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$ListFactoryBean;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$SetFactoryBean;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$MapFactoryBean;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$PropertiesFactoryBean;

    public void init() {
        this.registerBeanDefinitionParser("constant", new ConstantBeanDefinitionParser());
        this.registerBeanDefinitionParser("property-path", new PropertyPathBeanDefinitionParser());
        this.registerBeanDefinitionParser("list", new ListBeanDefinitionParser());
        this.registerBeanDefinitionParser("set", new SetBeanDefinitionParser());
        this.registerBeanDefinitionParser("map", new MapBeanDefinitionParser());
        this.registerBeanDefinitionParser("properties", new PropertiesBeanDefinitionParser());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PropertiesBeanDefinitionParser
    extends AbstractSimpleBeanDefinitionParser {
        private PropertiesBeanDefinitionParser() {
        }

        protected Class getBeanClass(Element element) {
            return class$org$springframework$beans$factory$config$PropertiesFactoryBean == null ? (class$org$springframework$beans$factory$config$PropertiesFactoryBean = UtilNamespaceHandler.class$("org.springframework.beans.factory.config.PropertiesFactoryBean")) : class$org$springframework$beans$factory$config$PropertiesFactoryBean;
        }

        protected boolean isEligibleAttribute(String attributeName) {
            return super.isEligibleAttribute(attributeName) && !UtilNamespaceHandler.SCOPE_ATTRIBUTE.equals(attributeName);
        }

        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            super.doParse(element, parserContext, builder);
            Properties parsedProps = parserContext.getDelegate().parsePropsElement(element);
            builder.addPropertyValue("properties", parsedProps);
            String scope = element.getAttribute(UtilNamespaceHandler.SCOPE_ATTRIBUTE);
            if (StringUtils.hasLength(scope)) {
                builder.setScope(scope);
            }
        }
    }

    private static class MapBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private MapBeanDefinitionParser() {
        }

        protected Class getBeanClass(Element element) {
            return class$org$springframework$beans$factory$config$MapFactoryBean == null ? (class$org$springframework$beans$factory$config$MapFactoryBean = UtilNamespaceHandler.class$("org.springframework.beans.factory.config.MapFactoryBean")) : class$org$springframework$beans$factory$config$MapFactoryBean;
        }

        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            String scope;
            String mapClass = element.getAttribute("map-class");
            Map parsedMap = parserContext.getDelegate().parseMapElement(element, builder.getRawBeanDefinition());
            builder.addPropertyValue("sourceMap", parsedMap);
            if (StringUtils.hasText(mapClass)) {
                builder.addPropertyValue("targetMapClass", mapClass);
            }
            if (StringUtils.hasLength(scope = element.getAttribute(UtilNamespaceHandler.SCOPE_ATTRIBUTE))) {
                builder.setScope(scope);
            }
        }
    }

    private static class SetBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private SetBeanDefinitionParser() {
        }

        protected Class getBeanClass(Element element) {
            return class$org$springframework$beans$factory$config$SetFactoryBean == null ? (class$org$springframework$beans$factory$config$SetFactoryBean = UtilNamespaceHandler.class$("org.springframework.beans.factory.config.SetFactoryBean")) : class$org$springframework$beans$factory$config$SetFactoryBean;
        }

        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            String scope;
            String setClass = element.getAttribute("set-class");
            Set parsedSet = parserContext.getDelegate().parseSetElement(element, builder.getRawBeanDefinition());
            builder.addPropertyValue("sourceSet", parsedSet);
            if (StringUtils.hasText(setClass)) {
                builder.addPropertyValue("targetSetClass", setClass);
            }
            if (StringUtils.hasLength(scope = element.getAttribute(UtilNamespaceHandler.SCOPE_ATTRIBUTE))) {
                builder.setScope(scope);
            }
        }
    }

    private static class ListBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private ListBeanDefinitionParser() {
        }

        protected Class getBeanClass(Element element) {
            return class$org$springframework$beans$factory$config$ListFactoryBean == null ? (class$org$springframework$beans$factory$config$ListFactoryBean = UtilNamespaceHandler.class$("org.springframework.beans.factory.config.ListFactoryBean")) : class$org$springframework$beans$factory$config$ListFactoryBean;
        }

        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            String scope;
            String listClass = element.getAttribute("list-class");
            List parsedList = parserContext.getDelegate().parseListElement(element, builder.getRawBeanDefinition());
            builder.addPropertyValue("sourceList", parsedList);
            if (StringUtils.hasText(listClass)) {
                builder.addPropertyValue("targetListClass", listClass);
            }
            if (StringUtils.hasLength(scope = element.getAttribute(UtilNamespaceHandler.SCOPE_ATTRIBUTE))) {
                builder.setScope(scope);
            }
        }
    }

    private static class PropertyPathBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private PropertyPathBeanDefinitionParser() {
        }

        protected Class getBeanClass(Element element) {
            return class$org$springframework$beans$factory$config$PropertyPathFactoryBean == null ? (class$org$springframework$beans$factory$config$PropertyPathFactoryBean = UtilNamespaceHandler.class$("org.springframework.beans.factory.config.PropertyPathFactoryBean")) : class$org$springframework$beans$factory$config$PropertyPathFactoryBean;
        }

        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            String path = element.getAttribute("path");
            if (!StringUtils.hasText(path)) {
                parserContext.getReaderContext().error("Attribute 'path' must not be empty", element);
                return;
            }
            int dotIndex = path.indexOf(".");
            if (dotIndex == -1) {
                parserContext.getReaderContext().error("Attribute 'path' must follow pattern 'beanName.propertyName'", element);
                return;
            }
            String beanName = path.substring(0, dotIndex);
            String propertyPath = path.substring(dotIndex + 1);
            builder.addPropertyValue("targetBeanName", beanName);
            builder.addPropertyValue("propertyPath", propertyPath);
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
            String id = super.resolveId(element, definition, parserContext);
            if (!StringUtils.hasText(id)) {
                id = element.getAttribute("path");
            }
            return id;
        }
    }

    private static class ConstantBeanDefinitionParser
    extends AbstractSimpleBeanDefinitionParser {
        private ConstantBeanDefinitionParser() {
        }

        protected Class getBeanClass(Element element) {
            return class$org$springframework$beans$factory$config$FieldRetrievingFactoryBean == null ? (class$org$springframework$beans$factory$config$FieldRetrievingFactoryBean = UtilNamespaceHandler.class$("org.springframework.beans.factory.config.FieldRetrievingFactoryBean")) : class$org$springframework$beans$factory$config$FieldRetrievingFactoryBean;
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
            String id = super.resolveId(element, definition, parserContext);
            if (!StringUtils.hasText(id)) {
                id = element.getAttribute("static-field");
            }
            return id;
        }
    }
}

