/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.db;

import com.coreframework.db.FileTypeFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import org.dom4j.Document;
import org.dom4j.io.XMLWriter;

public class FileOper {
    public static void saveTOFile(Document doc, String path) throws Exception {
        if (doc == null) {
            return;
        }
        FileOutputStream fos = new FileOutputStream(new File(path));
        XMLWriter writer = new XMLWriter((OutputStream)fos);
        writer.write(doc);
        writer.close();
        fos.close();
    }

    public static File[] getFiles(String path, String endsWith) {
        File directory = new File(path);
        File[] files = directory.listFiles(new FileTypeFilter(endsWith));
        return files;
    }

    public static boolean isExists(String path) {
        File writefile = new File(path);
        return writefile.exists();
    }

    public static boolean write(String path, String content, boolean hasAppend) {
        try {
            File writefile = new File(path);
            if (!writefile.exists()) {
                writefile.createNewFile();
                writefile = new File(path);
            }
            FileWriter filewriter = new FileWriter(writefile, hasAppend);
            filewriter.write(content);
            filewriter.flush();
            filewriter.close();
        }
        catch (Exception d) {
            System.out.println(d.getMessage());
            return false;
        }
        return true;
    }

    public static void copyFolder(String oldPath, String newPath) {
        try {
            new File(newPath).mkdirs();
            File a = new File(oldPath);
            String[] file = a.list();
            File temp = null;
            int i = 0;
            while (i < file.length) {
                temp = oldPath.endsWith(File.separator) ? new File(String.valueOf(oldPath) + file[i]) : new File(String.valueOf(oldPath) + File.separator + file[i]);
                if (!temp.getName().equals("CVS")) {
                    if (temp.isFile()) {
                        int len;
                        FileInputStream input = new FileInputStream(temp);
                        FileOutputStream output = new FileOutputStream(String.valueOf(newPath) + "/" + temp.getName().toString());
                        byte[] b = new byte[5120];
                        while ((len = input.read(b)) != -1) {
                            output.write(b, 0, len);
                        }
                        output.flush();
                        output.close();
                        input.close();
                    }
                    if (temp.isDirectory()) {
                        FileOper.copyFolder(String.valueOf(oldPath) + "/" + file[i], String.valueOf(newPath) + "/" + file[i]);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public static String createFolder(String folderPath) {
        String txt = folderPath;
        try {
            File myFilePath = new File(txt);
            txt = folderPath;
            if (!myFilePath.exists()) {
                myFilePath.mkdir();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return txt;
    }

    private static URL getClassLocationURL(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("null input: cls");
        }
        URL result = null;
        String clsAsResource = cls.getName().replace('.', '/').concat(".class");
        ProtectionDomain pd = cls.getProtectionDomain();
        if (pd != null) {
            CodeSource cs = pd.getCodeSource();
            if (cs != null) {
                result = cs.getLocation();
            }
            if (result != null && "file".equals(result.getProtocol())) {
                try {
                    if (result.toExternalForm().endsWith(".jar") || result.toExternalForm().endsWith(".zip")) {
                        result = new URL("jar:".concat(result.toExternalForm()).concat("!/").concat(clsAsResource));
                    } else if (new File(result.getFile()).isDirectory()) {
                        result = new URL(result, clsAsResource);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        if (result == null) {
            ClassLoader clsLoader = cls.getClassLoader();
            result = clsLoader != null ? clsLoader.getResource(clsAsResource) : ClassLoader.getSystemResource(clsAsResource);
        }
        return result;
    }

    public static String getPathFromClass(Class cls) throws IOException {
        String path = null;
        if (cls == null) {
            throw new NullPointerException();
        }
        URL url = FileOper.getClassLocationURL(cls);
        if (url != null) {
            path = url.getPath();
            if ("jar".equalsIgnoreCase(url.getProtocol())) {
                try {
                    path = new URL(path).getPath();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                int location = path.indexOf("!/");
                if (location != -1) {
                    path = path.substring(0, location);
                }
            }
            File file = new File(path);
            path = file.getCanonicalPath();
        }
        return path;
    }
}

