/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.suggest;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.suggest.SuggestAction;
import org.elasticsearch.action.suggest.SuggestRequest;
import org.elasticsearch.action.suggest.SuggestResponse;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.search.suggest.SuggestBuilder;

public class SuggestRequestBuilder
extends BroadcastOperationRequestBuilder<SuggestRequest, SuggestResponse, SuggestRequestBuilder> {
    final SuggestBuilder suggest = new SuggestBuilder();

    public SuggestRequestBuilder(ElasticsearchClient client, SuggestAction action) {
        super(client, action, new SuggestRequest());
    }

    public <T> SuggestRequestBuilder addSuggestion(SuggestBuilder.SuggestionBuilder<T> suggestion) {
        this.suggest.addSuggestion(suggestion);
        return this;
    }

    public SuggestRequestBuilder setRouting(String routing) {
        ((SuggestRequest)this.request).routing(routing);
        return this;
    }

    public SuggestRequestBuilder setSuggestText(String globalText) {
        this.suggest.setText(globalText);
        return this;
    }

    public SuggestRequestBuilder setPreference(String preference) {
        ((SuggestRequest)this.request).preference(preference);
        return this;
    }

    public SuggestRequestBuilder setRouting(String ... routing) {
        ((SuggestRequest)this.request).routing(routing);
        return this;
    }

    @Override
    protected SuggestRequest beforeExecute(SuggestRequest request) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(Requests.CONTENT_TYPE);
            this.suggest.toXContent(builder, ToXContent.EMPTY_PARAMS);
            request.suggest(builder.bytes());
        }
        catch (IOException e) {
            throw new ElasticsearchException("Unable to build suggestion request", (Throwable)e, new Object[0]);
        }
        return request;
    }
}

