/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transport.support;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.TransportActionNodeProxy;
import org.elasticsearch.client.transport.TransportClientNodesService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.TransportService;

public class TransportProxyClient {
    private final TransportClientNodesService nodesService;
    private final ImmutableMap<Action, TransportActionNodeProxy> proxies;

    @Inject
    public TransportProxyClient(Settings settings, TransportService transportService, TransportClientNodesService nodesService, Map<String, GenericAction> actions) {
        this.nodesService = nodesService;
        MapBuilder actionsBuilder = new MapBuilder();
        for (GenericAction action : actions.values()) {
            if (!(action instanceof Action)) continue;
            actionsBuilder.put((Action)action, new TransportActionNodeProxy(settings, action, transportService));
        }
        this.proxies = actionsBuilder.immutableMap();
    }

    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void execute(Action<Request, Response, RequestBuilder> action, final Request request, ActionListener<Response> listener) {
        final TransportActionNodeProxy proxy = (TransportActionNodeProxy)this.proxies.get(action);
        this.nodesService.execute(new TransportClientNodesService.NodeListenerCallback<Response>(){

            @Override
            public void doWithNode(DiscoveryNode node, ActionListener<Response> listener) {
                proxy.execute(node, request, listener);
            }
        }, listener);
    }
}

