/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.cluster.routing.IllegalShardRoutingStateException;
import org.elasticsearch.cluster.routing.PlainShardIterator;
import org.elasticsearch.cluster.routing.RestoreSource;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.shard.ShardId;

public final class ShardRouting
implements Streamable,
ToXContent {
    public static final long UNAVAILABLE_EXPECTED_SHARD_SIZE = -1L;
    private String index;
    private int shardId;
    private String currentNodeId;
    private String relocatingNodeId;
    private boolean primary;
    private ShardRoutingState state;
    private long version;
    private RestoreSource restoreSource;
    private UnassignedInfo unassignedInfo;
    private AllocationId allocationId;
    private final transient List<ShardRouting> asList;
    private transient ShardId shardIdentifier;
    private boolean frozen = false;
    private long expectedShardSize = -1L;
    private long hashVersion = this.version - 1L;
    private int hashCode = 0;

    private ShardRouting() {
        this.asList = Collections.singletonList(this);
    }

    public ShardRouting(ShardRouting copy) {
        this(copy, copy.version());
    }

    public ShardRouting(ShardRouting copy, long version) {
        this(copy.index(), copy.id(), copy.currentNodeId(), copy.relocatingNodeId(), copy.restoreSource(), copy.primary(), copy.state(), version, copy.unassignedInfo(), copy.allocationId(), true, copy.getExpectedShardSize());
    }

    ShardRouting(String index, int shardId, String currentNodeId, String relocatingNodeId, RestoreSource restoreSource, boolean primary, ShardRoutingState state, long version, UnassignedInfo unassignedInfo, AllocationId allocationId, boolean internal, long expectedShardSize) {
        this.index = index;
        this.shardId = shardId;
        this.currentNodeId = currentNodeId;
        this.relocatingNodeId = relocatingNodeId;
        this.primary = primary;
        this.state = state;
        this.asList = Collections.singletonList(this);
        this.version = version;
        this.restoreSource = restoreSource;
        this.unassignedInfo = unassignedInfo;
        this.allocationId = allocationId;
        this.expectedShardSize = expectedShardSize;
        assert (expectedShardSize == -1L || state == ShardRoutingState.INITIALIZING || state == ShardRoutingState.RELOCATING) : expectedShardSize + " state: " + (Object)((Object)state);
        assert (expectedShardSize >= 0L || state != ShardRoutingState.INITIALIZING || state != ShardRoutingState.RELOCATING) : expectedShardSize + " state: " + (Object)((Object)state);
        assert (state != ShardRoutingState.UNASSIGNED || unassignedInfo != null) : "unassigned shard must be created with meta";
        if (!internal) {
            assert (state == ShardRoutingState.UNASSIGNED);
            assert (currentNodeId == null);
            assert (relocatingNodeId == null);
            assert (allocationId == null);
        }
    }

    public static ShardRouting newUnassigned(String index, int shardId, RestoreSource restoreSource, boolean primary, UnassignedInfo unassignedInfo) {
        return new ShardRouting(index, shardId, null, null, restoreSource, primary, ShardRoutingState.UNASSIGNED, 0L, unassignedInfo, null, true, -1L);
    }

    public String index() {
        return this.index;
    }

    public String getIndex() {
        return this.index();
    }

    public int id() {
        return this.shardId;
    }

    public int getId() {
        return this.id();
    }

    public long version() {
        return this.version;
    }

    public boolean unassigned() {
        return this.state == ShardRoutingState.UNASSIGNED;
    }

    public boolean initializing() {
        return this.state == ShardRoutingState.INITIALIZING;
    }

    public boolean active() {
        return this.started() || this.relocating();
    }

    public boolean started() {
        return this.state == ShardRoutingState.STARTED;
    }

    public boolean relocating() {
        return this.state == ShardRoutingState.RELOCATING;
    }

    public boolean assignedToNode() {
        return this.currentNodeId != null;
    }

    public String currentNodeId() {
        return this.currentNodeId;
    }

    public String relocatingNodeId() {
        return this.relocatingNodeId;
    }

    public ShardRouting buildTargetRelocatingShard() {
        assert (this.relocating());
        return new ShardRouting(this.index, this.shardId, this.relocatingNodeId, this.currentNodeId, this.restoreSource, this.primary, ShardRoutingState.INITIALIZING, this.version, this.unassignedInfo, AllocationId.newTargetRelocation(this.allocationId), true, this.expectedShardSize);
    }

    public RestoreSource restoreSource() {
        return this.restoreSource;
    }

    @Nullable
    public UnassignedInfo unassignedInfo() {
        return this.unassignedInfo;
    }

    @Nullable
    public AllocationId allocationId() {
        return this.allocationId;
    }

    public boolean primary() {
        return this.primary;
    }

    public ShardRoutingState state() {
        return this.state;
    }

    public ShardId shardId() {
        if (this.shardIdentifier != null) {
            return this.shardIdentifier;
        }
        this.shardIdentifier = new ShardId(this.index, this.shardId);
        return this.shardIdentifier;
    }

    public boolean allocatedPostIndexCreate() {
        if (this.active()) {
            return true;
        }
        return this.unassignedInfo.getReason() != UnassignedInfo.Reason.INDEX_CREATED;
    }

    public ShardIterator shardsIt() {
        return new PlainShardIterator(this.shardId(), this.asList);
    }

    public static ShardRouting readShardRoutingEntry(StreamInput in) throws IOException {
        ShardRouting entry = new ShardRouting();
        entry.readFrom(in);
        return entry;
    }

    public static ShardRouting readShardRoutingEntry(StreamInput in, String index, int shardId) throws IOException {
        ShardRouting entry = new ShardRouting();
        entry.readFrom(in, index, shardId);
        return entry;
    }

    public void readFrom(StreamInput in, String index, int shardId) throws IOException {
        this.index = index;
        this.shardId = shardId;
        this.readFromThin(in);
    }

    public void readFromThin(StreamInput in) throws IOException {
        this.version = in.readLong();
        if (in.readBoolean()) {
            this.currentNodeId = in.readString();
        }
        if (in.readBoolean()) {
            this.relocatingNodeId = in.readString();
        }
        this.primary = in.readBoolean();
        this.state = ShardRoutingState.fromValue(in.readByte());
        this.restoreSource = RestoreSource.readOptionalRestoreSource(in);
        if (in.readBoolean()) {
            this.unassignedInfo = new UnassignedInfo(in);
        }
        if (in.readBoolean()) {
            this.allocationId = new AllocationId(in);
        }
        this.expectedShardSize = this.relocating() || this.initializing() ? in.readLong() : -1L;
        this.freeze();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.readFrom(in, in.readString(), in.readVInt());
    }

    public void writeToThin(StreamOutput out) throws IOException {
        out.writeLong(this.version);
        if (this.currentNodeId != null) {
            out.writeBoolean(true);
            out.writeString(this.currentNodeId);
        } else {
            out.writeBoolean(false);
        }
        if (this.relocatingNodeId != null) {
            out.writeBoolean(true);
            out.writeString(this.relocatingNodeId);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.primary);
        out.writeByte(this.state.value());
        if (this.restoreSource != null) {
            out.writeBoolean(true);
            this.restoreSource.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.unassignedInfo != null) {
            out.writeBoolean(true);
            this.unassignedInfo.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.allocationId != null) {
            out.writeBoolean(true);
            this.allocationId.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.relocating() || this.initializing()) {
            out.writeLong(this.expectedShardSize);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeVInt(this.shardId);
        this.writeToThin(out);
    }

    public void updateUnassignedInfo(UnassignedInfo unassignedInfo) {
        this.ensureNotFrozen();
        assert (this.unassignedInfo != null) : "can only update unassign info if they are already set";
        this.unassignedInfo = unassignedInfo;
    }

    void moveToUnassigned(UnassignedInfo unassignedInfo) {
        this.ensureNotFrozen();
        ++this.version;
        assert (this.state != ShardRoutingState.UNASSIGNED) : this;
        this.state = ShardRoutingState.UNASSIGNED;
        this.currentNodeId = null;
        this.relocatingNodeId = null;
        this.unassignedInfo = unassignedInfo;
        this.allocationId = null;
        this.expectedShardSize = -1L;
    }

    void initialize(String nodeId, long expectedShardSize) {
        this.ensureNotFrozen();
        ++this.version;
        assert (this.state == ShardRoutingState.UNASSIGNED) : this;
        assert (this.relocatingNodeId == null) : this;
        this.state = ShardRoutingState.INITIALIZING;
        this.currentNodeId = nodeId;
        this.allocationId = AllocationId.newInitializing();
        this.expectedShardSize = expectedShardSize;
    }

    void relocate(String relocatingNodeId, long expectedShardSize) {
        this.ensureNotFrozen();
        ++this.version;
        assert (this.state == ShardRoutingState.STARTED) : "current shard has to be started in order to be relocated " + this;
        this.state = ShardRoutingState.RELOCATING;
        this.relocatingNodeId = relocatingNodeId;
        this.allocationId = AllocationId.newRelocation(this.allocationId);
        this.expectedShardSize = expectedShardSize;
    }

    void cancelRelocation() {
        this.ensureNotFrozen();
        ++this.version;
        assert (this.state == ShardRoutingState.RELOCATING) : this;
        assert (this.assignedToNode()) : this;
        assert (this.relocatingNodeId != null) : this;
        this.expectedShardSize = -1L;
        this.state = ShardRoutingState.STARTED;
        this.relocatingNodeId = null;
        this.allocationId = AllocationId.cancelRelocation(this.allocationId);
    }

    void reinitializeShard() {
        this.ensureNotFrozen();
        assert (this.state == ShardRoutingState.STARTED);
        ++this.version;
        this.state = ShardRoutingState.INITIALIZING;
        this.allocationId = AllocationId.newInitializing();
        this.unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.REINITIALIZED, null);
    }

    void moveToStarted() {
        this.ensureNotFrozen();
        ++this.version;
        assert (this.state == ShardRoutingState.INITIALIZING) : "expected an initializing shard " + this;
        this.relocatingNodeId = null;
        this.restoreSource = null;
        this.unassignedInfo = null;
        if (this.allocationId.getRelocationId() != null) {
            this.allocationId = AllocationId.finishRelocation(this.allocationId);
        }
        this.expectedShardSize = -1L;
        this.state = ShardRoutingState.STARTED;
    }

    void moveToPrimary() {
        this.ensureNotFrozen();
        ++this.version;
        if (this.primary) {
            throw new IllegalShardRoutingStateException(this, "Already primary, can't move to primary");
        }
        this.primary = true;
    }

    void moveFromPrimary() {
        this.ensureNotFrozen();
        ++this.version;
        if (!this.primary) {
            throw new IllegalShardRoutingStateException(this, "Not primary, can't move to replica");
        }
        this.primary = false;
    }

    public boolean isSameShard(ShardRouting other) {
        return this.index.equals(other.index) && this.shardId == other.shardId;
    }

    public boolean isSameAllocation(ShardRouting other) {
        boolean b;
        boolean bl = b = this.allocationId != null && other.allocationId != null && this.allocationId.getId().equals(other.allocationId.getId());
        assert (!b || this.currentNodeId.equals(other.currentNodeId)) : "ShardRoutings have the same allocation id but not the same node. This [" + this + "], other [" + other + "]";
        return b;
    }

    public boolean isRelocationTarget() {
        return this.state == ShardRoutingState.INITIALIZING && this.relocatingNodeId != null;
    }

    public boolean isRelocationTargetOf(ShardRouting other) {
        boolean b;
        boolean bl = b = this.allocationId != null && other.allocationId != null && this.state == ShardRoutingState.INITIALIZING && this.allocationId.getId().equals(other.allocationId.getRelocationId());
        assert (!b || other.state == ShardRoutingState.RELOCATING) : "ShardRouting is a relocation target but the source shard state isn't relocating. This [" + this + "], other [" + other + "]";
        assert (!b || other.allocationId.getId().equals(this.allocationId.getRelocationId())) : "ShardRouting is a relocation target but the source id isn't equal to source's allocationId.getRelocationId. This [" + this + "], other [" + other + "]";
        assert (!b || other.currentNodeId().equals(this.relocatingNodeId)) : "ShardRouting is a relocation target but source current node id isn't equal to target relocating node. This [" + this + "], other [" + other + "]";
        assert (!b || this.currentNodeId().equals(other.relocatingNodeId)) : "ShardRouting is a relocation target but current node id isn't equal to source relocating node. This [" + this + "], other [" + other + "]";
        assert (!b || this.isSameShard(other)) : "ShardRouting is a relocation target but both routings are not of the same shard. This [" + this + "], other [" + other + "]";
        assert (!b || this.primary == other.primary) : "ShardRouting is a relocation target but primary flag is different. This [" + this + "], target [" + other + "]";
        return b;
    }

    public boolean isRelocationSourceOf(ShardRouting other) {
        boolean b;
        boolean bl = b = this.allocationId != null && other.allocationId != null && other.state == ShardRoutingState.INITIALIZING && other.allocationId.getId().equals(this.allocationId.getRelocationId());
        assert (!b || this.state == ShardRoutingState.RELOCATING) : "ShardRouting is a relocation source but shard state isn't relocating. This [" + this + "], other [" + other + "]";
        assert (!b || this.allocationId.getId().equals(other.allocationId.getRelocationId())) : "ShardRouting is a relocation source but the allocation id isn't equal to other.allocationId.getRelocationId. This [" + this + "], other [" + other + "]";
        assert (!b || this.currentNodeId().equals(other.relocatingNodeId)) : "ShardRouting is a relocation source but current node isn't equal to other's relocating node. This [" + this + "], other [" + other + "]";
        assert (!b || other.currentNodeId().equals(this.relocatingNodeId)) : "ShardRouting is a relocation source but relocating node isn't equal to other's current node. This [" + this + "], other [" + other + "]";
        assert (!b || this.isSameShard(other)) : "ShardRouting is a relocation source but both routings are not of the same shard. This [" + this + "], target [" + other + "]";
        assert (!b || this.primary == other.primary) : "ShardRouting is a relocation source but primary flag is different. This [" + this + "], target [" + other + "]";
        return b;
    }

    public boolean equalsIgnoringMetaData(ShardRouting other) {
        if (this.primary != other.primary) {
            return false;
        }
        if (this.shardId != other.shardId) {
            return false;
        }
        if (this.currentNodeId != null ? !this.currentNodeId.equals(other.currentNodeId) : other.currentNodeId != null) {
            return false;
        }
        if (this.index != null ? !this.index.equals(other.index) : other.index != null) {
            return false;
        }
        if (this.relocatingNodeId != null ? !this.relocatingNodeId.equals(other.relocatingNodeId) : other.relocatingNodeId != null) {
            return false;
        }
        if (this.allocationId != null ? !this.allocationId.equals(other.allocationId) : other.allocationId != null) {
            return false;
        }
        if (this.state != other.state) {
            return false;
        }
        return !(this.restoreSource != null ? !this.restoreSource.equals(other.restoreSource) : other.restoreSource != null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ShardRouting)) {
            return false;
        }
        ShardRouting that = (ShardRouting)o;
        if (this.version != that.version) {
            return false;
        }
        if (this.unassignedInfo != null ? !this.unassignedInfo.equals(that.unassignedInfo) : that.unassignedInfo != null) {
            return false;
        }
        return this.equalsIgnoringMetaData(that);
    }

    public int hashCode() {
        if (this.hashVersion == this.version) {
            return this.hashCode;
        }
        int result = this.index != null ? this.index.hashCode() : 0;
        result = 31 * result + this.shardId;
        result = 31 * result + (this.currentNodeId != null ? this.currentNodeId.hashCode() : 0);
        result = 31 * result + (this.relocatingNodeId != null ? this.relocatingNodeId.hashCode() : 0);
        result = 31 * result + (this.primary ? 1 : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        result = 31 * result + (this.restoreSource != null ? this.restoreSource.hashCode() : 0);
        result = 31 * result + (this.allocationId != null ? this.allocationId.hashCode() : 0);
        this.hashCode = result = 31 * result + (this.unassignedInfo != null ? this.unassignedInfo.hashCode() : 0);
        return this.hashCode;
    }

    public String toString() {
        return this.shortSummary();
    }

    public String shortSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.index).append(']').append('[').append(this.shardId).append(']');
        sb.append(", node[").append(this.currentNodeId).append("], ");
        if (this.relocatingNodeId != null) {
            sb.append("relocating [").append(this.relocatingNodeId).append("], ");
        }
        if (this.primary) {
            sb.append("[P]");
        } else {
            sb.append("[R]");
        }
        sb.append(", v[").append(this.version).append("]");
        if (this.restoreSource != null) {
            sb.append(", restoring[" + this.restoreSource + "]");
        }
        sb.append(", s[").append((Object)this.state).append("]");
        if (this.allocationId != null) {
            sb.append(", a").append(this.allocationId);
        }
        if (this.unassignedInfo != null) {
            sb.append(", ").append(this.unassignedInfo.toString());
        }
        if (this.expectedShardSize != -1L) {
            sb.append(", expected_shard_size[").append(this.expectedShardSize).append("]");
        }
        return sb.toString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("state", (Object)this.state()).field("primary", this.primary()).field("node", this.currentNodeId()).field("relocating_node", this.relocatingNodeId()).field("shard", this.shardId().id()).field("index", this.shardId().index().name()).field("version", this.version);
        if (this.expectedShardSize != -1L) {
            builder.field("expected_shard_size_in_bytes", this.expectedShardSize);
        }
        if (this.restoreSource() != null) {
            builder.field("restore_source");
            this.restoreSource().toXContent(builder, params);
        }
        if (this.allocationId != null) {
            this.allocationId.toXContent(builder, params);
        }
        if (this.unassignedInfo != null) {
            this.unassignedInfo.toXContent(builder, params);
        }
        return builder.endObject();
    }

    private void ensureNotFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("ShardRouting can't be modified anymore - already frozen");
        }
    }

    void freeze() {
        this.frozen = true;
    }

    boolean isFrozen() {
        return this.frozen;
    }

    public long getExpectedShardSize() {
        return this.expectedShardSize;
    }
}

