/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.Lucene43StopFilter;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.search.suggest.analyzing.SuggestStopFilter;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.settings.IndexSettingsService;

public class StopTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final CharArraySet stopWords;
    private final boolean ignoreCase;
    private final boolean enablePositionIncrements;
    private final boolean removeTrailing;

    @Inject
    public StopTokenFilterFactory(Index index, IndexSettingsService indexSettingsService, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettingsService.getSettings(), name, settings);
        this.ignoreCase = settings.getAsBoolean("ignore_case", (Boolean)false);
        this.removeTrailing = settings.getAsBoolean("remove_trailing", (Boolean)true);
        this.stopWords = Analysis.parseStopWords(env, settings, StopAnalyzer.ENGLISH_STOP_WORDS_SET, this.ignoreCase);
        if (this.version.onOrAfter(Version.LUCENE_4_4) && settings.get("enable_position_increments") != null) {
            throw new IllegalArgumentException("enable_position_increments is not supported anymore as of Lucene 4.4 as it can create broken token streams. Please fix your analysis chain or use an older compatibility version (<= 4.3).");
        }
        this.enablePositionIncrements = settings.getAsBoolean("enable_position_increments", (Boolean)true);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        if (this.removeTrailing) {
            if (this.version.onOrAfter(Version.LUCENE_4_4)) {
                return new StopFilter(tokenStream, this.stopWords);
            }
            return new Lucene43StopFilter(this.enablePositionIncrements, tokenStream, this.stopWords);
        }
        return new SuggestStopFilter(tokenStream, this.stopWords);
    }

    public Set<?> stopWords() {
        return this.stopWords;
    }

    public boolean ignoreCase() {
        return this.ignoreCase;
    }
}

