/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractTermsParametersParser;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;

public class TermsBuilder
extends ValuesSourceAggregationBuilder<TermsBuilder> {
    private TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(-1L, -1L, -1, -1);
    private Terms.ValueType valueType;
    private Terms.Order order;
    private String includePattern;
    private String excludePattern;
    private String executionHint;
    private Aggregator.SubAggCollectionMode collectionMode;
    private Boolean showTermDocCountError;
    private String[] includeTerms = null;
    private String[] excludeTerms = null;

    public TermsBuilder(String name) {
        super(name, "terms");
    }

    public TermsBuilder size(int size) {
        this.bucketCountThresholds.setRequiredSize(size);
        return this;
    }

    public TermsBuilder shardSize(int shardSize) {
        this.bucketCountThresholds.setShardSize(shardSize);
        return this;
    }

    public TermsBuilder minDocCount(long minDocCount) {
        this.bucketCountThresholds.setMinDocCount(minDocCount);
        return this;
    }

    public TermsBuilder shardMinDocCount(long shardMinDocCount) {
        this.bucketCountThresholds.setShardMinDocCount(shardMinDocCount);
        return this;
    }

    public TermsBuilder include(String regex) {
        if (this.includeTerms != null) {
            throw new IllegalArgumentException("exclude clause must be an array of strings or a regex, not both");
        }
        this.includePattern = regex;
        return this;
    }

    public TermsBuilder include(String[] terms) {
        if (this.includePattern != null) {
            throw new IllegalArgumentException("include clause must be an array of exact values or a regex, not both");
        }
        this.includeTerms = terms;
        return this;
    }

    public TermsBuilder include(long[] terms) {
        if (this.includePattern != null) {
            throw new IllegalArgumentException("include clause must be an array of exact values or a regex, not both");
        }
        this.includeTerms = this.longsArrToStringArr(terms);
        return this;
    }

    private String[] longsArrToStringArr(long[] terms) {
        String[] termsAsString = new String[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            termsAsString[i] = Long.toString(terms[i]);
        }
        return termsAsString;
    }

    public TermsBuilder include(double[] terms) {
        if (this.includePattern != null) {
            throw new IllegalArgumentException("include clause must be an array of exact values or a regex, not both");
        }
        this.includeTerms = this.doubleArrToStringArr(terms);
        return this;
    }

    private String[] doubleArrToStringArr(double[] terms) {
        String[] termsAsString = new String[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            termsAsString[i] = Double.toString(terms[i]);
        }
        return termsAsString;
    }

    public TermsBuilder exclude(String regex) {
        if (this.excludeTerms != null) {
            throw new IllegalArgumentException("exclude clause must be an array of exact values or a regex, not both");
        }
        this.excludePattern = regex;
        return this;
    }

    public TermsBuilder exclude(String[] terms) {
        if (this.excludePattern != null) {
            throw new IllegalArgumentException("exclude clause must be an array of exact values or a regex, not both");
        }
        this.excludeTerms = terms;
        return this;
    }

    public TermsBuilder exclude(long[] terms) {
        if (this.excludePattern != null) {
            throw new IllegalArgumentException("exclude clause must be an array of exact values or a regex, not both");
        }
        this.excludeTerms = this.longsArrToStringArr(terms);
        return this;
    }

    public TermsBuilder exclude(double[] terms) {
        if (this.excludePattern != null) {
            throw new IllegalArgumentException("exclude clause must be an array of exact values or a regex, not both");
        }
        this.excludeTerms = this.doubleArrToStringArr(terms);
        return this;
    }

    public TermsBuilder valueType(Terms.ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    public TermsBuilder order(Terms.Order order) {
        this.order = order;
        return this;
    }

    public TermsBuilder executionHint(String executionHint) {
        this.executionHint = executionHint;
        return this;
    }

    public TermsBuilder collectMode(Aggregator.SubAggCollectionMode mode) {
        this.collectionMode = mode;
        return this;
    }

    public TermsBuilder showTermDocCountError(boolean showTermDocCountError) {
        this.showTermDocCountError = showTermDocCountError;
        return this;
    }

    @Override
    protected XContentBuilder doInternalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.bucketCountThresholds.toXContent(builder);
        if (this.showTermDocCountError != null) {
            builder.field(AbstractTermsParametersParser.SHOW_TERM_DOC_COUNT_ERROR.getPreferredName(), (Object)this.showTermDocCountError);
        }
        if (this.executionHint != null) {
            builder.field(AbstractTermsParametersParser.EXECUTION_HINT_FIELD_NAME.getPreferredName(), this.executionHint);
        }
        if (this.valueType != null) {
            builder.field("value_type", this.valueType.name().toLowerCase(Locale.ROOT));
        }
        if (this.order != null) {
            builder.field("order");
            this.order.toXContent(builder, params);
        }
        if (this.collectionMode != null) {
            builder.field(Aggregator.SubAggCollectionMode.KEY.getPreferredName(), this.collectionMode.parseField().getPreferredName());
        }
        if (this.includeTerms != null) {
            builder.array("include", this.includeTerms);
        }
        if (this.includePattern != null) {
            builder.field("include", this.includePattern);
        }
        if (this.excludeTerms != null) {
            builder.array("exclude", this.excludeTerms);
        }
        if (this.excludePattern != null) {
            builder.field("exclude", this.excludePattern);
        }
        return builder;
    }
}

