/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding.snapround;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.noding.IntersectionFinderAdder;
import com.vividsolutions.jts.noding.MCIndexNoder;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.noding.Noder;
import com.vividsolutions.jts.noding.NodingValidator;
import com.vividsolutions.jts.noding.snapround.HotPixel;
import com.vividsolutions.jts.noding.snapround.MCIndexPointSnapper;
import java.util.Collection;
import java.util.List;

public class MCIndexSnapRounder
implements Noder {
    private final PrecisionModel pm;
    private LineIntersector li;
    private final double scaleFactor;
    private MCIndexNoder noder;
    private MCIndexPointSnapper pointSnapper;
    private Collection nodedSegStrings;

    public MCIndexSnapRounder(PrecisionModel pm) {
        this.pm = pm;
        this.li = new RobustLineIntersector();
        this.li.setPrecisionModel(pm);
        this.scaleFactor = pm.getScale();
    }

    public Collection getNodedSubstrings() {
        return NodedSegmentString.getNodedSubstrings(this.nodedSegStrings);
    }

    public void computeNodes(Collection inputSegmentStrings) {
        this.nodedSegStrings = inputSegmentStrings;
        this.noder = new MCIndexNoder();
        this.pointSnapper = new MCIndexPointSnapper(this.noder.getMonotoneChains(), this.noder.getIndex());
        this.snapRound(inputSegmentStrings, this.li);
    }

    private void checkCorrectness(Collection inputSegmentStrings) {
        List resultSegStrings = NodedSegmentString.getNodedSubstrings(inputSegmentStrings);
        NodingValidator nv = new NodingValidator(resultSegStrings);
        try {
            nv.checkValid();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void snapRound(Collection segStrings, LineIntersector li) {
        List intersections = this.findInteriorIntersections(segStrings, li);
        this.computeIntersectionSnaps(intersections);
        this.computeVertexSnaps(segStrings);
    }

    private List findInteriorIntersections(Collection segStrings, LineIntersector li) {
        IntersectionFinderAdder intFinderAdder = new IntersectionFinderAdder(li);
        this.noder.setSegmentIntersector(intFinderAdder);
        this.noder.computeNodes(segStrings);
        return intFinderAdder.getInteriorIntersections();
    }

    private void computeIntersectionSnaps(Collection snapPts) {
        for (Coordinate snapPt : snapPts) {
            HotPixel hotPixel = new HotPixel(snapPt, this.scaleFactor, this.li);
            this.pointSnapper.snap(hotPixel);
        }
    }

    public void computeVertexSnaps(Collection edges) {
        for (NodedSegmentString edge0 : edges) {
            this.computeVertexSnaps(edge0);
        }
    }

    private void computeVertexSnaps(NodedSegmentString e) {
        Coordinate[] pts0 = e.getCoordinates();
        for (int i = 0; i < pts0.length - 1; ++i) {
            HotPixel hotPixel = new HotPixel(pts0[i], this.scaleFactor, this.li);
            boolean isNodeAdded = this.pointSnapper.snap(hotPixel, e, i);
            if (!isNodeAdded) continue;
            e.addIntersection(pts0[i], i);
        }
    }
}

