/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import oracle.jdbc.OracleParameterMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.CopiedByteBinder;
import oracle.jdbc.driver.CopiedCharBinder;
import oracle.jdbc.driver.CopiedNullBinder;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatementReadOnly;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleReturnResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.jdbc.driver.PlsqlIndexTableAccessor;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.internal.ObjectData;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public abstract class OraclePreparedStatement
extends OracleStatement
implements oracle.jdbc.internal.OraclePreparedStatement,
ScrollRsetStatement {
    int numberOfBindRowsAllocated;
    static Binder theStaticVarnumCopyingBinder = OraclePreparedStatementReadOnly.theStaticVarnumCopyingBinder;
    static Binder theStaticVarnumNullBinder = OraclePreparedStatementReadOnly.theStaticVarnumNullBinder;
    Binder theVarnumNullBinder = theStaticVarnumNullBinder;
    static Binder theStaticBooleanBinder = OraclePreparedStatementReadOnly.theStaticBooleanBinder;
    Binder theBooleanBinder = theStaticBooleanBinder;
    static Binder theStaticByteBinder = OraclePreparedStatementReadOnly.theStaticByteBinder;
    Binder theByteBinder = theStaticByteBinder;
    static Binder theStaticShortBinder = OraclePreparedStatementReadOnly.theStaticShortBinder;
    Binder theShortBinder = theStaticShortBinder;
    static Binder theStaticIntBinder = OraclePreparedStatementReadOnly.theStaticIntBinder;
    Binder theIntBinder = theStaticIntBinder;
    static Binder theStaticLongBinder = OraclePreparedStatementReadOnly.theStaticLongBinder;
    Binder theLongBinder = theStaticLongBinder;
    static Binder theStaticFloatBinder = OraclePreparedStatementReadOnly.theStaticFloatBinder;
    Binder theFloatBinder = null;
    static Binder theStaticDoubleBinder = OraclePreparedStatementReadOnly.theStaticDoubleBinder;
    Binder theDoubleBinder = null;
    static Binder theStaticBigDecimalBinder = OraclePreparedStatementReadOnly.theStaticBigDecimalBinder;
    Binder theBigDecimalBinder = theStaticBigDecimalBinder;
    static Binder theStaticVarcharCopyingBinder = OraclePreparedStatementReadOnly.theStaticVarcharCopyingBinder;
    static Binder theStaticVarcharNullBinder = OraclePreparedStatementReadOnly.theStaticVarcharNullBinder;
    Binder theVarcharNullBinder = theStaticVarcharNullBinder;
    static Binder theStaticStringBinder = OraclePreparedStatementReadOnly.theStaticStringBinder;
    Binder theStringBinder = theStaticStringBinder;
    static Binder theStaticSetCHARCopyingBinder = OraclePreparedStatementReadOnly.theStaticSetCHARCopyingBinder;
    static Binder theStaticSetCHARBinder = OraclePreparedStatementReadOnly.theStaticSetCHARBinder;
    static Binder theStaticLittleEndianSetCHARBinder = OraclePreparedStatementReadOnly.theStaticLittleEndianSetCHARBinder;
    static Binder theStaticSetCHARNullBinder = OraclePreparedStatementReadOnly.theStaticSetCHARNullBinder;
    Binder theSetCHARBinder;
    Binder theSetCHARNullBinder = theStaticSetCHARNullBinder;
    static Binder theStaticFixedCHARCopyingBinder = OraclePreparedStatementReadOnly.theStaticFixedCHARCopyingBinder;
    static Binder theStaticFixedCHARBinder = OraclePreparedStatementReadOnly.theStaticFixedCHARBinder;
    static Binder theStaticFixedCHARNullBinder = OraclePreparedStatementReadOnly.theStaticFixedCHARNullBinder;
    Binder theFixedCHARBinder = theStaticFixedCHARBinder;
    Binder theFixedCHARNullBinder = theStaticFixedCHARNullBinder;
    static Binder theStaticDateCopyingBinder = OraclePreparedStatementReadOnly.theStaticDateCopyingBinder;
    static Binder theStaticDateBinder = OraclePreparedStatementReadOnly.theStaticDateBinder;
    static Binder theStaticDateNullBinder = OraclePreparedStatementReadOnly.theStaticDateNullBinder;
    Binder theDateBinder = theStaticDateBinder;
    Binder theDateNullBinder = theStaticDateNullBinder;
    static Binder theStaticTimeCopyingBinder = OraclePreparedStatementReadOnly.theStaticTimeCopyingBinder;
    static Binder theStaticTimeBinder = OraclePreparedStatementReadOnly.theStaticTimeBinder;
    Binder theTimeBinder = theStaticTimeBinder;
    static Binder theStaticTimestampCopyingBinder = OraclePreparedStatementReadOnly.theStaticTimestampCopyingBinder;
    static Binder theStaticTimestampBinder = OraclePreparedStatementReadOnly.theStaticTimestampBinder;
    static Binder theStaticTimestampNullBinder = OraclePreparedStatementReadOnly.theStaticTimestampNullBinder;
    Binder theTimestampBinder = theStaticTimestampBinder;
    Binder theTimestampNullBinder = theStaticTimestampNullBinder;
    static Binder theStaticOracleNumberBinder = OraclePreparedStatementReadOnly.theStaticOracleNumberBinder;
    Binder theOracleNumberBinder = theStaticOracleNumberBinder;
    static Binder theStaticOracleDateBinder = OraclePreparedStatementReadOnly.theStaticOracleDateBinder;
    Binder theOracleDateBinder = theStaticOracleDateBinder;
    static Binder theStaticOracleTimestampBinder = OraclePreparedStatementReadOnly.theStaticOracleTimestampBinder;
    Binder theOracleTimestampBinder = theStaticOracleTimestampBinder;
    static Binder theStaticTSTZCopyingBinder = OraclePreparedStatementReadOnly.theStaticTSTZCopyingBinder;
    static Binder theStaticTSTZBinder = OraclePreparedStatementReadOnly.theStaticTSTZBinder;
    static Binder theStaticTSTZNullBinder = OraclePreparedStatementReadOnly.theStaticTSTZNullBinder;
    Binder theTSTZBinder = theStaticTSTZBinder;
    Binder theTSTZNullBinder = theStaticTSTZNullBinder;
    static Binder theStaticTSLTZCopyingBinder = OraclePreparedStatementReadOnly.theStaticTSLTZCopyingBinder;
    static Binder theStaticTSLTZBinder = OraclePreparedStatementReadOnly.theStaticTSLTZBinder;
    static Binder theStaticTSLTZNullBinder = OraclePreparedStatementReadOnly.theStaticTSLTZNullBinder;
    Binder theTSLTZBinder = theStaticTSLTZBinder;
    Binder theTSLTZNullBinder = theStaticTSLTZNullBinder;
    static Binder theStaticRowidCopyingBinder = OraclePreparedStatementReadOnly.theStaticRowidCopyingBinder;
    static Binder theStaticRowidBinder = OraclePreparedStatementReadOnly.theStaticRowidBinder;
    static Binder theStaticLittleEndianRowidBinder = OraclePreparedStatementReadOnly.theStaticLittleEndianRowidBinder;
    static Binder theStaticRowidNullBinder = OraclePreparedStatementReadOnly.theStaticRowidNullBinder;
    Binder theRowidBinder;
    Binder theRowidNullBinder = theStaticRowidNullBinder;
    static Binder theStaticIntervalDSCopyingBinder = OraclePreparedStatementReadOnly.theStaticIntervalDSCopyingBinder;
    static Binder theStaticIntervalDSBinder = OraclePreparedStatementReadOnly.theStaticIntervalDSBinder;
    static Binder theStaticIntervalDSNullBinder = OraclePreparedStatementReadOnly.theStaticIntervalDSNullBinder;
    Binder theIntervalDSBinder = theStaticIntervalDSBinder;
    Binder theIntervalDSNullBinder = theStaticIntervalDSNullBinder;
    static Binder theStaticIntervalYMCopyingBinder = OraclePreparedStatementReadOnly.theStaticIntervalYMCopyingBinder;
    static Binder theStaticIntervalYMBinder = OraclePreparedStatementReadOnly.theStaticIntervalYMBinder;
    static Binder theStaticIntervalYMNullBinder = OraclePreparedStatementReadOnly.theStaticIntervalYMNullBinder;
    Binder theIntervalYMBinder = theStaticIntervalYMBinder;
    Binder theIntervalYMNullBinder = theStaticIntervalYMNullBinder;
    static Binder theStaticBfileCopyingBinder = OraclePreparedStatementReadOnly.theStaticBfileCopyingBinder;
    static Binder theStaticBfileBinder = OraclePreparedStatementReadOnly.theStaticBfileBinder;
    static Binder theStaticBfileNullBinder = OraclePreparedStatementReadOnly.theStaticBfileNullBinder;
    Binder theBfileBinder = theStaticBfileBinder;
    Binder theBfileNullBinder = theStaticBfileNullBinder;
    static Binder theStaticBlobCopyingBinder = OraclePreparedStatementReadOnly.theStaticBlobCopyingBinder;
    static Binder theStaticBlobBinder = OraclePreparedStatementReadOnly.theStaticBlobBinder;
    static Binder theStaticBlobNullBinder = OraclePreparedStatementReadOnly.theStaticBlobNullBinder;
    Binder theBlobBinder = theStaticBlobBinder;
    Binder theBlobNullBinder = theStaticBlobNullBinder;
    static Binder theStaticClobCopyingBinder = OraclePreparedStatementReadOnly.theStaticClobCopyingBinder;
    static Binder theStaticClobBinder = OraclePreparedStatementReadOnly.theStaticClobBinder;
    static Binder theStaticClobNullBinder = OraclePreparedStatementReadOnly.theStaticClobNullBinder;
    Binder theClobBinder = theStaticClobBinder;
    Binder theClobNullBinder = theStaticClobNullBinder;
    static Binder theStaticRawCopyingBinder = OraclePreparedStatementReadOnly.theStaticRawCopyingBinder;
    static Binder theStaticRawBinder = OraclePreparedStatementReadOnly.theStaticRawBinder;
    static Binder theStaticRawNullBinder = OraclePreparedStatementReadOnly.theStaticRawNullBinder;
    Binder theRawBinder = theStaticRawBinder;
    Binder theRawNullBinder = theStaticRawNullBinder;
    static Binder theStaticPlsqlRawCopyingBinder = OraclePreparedStatementReadOnly.theStaticPlsqlRawCopyingBinder;
    static Binder theStaticPlsqlRawBinder = OraclePreparedStatementReadOnly.theStaticPlsqlRawBinder;
    Binder thePlsqlRawBinder = theStaticPlsqlRawBinder;
    static Binder theStaticBinaryFloatCopyingBinder = OraclePreparedStatementReadOnly.theStaticBinaryFloatCopyingBinder;
    static Binder theStaticBinaryFloatBinder = OraclePreparedStatementReadOnly.theStaticBinaryFloatBinder;
    static Binder theStaticBinaryFloatNullBinder = OraclePreparedStatementReadOnly.theStaticBinaryFloatNullBinder;
    Binder theBinaryFloatBinder = theStaticBinaryFloatBinder;
    Binder theBinaryFloatNullBinder = theStaticBinaryFloatNullBinder;
    static Binder theStaticBINARY_FLOATCopyingBinder = OraclePreparedStatementReadOnly.theStaticBINARY_FLOATCopyingBinder;
    static Binder theStaticBINARY_FLOATBinder = OraclePreparedStatementReadOnly.theStaticBINARY_FLOATBinder;
    static Binder theStaticBINARY_FLOATNullBinder = OraclePreparedStatementReadOnly.theStaticBINARY_FLOATNullBinder;
    Binder theBINARY_FLOATBinder = theStaticBINARY_FLOATBinder;
    Binder theBINARY_FLOATNullBinder = theStaticBINARY_FLOATNullBinder;
    static Binder theStaticBinaryDoubleCopyingBinder = OraclePreparedStatementReadOnly.theStaticBinaryDoubleCopyingBinder;
    static Binder theStaticBinaryDoubleBinder = OraclePreparedStatementReadOnly.theStaticBinaryDoubleBinder;
    static Binder theStaticBinaryDoubleNullBinder = OraclePreparedStatementReadOnly.theStaticBinaryDoubleNullBinder;
    Binder theBinaryDoubleBinder = theStaticBinaryDoubleBinder;
    Binder theBinaryDoubleNullBinder = theStaticBinaryDoubleNullBinder;
    static Binder theStaticBINARY_DOUBLECopyingBinder = OraclePreparedStatementReadOnly.theStaticBINARY_DOUBLECopyingBinder;
    static Binder theStaticBINARY_DOUBLEBinder = OraclePreparedStatementReadOnly.theStaticBINARY_DOUBLEBinder;
    static Binder theStaticBINARY_DOUBLENullBinder = OraclePreparedStatementReadOnly.theStaticBINARY_DOUBLENullBinder;
    Binder theBINARY_DOUBLEBinder = theStaticBINARY_DOUBLEBinder;
    Binder theBINARY_DOUBLENullBinder = theStaticBINARY_DOUBLENullBinder;
    static Binder theStaticLongStreamBinder = OraclePreparedStatementReadOnly.theStaticLongStreamBinder;
    Binder theLongStreamBinder = theStaticLongStreamBinder;
    static Binder theStaticLongRawStreamBinder = OraclePreparedStatementReadOnly.theStaticLongRawStreamBinder;
    Binder theLongRawStreamBinder = theStaticLongRawStreamBinder;
    static Binder theStaticNamedTypeCopyingBinder = OraclePreparedStatementReadOnly.theStaticNamedTypeCopyingBinder;
    static Binder theStaticNamedTypeBinder = OraclePreparedStatementReadOnly.theStaticNamedTypeBinder;
    static Binder theStaticNamedTypeNullBinder = OraclePreparedStatementReadOnly.theStaticNamedTypeNullBinder;
    Binder theNamedTypeBinder = theStaticNamedTypeBinder;
    Binder theNamedTypeNullBinder = theStaticNamedTypeNullBinder;
    static Binder theStaticRefTypeCopyingBinder = OraclePreparedStatementReadOnly.theStaticRefTypeCopyingBinder;
    static Binder theStaticRefTypeBinder = OraclePreparedStatementReadOnly.theStaticRefTypeBinder;
    static Binder theStaticRefTypeNullBinder = OraclePreparedStatementReadOnly.theStaticRefTypeNullBinder;
    Binder theRefTypeBinder = theStaticRefTypeBinder;
    Binder theRefTypeNullBinder = theStaticRefTypeNullBinder;
    static Binder theStaticPlsqlIbtCopyingBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtCopyingBinder;
    static Binder theStaticPlsqlIbtBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtBinder;
    static Binder theStaticPlsqlIbtNullBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtNullBinder;
    Binder thePlsqlIbtBinder = theStaticPlsqlIbtBinder;
    Binder thePlsqlNullBinder = theStaticPlsqlIbtNullBinder;
    static Binder theStaticOutBinder = OraclePreparedStatementReadOnly.theStaticOutBinder;
    Binder theOutBinder = theStaticOutBinder;
    static Binder theStaticReturnParamBinder = OraclePreparedStatementReadOnly.theStaticReturnParamBinder;
    Binder theReturnParamBinder = theStaticReturnParamBinder;
    static Binder theStaticT4CRowidBinder = OraclePreparedStatementReadOnly.theStaticT4CRowidBinder;
    static Binder theStaticT4CRowidNullBinder = OraclePreparedStatementReadOnly.theStaticT4CRowidNullBinder;
    public static final int TypeBinder_BYTELEN = 24;
    char[] digits = new char[20];
    Binder[][] binders;
    int[][] parameterInt;
    long[][] parameterLong;
    float[][] parameterFloat;
    double[][] parameterDouble;
    BigDecimal[][] parameterBigDecimal;
    String[][] parameterString;
    Date[][] parameterDate;
    Time[][] parameterTime;
    Timestamp[][] parameterTimestamp;
    byte[][][] parameterDatum;
    OracleTypeADT[][] parameterOtype;
    PlsqlIbtBindInfo[][] parameterPlsqlIbt;
    Binder[] currentRowBinders;
    int[] currentRowCharLens;
    Accessor[] currentRowBindAccessors;
    short[] currentRowFormOfUse;
    boolean currentRowNeedToPrepareBinds = true;
    int[] currentBatchCharLens;
    Accessor[] currentBatchBindAccessors;
    short[] currentBatchFormOfUse;
    boolean currentBatchNeedToPrepareBinds;
    PushedBatch pushedBatches;
    PushedBatch pushedBatchesTail;
    int totalBindByteLength;
    int totalBindCharLength;
    int totalBindIndicatorLength;
    static final int BIND_METADATA_NUMBER_OF_BIND_POSITIONS_OFFSET = 0;
    static final int BIND_METADATA_BIND_BUFFER_CAPACITY_OFFSET = 1;
    static final int BIND_METADATA_NUMBER_OF_BOUND_ROWS_OFFSET = 2;
    static final int BIND_METADATA_PER_POSITION_DATA_OFFSET = 3;
    static final int BIND_METADATA_TYPE_OFFSET = 0;
    static final int BIND_METADATA_BYTE_PITCH_OFFSET = 1;
    static final int BIND_METADATA_CHAR_PITCH_OFFSET = 2;
    static final int BIND_METADATA_VALUE_DATA_OFFSET_HI = 3;
    static final int BIND_METADATA_VALUE_DATA_OFFSET_LO = 4;
    static final int BIND_METADATA_NULL_INDICATORS_OFFSET_HI = 5;
    static final int BIND_METADATA_NULL_INDICATORS_OFFSET_LO = 6;
    static final int BIND_METADATA_VALUE_LENGTHS_OFFSET_HI = 7;
    static final int BIND_METADATA_VALUE_LENGTHS_OFFSET_LO = 8;
    static final int BIND_METADATA_FORM_OF_USE_OFFSET = 9;
    static final int BIND_METADATA_PER_POSITION_SIZE = 10;
    int bindBufferCapacity;
    int numberOfBoundRows;
    int indicatorsOffset;
    int valueLengthsOffset;
    boolean preparedAllBinds;
    boolean preparedCharBinds;
    Binder[] lastBinders;
    byte[] lastBoundBytes;
    int lastBoundByteOffset;
    char[] lastBoundChars;
    int lastBoundCharOffset;
    int[] lastBoundByteOffsets;
    int[] lastBoundCharOffsets;
    int[] lastBoundByteLens;
    int[] lastBoundCharLens;
    short[] lastBoundInds;
    short[] lastBoundLens;
    boolean lastBoundNeeded = false;
    byte[][] lastBoundTypeBytes;
    OracleTypeADT[] lastBoundTypeOtypes;
    private static final int STREAM_MAX_BYTES_SQL = Integer.MAX_VALUE;
    int maxRawBytesSql;
    int maxRawBytesPlsql;
    int maxVcsCharsSql;
    int maxVcsBytesPlsql;
    private int maxCharSize = 0;
    private int maxNCharSize = 0;
    private int charMaxCharsSql = 0;
    private int charMaxNCharsSql = 0;
    private int maxVcsCharsPlsql = 0;
    private int maxVcsNCharsPlsql = 0;
    private int maxStreamCharsSql = 0;
    private int maxStreamNCharsSql = 0;
    private boolean isServerCharSetFixedWidth = false;
    private boolean isServerNCharSetFixedWidth = false;
    int minVcsBindSize;
    int prematureBatchCount;
    boolean checkBindTypes = true;
    boolean scrollRsetTypeSolved;
    int SetBigStringTryClob = 0;
    static final int BSTYLE_UNKNOWN = 0;
    static final int BSTYLE_ORACLE = 1;
    static final int BSTYLE_JDBC = 2;
    int m_batchStyle = 0;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:30:51_PDT_2005";

    OraclePreparedStatement(PhysicalConnection conn, String sql, int batchValue, int rowPrefetchValue) throws SQLException {
        this(conn, sql, batchValue, rowPrefetchValue, 1003, 1007);
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.OraclePreparedStatement(conn, sql, batchValue, rowPrefetchValue)", this);
            OracleLog.recursiveTrace = false;
        }
    }

    OraclePreparedStatement(PhysicalConnection conn, String sql, int batch_value, int row_prefetch_value, int UserResultSetType, int UserResultSetConcur) throws SQLException {
        super(conn, batch_value, row_prefetch_value, UserResultSetType, UserResultSetConcur);
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.OraclePreparedStatement(conn, sql, batchValue, rowPrefetchValue, UserResultSetType)", this);
            OracleLog.recursiveTrace = false;
        }
        this.theSetCHARBinder = conn.useLittleEndianSetCHARBinder() ? theStaticLittleEndianSetCHARBinder : theStaticSetCHARBinder;
        this.theRowidBinder = conn.useLittleEndianSetCHARBinder() ? theStaticLittleEndianRowidBinder : theStaticRowidBinder;
        this.statementType = 1;
        this.currentRow = -1;
        this.needToParse = true;
        this.processEscapes = conn.processEscapes;
        this.sqlObject.initialize(sql);
        this.sqlKind = this.sqlObject.getSqlKind();
        this.clearParameters = true;
        this.scrollRsetTypeSolved = false;
        this.prematureBatchCount = 0;
        this.initializeBinds();
        this.minVcsBindSize = conn.minVcsBindSize;
        this.maxRawBytesSql = conn.maxRawBytesSql;
        this.maxRawBytesPlsql = conn.maxRawBytesPlsql;
        this.maxVcsCharsSql = conn.maxVcsCharsSql;
        this.maxVcsBytesPlsql = conn.maxVcsBytesPlsql;
        this.maxCharSize = this.connection.conversion.sMaxCharSize;
        this.maxNCharSize = this.connection.conversion.maxNCharSize;
        this.maxVcsCharsPlsql = this.maxVcsBytesPlsql / this.maxCharSize;
        this.maxVcsNCharsPlsql = this.maxVcsBytesPlsql / this.maxNCharSize;
        this.maxStreamCharsSql = Integer.MAX_VALUE / this.maxCharSize;
        this.maxStreamNCharsSql = this.maxRawBytesSql / this.maxNCharSize;
        this.isServerCharSetFixedWidth = this.connection.conversion.isServerCharSetFixedWidth;
        this.isServerNCharSetFixedWidth = this.connection.conversion.isServerNCharSetFixedWidth;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.OraclePreparedStatement(conn, sql, UserResultSetType):return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    void allocBinds(int new_number_of_bind_rows_allocated) throws SQLException {
        boolean growing = new_number_of_bind_rows_allocated > this.numberOfBindRowsAllocated;
        this.initializeIndicatorSubRange();
        int preambleSize = this.bindIndicatorSubRange + 3 + this.numberOfBindPositions * 10;
        int dataSizeTerm = new_number_of_bind_rows_allocated * this.numberOfBindPositions;
        int indicatorSize = preambleSize + 2 * dataSizeTerm;
        if (indicatorSize > this.totalBindIndicatorLength) {
            short[] oldBindIndicators = this.bindIndicators;
            int oldBindIndicatorOffset = this.bindIndicatorOffset;
            this.bindIndicatorOffset = 0;
            this.bindIndicators = new short[indicatorSize];
            this.totalBindIndicatorLength = indicatorSize;
            if (oldBindIndicators != null && growing) {
                System.arraycopy(oldBindIndicators, oldBindIndicatorOffset, this.bindIndicators, this.bindIndicatorOffset, preambleSize);
            }
        }
        this.bindIndicatorSubRange += this.bindIndicatorOffset;
        this.bindIndicators[this.bindIndicatorSubRange + 0] = (short)this.numberOfBindPositions;
        this.indicatorsOffset = this.bindIndicatorOffset + preambleSize;
        this.valueLengthsOffset = this.indicatorsOffset + dataSizeTerm;
        int indoffset = this.indicatorsOffset;
        int lenoffset = this.valueLengthsOffset;
        int metadata_offset = this.bindIndicatorSubRange + 3;
        for (int i = 0; i < this.numberOfBindPositions; ++i) {
            this.bindIndicators[metadata_offset + 5] = (short)(indoffset >> 16);
            this.bindIndicators[metadata_offset + 6] = (short)(indoffset & 0xFFFF);
            this.bindIndicators[metadata_offset + 7] = (short)(lenoffset >> 16);
            this.bindIndicators[metadata_offset + 8] = (short)(lenoffset & 0xFFFF);
            indoffset += new_number_of_bind_rows_allocated;
            lenoffset += new_number_of_bind_rows_allocated;
            metadata_offset += 10;
        }
    }

    void initializeBinds() throws SQLException {
        this.numberOfBindPositions = this.sqlObject.getParameterCount();
        if (this.numberOfBindPositions == 0) {
            this.currentRowNeedToPrepareBinds = false;
            return;
        }
        this.numberOfBindRowsAllocated = this.batch;
        this.binders = new Binder[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        this.currentRowBinders = this.binders[0];
        this.currentRowCharLens = new int[this.numberOfBindPositions];
        this.currentBatchCharLens = new int[this.numberOfBindPositions];
        this.currentRowFormOfUse = new short[this.numberOfBindPositions];
        this.currentBatchFormOfUse = new short[this.numberOfBindPositions];
        int defaultFormOfUse = 1;
        if (this.connection.defaultNChar) {
            defaultFormOfUse = 2;
        }
        for (int i = 0; i < this.numberOfBindPositions; ++i) {
            this.currentRowFormOfUse[i] = defaultFormOfUse;
            this.currentBatchFormOfUse[i] = defaultFormOfUse;
        }
        this.lastBinders = new Binder[this.numberOfBindPositions];
        this.lastBoundCharLens = new int[this.numberOfBindPositions];
        this.lastBoundByteOffsets = new int[this.numberOfBindPositions];
        this.lastBoundCharOffsets = new int[this.numberOfBindPositions];
        this.lastBoundByteLens = new int[this.numberOfBindPositions];
        this.lastBoundInds = new short[this.numberOfBindPositions];
        this.lastBoundLens = new short[this.numberOfBindPositions];
        this.lastBoundTypeBytes = new byte[this.numberOfBindPositions][];
        this.lastBoundTypeOtypes = new OracleTypeADT[this.numberOfBindPositions];
        this.allocBinds(this.numberOfBindRowsAllocated);
    }

    void growBinds(int new_number_of_bind_rows_allocated) throws SQLException {
        int i;
        Binder[][] oldBinders = this.binders;
        this.binders = new Binder[new_number_of_bind_rows_allocated][];
        if (oldBinders != null) {
            System.arraycopy(oldBinders, 0, this.binders, 0, this.numberOfBindRowsAllocated);
        }
        for (i = this.numberOfBindRowsAllocated; i < new_number_of_bind_rows_allocated; ++i) {
            this.binders[i] = new Binder[this.numberOfBindPositions];
        }
        this.allocBinds(new_number_of_bind_rows_allocated);
        if (this.parameterInt != null) {
            int[][] oldParameterInt = this.parameterInt;
            this.parameterInt = new int[new_number_of_bind_rows_allocated][];
            System.arraycopy(oldParameterInt, 0, this.parameterInt, 0, this.numberOfBindRowsAllocated);
            for (i = this.numberOfBindRowsAllocated; i < new_number_of_bind_rows_allocated; ++i) {
                this.parameterInt[i] = new int[this.numberOfBindPositions];
            }
        }
        if (this.parameterLong != null) {
            long[][] oldParameterLong = this.parameterLong;
            this.parameterLong = new long[new_number_of_bind_rows_allocated][];
            System.arraycopy(oldParameterLong, 0, this.parameterLong, 0, this.numberOfBindRowsAllocated);
            for (i = this.numberOfBindRowsAllocated; i < new_number_of_bind_rows_allocated; ++i) {
                this.parameterLong[i] = new long[this.numberOfBindPositions];
            }
        }
        if (this.parameterFloat != null) {
            float[][] oldParameterFloat = this.parameterFloat;
            this.parameterFloat = new float[new_number_of_bind_rows_allocated][];
            System.arraycopy(oldParameterFloat, 0, this.parameterFloat, 0, this.numberOfBindRowsAllocated);
            for (i = this.numberOfBindRowsAllocated; i < new_number_of_bind_rows_allocated; ++i) {
                this.parameterFloat[i] = new float[this.numberOfBindPositions];
            }
        }
        if (this.parameterDouble != null) {
            double[][] oldParameterDouble = this.parameterDouble;
            this.parameterDouble = new double[new_number_of_bind_rows_allocated][];
            System.arraycopy(oldParameterDouble, 0, this.parameterDouble, 0, this.numberOfBindRowsAllocated);
            for (i = this.numberOfBindRowsAllocated; i < new_number_of_bind_rows_allocated; ++i) {
                this.parameterDouble[i] = new double[this.numberOfBindPositions];
            }
        }
        if (this.parameterBigDecimal != null) {
            BigDecimal[][] oldParameterBigDecimal = this.parameterBigDecimal;
            this.parameterBigDecimal = new BigDecimal[new_number_of_bind_rows_allocated][];
            System.arraycopy(oldParameterBigDecimal, 0, this.parameterBigDecimal, 0, this.numberOfBindRowsAllocated);
            for (i = this.numberOfBindRowsAllocated; i < new_number_of_bind_rows_allocated; ++i) {
                this.parameterBigDecimal[i] = new BigDecimal[this.numberOfBindPositions];
            }
        }
        if (this.parameterString != null) {
            String[][] oldParameterString = this.parameterString;
            this.parameterString = new String[new_number_of_bind_rows_allocated][];
            System.arraycopy(oldParameterString, 0, this.parameterString, 0, this.numberOfBindRowsAllocated);
            for (i = this.numberOfBindRowsAllocated; i < new_number_of_bind_rows_allocated; ++i) {
                this.parameterString[i] = new String[this.numberOfBindPositions];
            }
        }
        if (this.parameterDate != null) {
            Date[][] oldParameterDate = this.parameterDate;
            this.parameterDate = new Date[new_number_of_bind_rows_allocated][];
            System.arraycopy(oldParameterDate, 0, this.parameterDate, 0, this.numberOfBindRowsAllocated);
            for (i = this.numberOfBindRowsAllocated; i < new_number_of_bind_rows_allocated; ++i) {
                this.parameterDate[i] = new Date[this.numberOfBindPositions];
            }
        }
        if (this.parameterTime != null) {
            Time[][] oldParameterTime = this.parameterTime;
            this.parameterTime = new Time[new_number_of_bind_rows_allocated][];
            System.arraycopy(oldParameterTime, 0, this.parameterTime, 0, this.numberOfBindRowsAllocated);
            for (i = this.numberOfBindRowsAllocated; i < new_number_of_bind_rows_allocated; ++i) {
                this.parameterTime[i] = new Time[this.numberOfBindPositions];
            }
        }
        if (this.parameterTimestamp != null) {
            Timestamp[][] oldParameterTimestamp = this.parameterTimestamp;
            this.parameterTimestamp = new Timestamp[new_number_of_bind_rows_allocated][];
            System.arraycopy(oldParameterTimestamp, 0, this.parameterTimestamp, 0, this.numberOfBindRowsAllocated);
            for (i = this.numberOfBindRowsAllocated; i < new_number_of_bind_rows_allocated; ++i) {
                this.parameterTimestamp[i] = new Timestamp[this.numberOfBindPositions];
            }
        }
        if (this.parameterDatum != null) {
            byte[][][] oldParameterDatum = this.parameterDatum;
            this.parameterDatum = new byte[new_number_of_bind_rows_allocated][][];
            System.arraycopy(oldParameterDatum, 0, this.parameterDatum, 0, this.numberOfBindRowsAllocated);
            for (i = this.numberOfBindRowsAllocated; i < new_number_of_bind_rows_allocated; ++i) {
                this.parameterDatum[i] = new byte[this.numberOfBindPositions][];
            }
        }
        if (this.parameterOtype != null) {
            OracleTypeADT[][] oldParameterOtype = this.parameterOtype;
            this.parameterOtype = new OracleTypeADT[new_number_of_bind_rows_allocated][];
            System.arraycopy(oldParameterOtype, 0, this.parameterOtype, 0, this.numberOfBindRowsAllocated);
            for (i = this.numberOfBindRowsAllocated; i < new_number_of_bind_rows_allocated; ++i) {
                this.parameterOtype[i] = new OracleTypeADT[this.numberOfBindPositions];
            }
        }
        if (this.parameterStream != null) {
            InputStream[][] oldParameterStream = this.parameterStream;
            this.parameterStream = new InputStream[new_number_of_bind_rows_allocated][];
            System.arraycopy(oldParameterStream, 0, this.parameterStream, 0, this.numberOfBindRowsAllocated);
            for (i = this.numberOfBindRowsAllocated; i < new_number_of_bind_rows_allocated; ++i) {
                this.parameterStream[i] = new InputStream[this.numberOfBindPositions];
            }
        }
        if (this.parameterPlsqlIbt != null) {
            PlsqlIbtBindInfo[][] oldParameterPlsqlIbt = this.parameterPlsqlIbt;
            this.parameterPlsqlIbt = new PlsqlIbtBindInfo[new_number_of_bind_rows_allocated][];
            System.arraycopy(oldParameterPlsqlIbt, 0, this.parameterPlsqlIbt, 0, this.numberOfBindRowsAllocated);
            for (i = this.numberOfBindRowsAllocated; i < new_number_of_bind_rows_allocated; ++i) {
                this.parameterPlsqlIbt[i] = new PlsqlIbtBindInfo[this.numberOfBindPositions];
            }
        }
        this.numberOfBindRowsAllocated = new_number_of_bind_rows_allocated;
        this.currentRowNeedToPrepareBinds = true;
    }

    void processCompletedBindRow(int number_of_rows_in_batch, boolean batchForPlsql) throws SQLException {
        int nextRank;
        Binder binder;
        Binder binder2;
        OracleTypeADT[] prevOtypes;
        int i;
        Binder[] prevBinders;
        boolean isFirstRowInBatch;
        if (this.numberOfBindPositions == 0) {
            return;
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "processCompletedBindRow(" + number_of_rows_in_batch + ", " + batchForPlsql + ")" + " currentRank " + this.currentRank + " checkBindTypes " + this.checkBindTypes, this);
            OracleLog.recursiveTrace = false;
        }
        boolean bindTypeChange = false;
        boolean bindTypeConflict = false;
        boolean bl = isFirstRowInBatch = this.currentRank == this.firstRowInBatch;
        Binder[] binderArray = this.currentRank == 0 ? (this.lastBinders[0] == null ? null : this.lastBinders) : (prevBinders = this.binders[this.currentRank - 1]);
        if (this.currentRowBindAccessors == null) {
            if (prevBinders == null) {
                for (i = 0; i < this.numberOfBindPositions; ++i) {
                    if (this.currentRowBinders[i] != null) continue;
                    DatabaseError.throwSqlException(41, new Integer(i + 1));
                }
            } else if (this.checkBindTypes) {
                prevOtypes = this.currentRank == 0 ? this.lastBoundTypeOtypes : (this.parameterOtype == null ? null : this.parameterOtype[this.currentRank - 1]);
                for (i = 0; i < this.numberOfBindPositions; ++i) {
                    binder2 = this.currentRowBinders[i];
                    if (binder2 == null) {
                        if (this.clearParameters) {
                            DatabaseError.throwSqlException(41, new Integer(i + 1));
                        }
                        this.currentRowBinders[i] = prevBinders[i].copyingBinder();
                        this.currentRowCharLens[i] = -1;
                        if (isFirstRowInBatch) {
                            this.lastBoundNeeded = true;
                        }
                    } else {
                        short type = binder2.type;
                        if (type != prevBinders[i].type || (type == 109 || type == 111) && !this.parameterOtype[this.currentRank][i].isInHierarchyOf(prevOtypes[i]) || type == 9 && binder2.bytelen == 0 != (prevBinders[i].bytelen == 0)) {
                            bindTypeChange = true;
                        }
                    }
                    if (this.currentBatchFormOfUse[i] == this.currentRowFormOfUse[i]) continue;
                    bindTypeChange = true;
                }
            } else {
                for (i = 0; i < this.numberOfBindPositions; ++i) {
                    binder = this.currentRowBinders[i];
                    if (binder != null) continue;
                    if (this.clearParameters) {
                        DatabaseError.throwSqlException(41, new Integer(i + 1));
                    }
                    this.currentRowBinders[i] = prevBinders[i].copyingBinder();
                    this.currentRowCharLens[i] = -1;
                    if (!isFirstRowInBatch) continue;
                    this.lastBoundNeeded = true;
                }
            }
        } else if (prevBinders == null) {
            for (i = 0; i < this.numberOfBindPositions; ++i) {
                binder = this.currentRowBinders[i];
                Accessor accessor = this.currentRowBindAccessors[i];
                if (binder == null) {
                    if (accessor == null) {
                        DatabaseError.throwSqlException(41, new Integer(i + 1));
                        continue;
                    }
                    this.currentRowBinders[i] = this.theOutBinder;
                    continue;
                }
                if (accessor == null || accessor.defineType == binder.type || this.connection.looseTimestampDateCheck && binder.type == 180 && accessor.defineType == 12) continue;
                bindTypeConflict = true;
            }
        } else if (this.checkBindTypes) {
            prevOtypes = this.currentRank == 0 ? this.lastBoundTypeOtypes : (this.parameterOtype == null ? null : this.parameterOtype[this.currentRank - 1]);
            for (i = 0; i < this.numberOfBindPositions; ++i) {
                binder2 = this.currentRowBinders[i];
                Accessor accessor = this.currentRowBindAccessors[i];
                if (binder2 == null) {
                    if (this.clearParameters && prevBinders[i] != this.theOutBinder) {
                        DatabaseError.throwSqlException(41, new Integer(i + 1));
                    }
                    this.currentRowBinders[i] = binder2 = prevBinders[i];
                    this.currentRowCharLens[i] = -1;
                    if (isFirstRowInBatch && binder2 != this.theOutBinder) {
                        this.lastBoundNeeded = true;
                    }
                } else {
                    short type = binder2.type;
                    if (type != prevBinders[i].type || (type == 109 || type == 111) && !this.parameterOtype[this.currentRank][i].isInHierarchyOf(prevOtypes[i]) || type == 9 && binder2.bytelen == 0 != (prevBinders[i].bytelen == 0)) {
                        bindTypeChange = true;
                    }
                }
                if (this.currentBatchFormOfUse[i] != this.currentRowFormOfUse[i]) {
                    bindTypeChange = true;
                }
                Accessor lastAccessor = this.currentBatchBindAccessors[i];
                if (accessor == null) {
                    this.currentRowBindAccessors[i] = accessor = lastAccessor;
                } else if (lastAccessor != null && accessor.defineType != lastAccessor.defineType) {
                    bindTypeChange = true;
                }
                if (accessor == null || binder2 == this.theOutBinder || accessor.defineType == binder2.type || this.connection.looseTimestampDateCheck && binder2.type == 180 && accessor.defineType == 12) continue;
                bindTypeConflict = true;
            }
        } else {
            for (i = 0; i < this.numberOfBindPositions; ++i) {
                binder = this.currentRowBinders[i];
                if (binder == null) {
                    if (this.clearParameters && prevBinders[i] != this.theOutBinder) {
                        DatabaseError.throwSqlException(41, new Integer(i + 1));
                    }
                    this.currentRowBinders[i] = binder = prevBinders[i];
                    this.currentRowCharLens[i] = -1;
                    if (isFirstRowInBatch && binder != this.theOutBinder) {
                        this.lastBoundNeeded = true;
                    }
                }
                if (this.currentRowBindAccessors[i] != null) continue;
                this.currentRowBindAccessors[i] = this.currentBatchBindAccessors[i];
            }
        }
        if (bindTypeChange) {
            if (!isFirstRowInBatch) {
                if (this.m_batchStyle == 2) {
                    this.pushBatch(false);
                } else {
                    int save_valid_rows = this.validRows;
                    this.prematureBatchCount = this.sendBatch();
                    this.validRows = save_valid_rows;
                }
            }
            this.needToParse = true;
            this.currentRowNeedToPrepareBinds = true;
        } else if (batchForPlsql) {
            this.pushBatch(false);
            this.needToParse = false;
            this.currentBatchNeedToPrepareBinds = false;
        }
        if (bindTypeConflict) {
            DatabaseError.throwSqlException(12);
        }
        for (i = 0; i < this.numberOfBindPositions; ++i) {
            int charlen = this.currentRowCharLens[i];
            if (charlen == -1) {
                charlen = this.lastBoundCharLens[i];
            }
            if (this.currentBatchCharLens[i] < charlen) {
                this.currentBatchCharLens[i] = charlen;
            }
            this.currentRowCharLens[i] = 0;
            this.currentBatchFormOfUse[i] = this.currentRowFormOfUse[i];
        }
        if (this.currentRowNeedToPrepareBinds) {
            this.currentBatchNeedToPrepareBinds = true;
        }
        if (this.currentRowBindAccessors != null) {
            Accessor[] tmp = this.currentBatchBindAccessors;
            this.currentBatchBindAccessors = this.currentRowBindAccessors;
            if (tmp == null) {
                tmp = new Accessor[this.numberOfBindPositions];
            } else {
                for (i = 0; i < this.numberOfBindPositions; ++i) {
                    tmp[i] = null;
                }
            }
            this.currentRowBindAccessors = tmp;
        }
        if ((nextRank = this.currentRank + 1) < number_of_rows_in_batch) {
            if (nextRank >= this.numberOfBindRowsAllocated) {
                int new_number_of_bind_rows_allocated = this.numberOfBindRowsAllocated << 1;
                if (new_number_of_bind_rows_allocated <= nextRank) {
                    new_number_of_bind_rows_allocated = nextRank + 1;
                }
                this.growBinds(new_number_of_bind_rows_allocated);
                this.currentBatchNeedToPrepareBinds = true;
            }
            this.currentRowBinders = this.binders[nextRank];
        } else {
            this.setupBindBuffers(0, number_of_rows_in_batch);
            this.currentRowBinders = this.binders[0];
        }
        this.currentRowNeedToPrepareBinds = false;
        this.clearParameters = false;
    }

    void processPlsqlIndexTabBinds(int cur_row_to_be_bound) throws SQLException {
        int num_plsql_index_tab_binds = 0;
        int total_elements = 0;
        int bytes = 0;
        int chars = 0;
        Binder[] curRowBinders = this.binders[cur_row_to_be_bound];
        PlsqlIbtBindInfo[] inBindInfos = this.parameterPlsqlIbt == null ? null : this.parameterPlsqlIbt[cur_row_to_be_bound];
        for (int i = 0; i < this.numberOfBindPositions; ++i) {
            PlsqlIndexTableAccessor ibtAccessor;
            Binder binder = curRowBinders[i];
            Accessor accessor = this.currentBatchBindAccessors == null ? null : this.currentBatchBindAccessors[i];
            PlsqlIndexTableAccessor plsqlIndexTableAccessor = ibtAccessor = accessor == null || accessor.defineType != 998 ? null : (PlsqlIndexTableAccessor)accessor;
            if (binder.type == 998) {
                PlsqlIbtBindInfo inBindInfo = inBindInfos[i];
                if (ibtAccessor != null) {
                    if (inBindInfo.element_internal_type != ibtAccessor.elementInternalType) {
                        DatabaseError.throwSqlException(12);
                    }
                    if (inBindInfo.maxLen < ibtAccessor.maxNumberOfElements) {
                        inBindInfo.maxLen = ibtAccessor.maxNumberOfElements;
                    }
                    if (inBindInfo.elemMaxLen < ibtAccessor.elementMaxLen) {
                        inBindInfo.elemMaxLen = ibtAccessor.elementMaxLen;
                    }
                    if (inBindInfo.ibtByteLength > 0) {
                        inBindInfo.ibtByteLength = inBindInfo.elemMaxLen * inBindInfo.maxLen;
                    } else {
                        inBindInfo.ibtCharLength = inBindInfo.elemMaxLen * inBindInfo.maxLen;
                    }
                }
                ++num_plsql_index_tab_binds;
                bytes += inBindInfo.ibtByteLength;
                chars += inBindInfo.ibtCharLength;
                total_elements += inBindInfo.maxLen;
                continue;
            }
            if (ibtAccessor == null) continue;
            ++num_plsql_index_tab_binds;
            bytes += ibtAccessor.ibtByteLength;
            chars += ibtAccessor.ibtCharLength;
            total_elements += ibtAccessor.maxNumberOfElements;
        }
        if (num_plsql_index_tab_binds == 0) {
            return;
        }
        this.ibtBindIndicatorSize = 6 + num_plsql_index_tab_binds * 8 + total_elements * 2;
        this.ibtBindIndicators = new short[this.ibtBindIndicatorSize];
        this.ibtBindIndicatorOffset = 0;
        if (bytes > 0) {
            this.ibtBindBytes = new byte[bytes];
        }
        this.ibtBindByteOffset = 0;
        if (chars > 0) {
            this.ibtBindChars = new char[chars];
        }
        this.ibtBindCharOffset = 0;
        int byteOffset = this.ibtBindByteOffset;
        int charOffset = this.ibtBindCharOffset;
        int indOffset = this.ibtBindIndicatorOffset;
        int offset = indOffset + 6 + num_plsql_index_tab_binds * 8;
        this.ibtBindIndicators[indOffset++] = (short)(num_plsql_index_tab_binds >> 16);
        this.ibtBindIndicators[indOffset++] = (short)(num_plsql_index_tab_binds & 0xFFFF);
        this.ibtBindIndicators[indOffset++] = (short)(bytes >> 16);
        this.ibtBindIndicators[indOffset++] = (short)(bytes & 0xFFFF);
        this.ibtBindIndicators[indOffset++] = (short)(chars >> 16);
        this.ibtBindIndicators[indOffset++] = (short)(chars & 0xFFFF);
        for (int i = 0; i < this.numberOfBindPositions; ++i) {
            int byteOrCharOffset;
            PlsqlIndexTableAccessor ibtAccessor;
            Binder binder = curRowBinders[i];
            Accessor accessor = this.currentBatchBindAccessors == null ? null : this.currentBatchBindAccessors[i];
            PlsqlIndexTableAccessor plsqlIndexTableAccessor = ibtAccessor = accessor == null || accessor.defineType != 998 ? null : (PlsqlIndexTableAccessor)accessor;
            if (binder.type == 998) {
                PlsqlIbtBindInfo inBindInfo = inBindInfos[i];
                int maxlen = inBindInfo.maxLen;
                this.ibtBindIndicators[indOffset++] = (short)inBindInfo.element_internal_type;
                this.ibtBindIndicators[indOffset++] = (short)inBindInfo.elemMaxLen;
                this.ibtBindIndicators[indOffset++] = (short)(maxlen >> 16);
                this.ibtBindIndicators[indOffset++] = (short)(maxlen & 0xFFFF);
                this.ibtBindIndicators[indOffset++] = (short)(inBindInfo.curLen >> 16);
                this.ibtBindIndicators[indOffset++] = (short)(inBindInfo.curLen & 0xFFFF);
                if (inBindInfo.ibtByteLength > 0) {
                    byteOrCharOffset = byteOffset;
                    byteOffset += inBindInfo.ibtByteLength;
                } else {
                    byteOrCharOffset = charOffset;
                    charOffset += inBindInfo.ibtCharLength;
                }
                this.ibtBindIndicators[indOffset++] = (short)(byteOrCharOffset >> 16);
                this.ibtBindIndicators[indOffset++] = (short)(byteOrCharOffset & 0xFFFF);
                inBindInfo.ibtValueIndex = byteOrCharOffset;
                inBindInfo.ibtIndicatorIndex = offset;
                inBindInfo.ibtLengthIndex = offset + maxlen;
                if (ibtAccessor != null) {
                    ibtAccessor.ibtIndicatorIndex = inBindInfo.ibtIndicatorIndex;
                    ibtAccessor.ibtLengthIndex = inBindInfo.ibtLengthIndex;
                    ibtAccessor.ibtMetaIndex = indOffset - 8;
                    ibtAccessor.ibtValueIndex = byteOrCharOffset;
                }
                offset += 2 * maxlen;
                continue;
            }
            if (ibtAccessor == null) continue;
            int maxlen = ibtAccessor.maxNumberOfElements;
            this.ibtBindIndicators[indOffset++] = (short)ibtAccessor.elementInternalType;
            this.ibtBindIndicators[indOffset++] = (short)ibtAccessor.elementMaxLen;
            this.ibtBindIndicators[indOffset++] = (short)(maxlen >> 16);
            this.ibtBindIndicators[indOffset++] = (short)(maxlen & 0xFFFF);
            this.ibtBindIndicators[indOffset++] = 0;
            this.ibtBindIndicators[indOffset++] = 0;
            if (ibtAccessor.ibtByteLength > 0) {
                byteOrCharOffset = byteOffset;
                byteOffset += ibtAccessor.ibtByteLength;
            } else {
                byteOrCharOffset = charOffset;
                charOffset += ibtAccessor.ibtCharLength;
            }
            this.ibtBindIndicators[indOffset++] = (short)(byteOrCharOffset >> 16);
            this.ibtBindIndicators[indOffset++] = (short)(byteOrCharOffset & 0xFFFF);
            ibtAccessor.ibtValueIndex = byteOrCharOffset;
            ibtAccessor.ibtIndicatorIndex = offset;
            ibtAccessor.ibtLengthIndex = offset + maxlen;
            ibtAccessor.ibtMetaIndex = indOffset - 8;
            offset += 2 * maxlen;
        }
    }

    void initializeBindSubRanges(int number_of_rows_to_be_bound, int number_of_rows_to_be_set_up) {
        this.bindByteSubRange = 0;
        this.bindCharSubRange = 0;
    }

    void initializeIndicatorSubRange() {
        this.bindIndicatorSubRange = 0;
    }

    void prepareBindPreambles(int number_of_rows_to_be_bound, int number_of_rows_to_be_set_up) {
    }

    void setupBindBuffers(int first_row_to_be_bound, int number_of_rows_to_be_bound) throws SQLException {
        try {
            int per_position_metadata_offset;
            int i;
            if (this.numberOfBindPositions == 0) {
                return;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.driverLogger.log(Level.FINE, "setupBindBuffers(" + first_row_to_be_bound + ", " + number_of_rows_to_be_bound + ")" + " currentBatchNeedToPrepareBinds=" + this.currentBatchNeedToPrepareBinds, this);
                OracleLog.recursiveTrace = false;
            }
            this.preparedAllBinds = this.currentBatchNeedToPrepareBinds;
            this.preparedCharBinds = false;
            this.currentBatchNeedToPrepareBinds = false;
            this.numberOfBoundRows = number_of_rows_to_be_bound;
            this.bindIndicators[this.bindIndicatorSubRange + 2] = (short)this.numberOfBoundRows;
            int number_of_rows_to_be_set_up = this.bindBufferCapacity;
            if (this.numberOfBoundRows > this.bindBufferCapacity) {
                number_of_rows_to_be_set_up = this.numberOfBoundRows;
                this.preparedAllBinds = true;
            }
            if (this.currentBatchBindAccessors != null) {
                if (this.outBindAccessors == null) {
                    this.outBindAccessors = new Accessor[this.numberOfBindPositions];
                }
                for (i = 0; i < this.numberOfBindPositions; ++i) {
                    int charlen;
                    Accessor accessor;
                    this.outBindAccessors[i] = accessor = this.currentBatchBindAccessors[i];
                    if (accessor == null || this.currentBatchCharLens[i] >= (charlen = accessor.charLength)) continue;
                    this.currentBatchCharLens[i] = charlen;
                }
            }
            int row_charlen = 0;
            int row_bytelen = 0;
            int metadata_offset = per_position_metadata_offset = this.bindIndicatorSubRange + 3;
            if (this.preparedAllBinds) {
                this.preparedCharBinds = true;
                Binder[] firstRankBinders = this.binders[first_row_to_be_bound];
                for (i = 0; i < this.numberOfBindPositions; ++i) {
                    short type;
                    int bytelen;
                    Binder binder = firstRankBinders[i];
                    int charlen = this.currentBatchCharLens[i];
                    if (binder == this.theOutBinder) {
                        Accessor accessor = this.currentBatchBindAccessors[i];
                        bytelen = accessor.byteLength;
                        type = (short)accessor.defineType;
                    } else {
                        bytelen = binder.bytelen;
                        type = binder.type;
                    }
                    row_bytelen += bytelen;
                    row_charlen += charlen;
                    this.bindIndicators[metadata_offset + 0] = type;
                    this.bindIndicators[metadata_offset + 1] = (short)bytelen;
                    this.bindIndicators[metadata_offset + 2] = (short)charlen;
                    this.bindIndicators[metadata_offset + 9] = this.currentBatchFormOfUse[i];
                    metadata_offset += 10;
                }
            } else if (this.preparedCharBinds) {
                for (i = 0; i < this.numberOfBindPositions; ++i) {
                    int charlen = this.currentBatchCharLens[i];
                    row_charlen += charlen;
                    this.bindIndicators[metadata_offset + 2] = (short)charlen;
                    metadata_offset += 10;
                }
            } else {
                for (i = 0; i < this.numberOfBindPositions; ++i) {
                    int pitchOffset = metadata_offset + 2;
                    int oldcharlen = this.bindIndicators[pitchOffset];
                    int charlen = this.currentBatchCharLens[i];
                    if (oldcharlen >= charlen && !this.preparedCharBinds) {
                        this.currentBatchCharLens[i] = oldcharlen;
                        row_charlen += oldcharlen;
                    } else {
                        this.bindIndicators[pitchOffset] = (short)charlen;
                        row_charlen += charlen;
                        this.preparedCharBinds = true;
                    }
                    metadata_offset += 10;
                }
            }
            if (this.preparedCharBinds) {
                this.initializeBindSubRanges(this.numberOfBoundRows, number_of_rows_to_be_set_up);
            }
            if (this.preparedAllBinds) {
                int total_bytelen = this.bindByteSubRange + row_bytelen * number_of_rows_to_be_set_up;
                if (this.lastBoundNeeded || total_bytelen > this.totalBindByteLength) {
                    this.bindByteOffset = 0;
                    this.bindBytes = new byte[total_bytelen];
                    this.totalBindByteLength = total_bytelen;
                }
                this.bindBufferCapacity = number_of_rows_to_be_set_up;
                this.bindIndicators[this.bindIndicatorSubRange + 1] = (short)this.bindBufferCapacity;
            }
            if (this.preparedCharBinds) {
                int total_charlen = this.bindCharSubRange + row_charlen * this.bindBufferCapacity;
                if (this.lastBoundNeeded || total_charlen > this.totalBindCharLength) {
                    this.bindCharOffset = 0;
                    this.bindChars = new char[total_charlen];
                    this.totalBindCharLength = total_charlen;
                }
                this.bindByteSubRange += this.bindByteOffset;
                this.bindCharSubRange += this.bindCharOffset;
            }
            int byteoffset = this.bindByteSubRange;
            int charoffset = this.bindCharSubRange;
            int indoffset = this.indicatorsOffset;
            int lenoffset = this.valueLengthsOffset;
            metadata_offset = per_position_metadata_offset;
            if (this.preparedCharBinds) {
                int valueoffset;
                int bytelen;
                if (this.currentBatchBindAccessors == null) {
                    for (i = 0; i < this.numberOfBindPositions; ++i) {
                        bytelen = this.bindIndicators[metadata_offset + 1];
                        int charlen = this.currentBatchCharLens[i];
                        valueoffset = charlen == 0 ? byteoffset : charoffset;
                        this.bindIndicators[metadata_offset + 3] = (short)(valueoffset >> 16);
                        this.bindIndicators[metadata_offset + 4] = (short)(valueoffset & 0xFFFF);
                        byteoffset += bytelen * this.bindBufferCapacity;
                        charoffset += charlen * this.bindBufferCapacity;
                        metadata_offset += 10;
                    }
                } else {
                    for (i = 0; i < this.numberOfBindPositions; ++i) {
                        bytelen = this.bindIndicators[metadata_offset + 1];
                        int charlen = this.currentBatchCharLens[i];
                        valueoffset = charlen == 0 ? byteoffset : charoffset;
                        this.bindIndicators[metadata_offset + 3] = (short)(valueoffset >> 16);
                        this.bindIndicators[metadata_offset + 4] = (short)(valueoffset & 0xFFFF);
                        Accessor accessor = this.currentBatchBindAccessors[i];
                        if (accessor != null) {
                            if (charlen > 0) {
                                accessor.columnIndex = charoffset;
                                accessor.charLength = charlen;
                            } else {
                                accessor.columnIndex = byteoffset;
                                accessor.byteLength = bytelen;
                            }
                            accessor.lengthIndex = lenoffset;
                            accessor.indicatorIndex = indoffset;
                            accessor.rowSpaceByte = this.bindBytes;
                            accessor.rowSpaceChar = this.bindChars;
                            accessor.rowSpaceIndicator = this.bindIndicators;
                            if (accessor.defineType == 109 || accessor.defineType == 111) {
                                accessor.setOffsets(this.bindBufferCapacity);
                            }
                        }
                        byteoffset += bytelen * this.bindBufferCapacity;
                        charoffset += charlen * this.bindBufferCapacity;
                        indoffset += this.numberOfBindRowsAllocated;
                        lenoffset += this.numberOfBindRowsAllocated;
                        metadata_offset += 10;
                    }
                }
                byteoffset = this.bindByteSubRange;
                charoffset = this.bindCharSubRange;
                indoffset = this.indicatorsOffset;
                lenoffset = this.valueLengthsOffset;
                metadata_offset = per_position_metadata_offset;
            }
            int unused_rows = this.bindBufferCapacity - this.numberOfBoundRows;
            int lastrow_in_buffers = this.numberOfBoundRows - 1;
            int lastrow_in_binders = lastrow_in_buffers + first_row_to_be_bound;
            Binder[] lastRowBinders = this.binders[lastrow_in_binders];
            if (this.parameterOtype != null) {
                System.arraycopy(this.parameterDatum[lastrow_in_binders], 0, this.lastBoundTypeBytes, 0, this.numberOfBindPositions);
                System.arraycopy(this.parameterOtype[lastrow_in_binders], 0, this.lastBoundTypeOtypes, 0, this.numberOfBindPositions);
            }
            if (this.hasIbtBind) {
                this.processPlsqlIndexTabBinds(first_row_to_be_bound);
            }
            if (this.returnParamAccessors != null) {
                this.processDmlReturningBind();
            }
            boolean clearPriorBindValues = this.sqlKind != 1 && this.sqlKind != 4 || this.currentRowBindAccessors == null;
            for (i = 0; i < this.numberOfBindPositions; ++i) {
                int bytelen = this.bindIndicators[metadata_offset + 1];
                int charlen = this.currentBatchCharLens[i];
                this.lastBinders[i] = lastRowBinders[i];
                this.lastBoundByteLens[i] = bytelen;
                for (int rowInBuffers = 0; rowInBuffers < this.numberOfBoundRows; ++rowInBuffers) {
                    int rowInBinders = first_row_to_be_bound + rowInBuffers;
                    this.binders[rowInBinders][i].bind(this, i, rowInBuffers, rowInBinders, this.bindBytes, this.bindChars, this.bindIndicators, bytelen, charlen, byteoffset, charoffset, lenoffset + rowInBuffers, indoffset + rowInBuffers, clearPriorBindValues);
                    this.binders[rowInBinders][i] = null;
                    byteoffset += bytelen;
                    charoffset += charlen;
                }
                this.lastBoundByteOffsets[i] = byteoffset - bytelen;
                this.lastBoundCharOffsets[i] = charoffset - charlen;
                this.lastBoundInds[i] = this.bindIndicators[indoffset + lastrow_in_buffers];
                this.lastBoundLens[i] = this.bindIndicators[lenoffset + lastrow_in_buffers];
                this.lastBoundCharLens[i] = 0;
                byteoffset += unused_rows * bytelen;
                charoffset += unused_rows * charlen;
                indoffset += this.numberOfBindRowsAllocated;
                lenoffset += this.numberOfBindRowsAllocated;
                metadata_offset += 10;
            }
            this.lastBoundBytes = this.bindBytes;
            this.lastBoundByteOffset = this.bindByteOffset;
            this.lastBoundChars = this.bindChars;
            this.lastBoundCharOffset = this.bindCharOffset;
            int[] tmp = this.currentBatchCharLens;
            this.currentBatchCharLens = this.lastBoundCharLens;
            this.lastBoundCharLens = tmp;
            this.lastBoundNeeded = false;
            this.prepareBindPreambles(this.numberOfBoundRows, this.bindBufferCapacity);
        }
        catch (NullPointerException e) {
            DatabaseError.throwSqlException(89);
        }
    }

    public void enterImplicitCache() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "enterImplicitCache() entry", this);
            OracleLog.recursiveTrace = false;
        }
        this.alwaysOnClose();
        if (!this.connection.isClosed()) {
            this.cleanAllTempLobs();
        }
        if (this.connection.clearStatementMetaData) {
            this.lastBoundBytes = null;
            this.lastBoundChars = null;
        }
        this.clearParameters();
        this.cacheState = 2;
        this.creationState = 1;
        this.currentResultSet = null;
        this.lastIndex = 0;
        this.queryTimeout = 0;
        this.autoRollback = 2;
        this.rowPrefetchChanged = false;
        this.currentRank = 0;
        this.currentRow = -1;
        this.validRows = 0;
        this.maxRows = 0;
        this.totalRowsVisited = 0;
        this.maxFieldSize = 0;
        this.gotLastBatch = false;
        this.clearParameters = true;
        this.scrollRset = null;
        this.needToAddIdentifier = false;
        this.defaultFetchDirection = 1000;
        this.defaultTZ = null;
        if (this.sqlKind == 3) {
            this.needToParse = true;
            this.needToPrepareDefineBuffer = true;
            this.columnsDefinedByUser = false;
        }
        if (this.connection.isMemoryFreedOnEnteringCache && this.defineIndicators != null) {
            this.cachedDefineByteSize = this.defineBytes != null ? this.defineBytes.length : 0;
            this.cachedDefineCharSize = this.defineChars != null ? this.defineChars.length : 0;
            this.cachedDefineIndicatorSize = this.defineIndicators != null ? this.defineIndicators.length : 0;
            this.defineChars = null;
            this.defineBytes = null;
            this.defineIndicators = null;
        }
        if (this.accessors != null) {
            int len = this.accessors.length;
            for (int i = 0; i < len; ++i) {
                if (this.accessors[i] == null) continue;
                if (this.connection.isMemoryFreedOnEnteringCache) {
                    this.accessors[i].rowSpaceByte = null;
                    this.accessors[i].rowSpaceChar = null;
                    this.accessors[i].rowSpaceIndicator = null;
                }
                if (!this.columnsDefinedByUser) continue;
                this.accessors[i].externalType = 0;
            }
        }
        this.fixedString = this.connection.getDefaultFixedString();
        this.defaultRowPrefetch = this.rowPrefetch;
        if (this.connection.clearStatementMetaData) {
            this.sqlStringChanged = true;
            this.needToParse = true;
            this.needToPrepareDefineBuffer = true;
            this.columnsDefinedByUser = false;
            if (this.userRsetType == 0) {
                this.userRsetType = 1;
                this.realRsetType = 1;
            }
            this.currentRowNeedToPrepareBinds = true;
        }
    }

    public void enterExplicitCache() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "enterExplicitCache() entry", this);
            OracleLog.recursiveTrace = false;
        }
        this.cacheState = 2;
        this.creationState = 2;
        this.defaultTZ = null;
        this.alwaysOnClose();
    }

    public void exitImplicitCacheToActive() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "exitImplicitCacheToActive() entry", this);
            OracleLog.recursiveTrace = false;
        }
        this.cacheState = 1;
        this.closed = false;
        if (this.rowPrefetch != this.connection.getDefaultRowPrefetch() && this.streamList == null) {
            this.defaultRowPrefetch = this.rowPrefetch = this.connection.getDefaultRowPrefetch();
            this.rowPrefetchChanged = true;
        }
        if (this.batch != this.connection.getDefaultExecuteBatch()) {
            this.resetBatch();
        }
        if (this.autoRefetch != this.connection.getDefaultAutoRefetch()) {
            this.autoRefetch = this.connection.getDefaultAutoRefetch();
        }
        this.processEscapes = this.connection.processEscapes;
        if (this.connection.isMemoryFreedOnEnteringCache && this.cachedDefineIndicatorSize != 0) {
            this.defineBytes = new byte[this.cachedDefineByteSize];
            this.defineChars = new char[this.cachedDefineCharSize];
            this.defineIndicators = new short[this.cachedDefineIndicatorSize];
            if (this.accessors != null) {
                int len = this.accessors.length;
                for (int i = 0; i < len; ++i) {
                    if (this.accessors[i] == null || !this.connection.isMemoryFreedOnEnteringCache) continue;
                    this.accessors[i].rowSpaceByte = this.defineBytes;
                    this.accessors[i].rowSpaceChar = this.defineChars;
                    this.accessors[i].rowSpaceIndicator = this.defineIndicators;
                }
            }
        }
    }

    public void exitExplicitCacheToActive() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.exitImplicitCacheToActive()", this);
            OracleLog.recursiveTrace = false;
        }
        this.cacheState = 1;
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitImplicitCacheToClose() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.exitImplicitCacheToClose()", this);
            OracleLog.recursiveTrace = false;
        }
        this.cacheState = 0;
        this.closed = false;
        OraclePreparedStatement oraclePreparedStatement = this;
        synchronized (oraclePreparedStatement) {
            this.hardClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitExplicitCacheToClose() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.exitExplicitCacheToClose()", this);
            OracleLog.recursiveTrace = false;
        }
        this.cacheState = 0;
        this.closed = false;
        OraclePreparedStatement oraclePreparedStatement = this;
        synchronized (oraclePreparedStatement) {
            this.hardClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWithKey(String key) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.closeOrCache(key);
            }
        }
    }

    int executeInternal() throws SQLException {
        boolean incrementRowCount;
        this.noMoreUpdateCounts = false;
        this.ensureOpen();
        if (this.currentRank > 0 && this.m_batchStyle == 2) {
            DatabaseError.throwSqlException(81, "batch must be either executed or cleared");
        }
        boolean regularResultSet = this.userRsetType == 1;
        this.prepareForNewResults(true, false);
        this.processCompletedBindRow(this.sqlKind == 0 ? 1 : this.batch, false);
        if (!regularResultSet && !this.scrollRsetTypeSolved) {
            return this.doScrollPstmtExecuteUpdate() + this.prematureBatchCount;
        }
        this.doExecuteWithTimeout();
        boolean bl = incrementRowCount = this.prematureBatchCount != 0 && this.validRows > 0;
        if (!regularResultSet) {
            this.currentResultSet = new OracleResultSetImpl(this.connection, this);
            this.scrollRset = ResultSetUtil.createScrollResultSet(this, this.currentResultSet, this.realRsetType);
            if (!this.connection.accumulateBatchResult) {
                incrementRowCount = false;
            }
        }
        if (incrementRowCount) {
            this.validRows += this.prematureBatchCount;
            this.prematureBatchCount = 0;
        }
        return this.validRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.executionType = 1;
                this.executeInternal();
                if (this.userRsetType == 1) {
                    this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                    return this.currentResultSet;
                }
                if (this.scrollRset == null) {
                    this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                    this.scrollRset = this.currentResultSet;
                }
                return this.scrollRset;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.executionType = (byte)2;
                return this.executeInternal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.executionType = (byte)3;
                this.executeInternal();
                return this.sqlKind == 0;
            }
        }
    }

    void slideDownCurrentRow(int fromRow) {
        Object tmp;
        if (this.binders != null) {
            this.binders[fromRow] = this.binders[0];
            this.binders[0] = this.currentRowBinders;
        }
        if (this.parameterInt != null) {
            tmp = this.parameterInt[0];
            this.parameterInt[0] = this.parameterInt[fromRow];
            this.parameterInt[fromRow] = tmp;
        }
        if (this.parameterLong != null) {
            tmp = this.parameterLong[0];
            this.parameterLong[0] = this.parameterLong[fromRow];
            this.parameterLong[fromRow] = tmp;
        }
        if (this.parameterFloat != null) {
            tmp = this.parameterFloat[0];
            this.parameterFloat[0] = this.parameterFloat[fromRow];
            this.parameterFloat[fromRow] = tmp;
        }
        if (this.parameterDouble != null) {
            tmp = this.parameterDouble[0];
            this.parameterDouble[0] = this.parameterDouble[fromRow];
            this.parameterDouble[fromRow] = tmp;
        }
        if (this.parameterBigDecimal != null) {
            tmp = this.parameterBigDecimal[0];
            this.parameterBigDecimal[0] = this.parameterBigDecimal[fromRow];
            this.parameterBigDecimal[fromRow] = (BigDecimal[])tmp;
        }
        if (this.parameterString != null) {
            tmp = this.parameterString[0];
            this.parameterString[0] = this.parameterString[fromRow];
            this.parameterString[fromRow] = (String[])tmp;
        }
        if (this.parameterDate != null) {
            tmp = this.parameterDate[0];
            this.parameterDate[0] = this.parameterDate[fromRow];
            this.parameterDate[fromRow] = (Date[])tmp;
        }
        if (this.parameterTime != null) {
            tmp = this.parameterTime[0];
            this.parameterTime[0] = this.parameterTime[fromRow];
            this.parameterTime[fromRow] = (Time[])tmp;
        }
        if (this.parameterTimestamp != null) {
            tmp = this.parameterTimestamp[0];
            this.parameterTimestamp[0] = this.parameterTimestamp[fromRow];
            this.parameterTimestamp[fromRow] = (Timestamp[])tmp;
        }
        if (this.parameterDatum != null) {
            tmp = this.parameterDatum[0];
            this.parameterDatum[0] = this.parameterDatum[fromRow];
            this.parameterDatum[fromRow] = (byte[][])tmp;
        }
        if (this.parameterOtype != null) {
            tmp = this.parameterOtype[0];
            this.parameterOtype[0] = this.parameterOtype[fromRow];
            this.parameterOtype[fromRow] = (OracleTypeADT[])tmp;
        }
        if (this.parameterStream != null) {
            tmp = this.parameterStream[0];
            this.parameterStream[0] = this.parameterStream[fromRow];
            this.parameterStream[fromRow] = (InputStream[])tmp;
        }
    }

    void resetBatch() {
        this.batch = this.connection.getDefaultExecuteBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int sendBatch() throws SQLException {
        if (this.isJdbcBatchStyle()) {
            return 0;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.sendBatch()", this);
                    OracleLog.recursiveTrace = false;
                }
                this.ensureOpen();
                if (this.currentRank <= 0) {
                    int n = this.connection.accumulateBatchResult ? 0 : this.validRows;
                    return n;
                }
                int actual_batch = this.batch;
                try {
                    int saved_current_rank = this.currentRank;
                    if (this.batch != this.currentRank) {
                        this.batch = this.currentRank;
                    }
                    this.setupBindBuffers(0, this.currentRank);
                    --this.currentRank;
                    this.doExecuteWithTimeout();
                    this.slideDownCurrentRow(saved_current_rank);
                }
                finally {
                    if (this.batch != actual_batch) {
                        this.batch = actual_batch;
                    }
                }
                if (this.connection.accumulateBatchResult) {
                    this.validRows += this.prematureBatchCount;
                    this.prematureBatchCount = 0;
                }
                int n = this.validRows;
                return n;
                finally {
                    this.currentRank = 0;
                }
            }
        }
    }

    public synchronized void setExecuteBatch(int batchValue) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setExecuteBatch(batchValue=" + batchValue + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setOracleBatchStyle();
        this.set_execute_batch(batchValue);
    }

    synchronized void set_execute_batch(int batchValue) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.setExecuteBatch(batchValue=" + batchValue + "): batch=" + this.batch, this);
            OracleLog.recursiveTrace = false;
        }
        if (batchValue <= 0) {
            DatabaseError.throwSqlException(42);
        }
        if (batchValue == this.batch) {
            return;
        }
        if (this.currentRank > 0) {
            this.sendBatch();
        }
        int oldBatch = this.batch;
        this.batch = batchValue;
        if (this.numberOfBindRowsAllocated < this.batch) {
            this.growBinds(this.batch);
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.setExecuteBatch:return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    public final int getExecuteBatch() {
        return this.batch;
    }

    public synchronized void defineParameterTypeBytes(int param_index, int type, int max_size) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.defineParameterType(param_index=" + param_index + ", type=" + type + ", max_size=" + max_size + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (max_size < 0) {
            DatabaseError.throwSqlException(53);
        }
        if (param_index < 1) {
            DatabaseError.throwSqlException(3);
        }
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                type = 6;
                break;
            }
            case 1: {
                type = 96;
                break;
            }
            case 12: {
                type = 1;
                break;
            }
            case 91: 
            case 92: {
                type = 12;
                break;
            }
            case -103: {
                type = 182;
                break;
            }
            case -104: {
                type = 183;
                break;
            }
            case -100: 
            case 93: {
                type = 180;
                break;
            }
            case -101: {
                type = 181;
                break;
            }
            case -102: {
                type = 231;
                break;
            }
            case -3: 
            case -2: {
                type = 23;
                break;
            }
            case 100: {
                type = 100;
                break;
            }
            case 101: {
                type = 101;
                break;
            }
            case -8: {
                type = 104;
                break;
            }
            case 2004: {
                type = 113;
                break;
            }
            case 2005: {
                type = 112;
                break;
            }
            case -13: {
                type = 114;
                break;
            }
            case -10: {
                type = 102;
                break;
            }
            case 0: {
                DatabaseError.throwSqlException(4);
            }
            default: {
                DatabaseError.throwSqlException(23);
            }
        }
    }

    public synchronized void defineParameterTypeChars(int param_index, int type, int max_size) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.defineParameterTypeChars(param_index=" + param_index + ", type=" + type + ", max_size=" + max_size + ")", this);
            OracleLog.recursiveTrace = false;
        }
        int nlsratio = this.connection.getNlsRatio();
        if (type == 1 || type == 12) {
            this.defineParameterTypeBytes(param_index, type, max_size * nlsratio);
        } else {
            this.defineParameterTypeBytes(param_index, type, max_size);
        }
    }

    public synchronized void defineParameterType(int param_index, int type, int max_size) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleStatement.defineParameterType(param_index=" + param_index + "type=" + type + "max_size=" + max_size + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.defineParameterTypeBytes(param_index, type, max_size);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet _rset = this.getResultSet();
        if (_rset != null) {
            return _rset.getMetaData();
        }
        return null;
    }

    public void setNull(int paramIndex, int sqlType, String sqlName) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.setNull(paramIndex=" + paramIndex + ", sqlType=" + sqlType + ", sqlName=" + sqlName + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setNullInternal(paramIndex, sqlType, sqlName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNullInternal(int paramIndex, int sqlType, String sqlName) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (sqlType == 2002 || sqlType == 2008 || sqlType == 2003 || sqlType == 2007 || sqlType == 2006) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OraclePreparedStatement oraclePreparedStatement = this;
                synchronized (oraclePreparedStatement) {
                    this.setNullCritial(index, sqlType, sqlName);
                    this.currentRowCharLens[index] = 0;
                }
            }
        }
        this.setNullInternal(paramIndex, sqlType);
        return;
    }

    synchronized void setNullInternal(int paramIndex, int sqlType) throws SQLException {
        this.setNullCritical(paramIndex, sqlType);
    }

    void setNullCritial(int index, int sqlType, String sqlName) throws SQLException {
        OracleTypeADT otype = null;
        Binder binder = this.theNamedTypeNullBinder;
        switch (sqlType) {
            case 2006: {
                binder = this.theRefTypeNullBinder;
            }
            case 2002: 
            case 2008: {
                StructDescriptor desc = StructDescriptor.createDescriptor(sqlName, (Connection)this.connection);
                otype = desc.getOracleTypeADT();
                break;
            }
            case 2003: {
                ArrayDescriptor desc = ArrayDescriptor.createDescriptor(sqlName, (Connection)this.connection);
                otype = desc.getOracleTypeCOLLECTION();
                break;
            }
            case 2007: {
                OpaqueDescriptor desc = OpaqueDescriptor.createDescriptor(sqlName, (Connection)this.connection);
                otype = (OracleTypeADT)desc.getPickler();
                break;
            }
        }
        this.currentRowBinders[index] = binder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        this.parameterDatum[this.currentRank][index] = null;
        otype.getTOID();
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][index] = otype;
    }

    public void setNullAtName(String paramName, int sqlType, String sqlName) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setNull(" + paramName + ", " + sqlType + ", " + sqlName, this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setNullInternal(i + 1, sqlType, sqlName);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setNull(int paramIndex, int sqlType) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.setNull(paramIndex=" + paramIndex + ", sqlType=" + sqlType + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setNullCritical(paramIndex, sqlType);
    }

    void setNullCritical(int paramIndex, int sqlType) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        Binder binder = null;
        int dbtype = this.getInternalType(sqlType);
        switch (dbtype) {
            case 6: {
                binder = this.theVarnumNullBinder;
                break;
            }
            case 1: 
            case 8: 
            case 96: 
            case 995: {
                binder = this.theVarcharNullBinder;
                this.currentRowCharLens[index] = 1;
                break;
            }
            case 999: {
                binder = this.theFixedCHARNullBinder;
                break;
            }
            case 12: {
                binder = this.theDateNullBinder;
                break;
            }
            case 180: {
                binder = this.connection.v8Compatible ? this.theDateNullBinder : this.theTimestampNullBinder;
                break;
            }
            case 181: {
                binder = this.theTSTZNullBinder;
                break;
            }
            case 231: {
                binder = this.theTSLTZNullBinder;
                break;
            }
            case 104: {
                binder = this.theRowidNullBinder;
                break;
            }
            case 183: {
                binder = this.theIntervalDSNullBinder;
                break;
            }
            case 182: {
                binder = this.theIntervalYMNullBinder;
                break;
            }
            case 23: 
            case 24: {
                binder = this.theRawNullBinder;
                break;
            }
            case 100: {
                binder = this.theBinaryFloatNullBinder;
                break;
            }
            case 101: {
                binder = this.theBinaryDoubleNullBinder;
                break;
            }
            case 113: {
                binder = this.theBlobNullBinder;
                break;
            }
            case 112: {
                binder = this.theClobNullBinder;
                break;
            }
            case 114: {
                binder = this.theBfileNullBinder;
                break;
            }
            case 109: 
            case 111: {
                DatabaseError.throwSqlException(4, "sqlType=" + sqlType);
            }
            default: {
                DatabaseError.throwSqlException(23, "sqlType=" + sqlType);
            }
        }
        this.currentRowBinders[index] = binder;
    }

    public void setNullAtName(String paramName, int sqlType) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setNull(" + paramName + ", " + sqlType + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setNull(i + 1, sqlType);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setBoolean(int paramIndex, boolean x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setBoolean(paramIndex=" + paramIndex + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setBooleanInternal(paramIndex, x);
    }

    void setBooleanInternal(int paramIndex, boolean x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[index] = 0;
        this.currentRowBinders[index] = this.theBooleanBinder;
        if (this.parameterInt == null) {
            this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterInt[this.currentRank][index] = x ? 1 : 0;
    }

    public void setBooleanAtName(String paramName, boolean x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setBooleanAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setBoolean(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setByte(int paramIndex, byte x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setShort(paramIndex=" + paramIndex + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setByteInternal(paramIndex, x);
    }

    void setByteInternal(int paramIndex, byte x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[index] = 0;
        this.currentRowBinders[index] = this.theByteBinder;
        if (this.parameterInt == null) {
            this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterInt[this.currentRank][index] = x;
    }

    public void setByteAtName(String paramName, byte x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setByteAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setByte(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setShort(int paramIndex, short x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setShort(paramIndex=" + paramIndex + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setShortInternal(paramIndex, x);
    }

    void setShortInternal(int paramIndex, short x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[index] = 0;
        this.currentRowBinders[index] = this.theShortBinder;
        if (this.parameterInt == null) {
            this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterInt[this.currentRank][index] = x;
    }

    public void setShortAtName(String paramName, short x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setShortAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setShort(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setInt(int paramIndex, int x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setInt(paramIndex=" + paramIndex + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setIntInternal(paramIndex, x);
    }

    void setIntInternal(int paramIndex, int x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[index] = 0;
        this.currentRowBinders[index] = this.theIntBinder;
        if (this.parameterInt == null) {
            this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterInt[this.currentRank][index] = x;
    }

    public void setIntAtName(String paramName, int x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setIntAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setInt(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setLong(int paramIndex, long x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setLong(paramIndex=" + paramIndex + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setLongInternal(paramIndex, x);
    }

    void setLongInternal(int paramIndex, long x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[index] = 0;
        this.currentRowBinders[index] = this.theLongBinder;
        if (this.parameterLong == null) {
            this.parameterLong = new long[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterLong[this.currentRank][index] = x;
    }

    public void setLongAtName(String paramName, long x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setLongAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setLong(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setFloat(int paramIndex, float x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setFloat(paramIndex=" + paramIndex + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setFloatInternal(paramIndex, x);
    }

    void setFloatInternal(int paramIndex, float x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.theFloatBinder == null) {
            String prop_str;
            this.theFloatBinder = theStaticFloatBinder;
            Properties props = this.connection.connectionProperties;
            if (props != null && (prop_str = props.getProperty("SetFloatAndDoubleUseBinary")) != null && prop_str.equalsIgnoreCase("true")) {
                this.theFloatBinder = theStaticBinaryFloatBinder;
            }
        }
        this.currentRowCharLens[index] = 0;
        this.currentRowBinders[index] = this.theFloatBinder;
        if (this.theFloatBinder == theStaticFloatBinder) {
            if (this.parameterDouble == null) {
                this.parameterDouble = new double[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterDouble[this.currentRank][index] = x;
        } else {
            if (this.parameterFloat == null) {
                this.parameterFloat = new float[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterFloat[this.currentRank][index] = x;
        }
    }

    public synchronized void setBinaryFloat(int paramIndex, float x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setBinaryFloat(paramIndex=" + paramIndex + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setBinaryFloatInternal(paramIndex, x);
    }

    void setBinaryFloatInternal(int paramIndex, float x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[index] = 0;
        this.currentRowBinders[index] = this.theBinaryFloatBinder;
        if (this.parameterFloat == null) {
            this.parameterFloat = new float[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterFloat[this.currentRank][index] = x;
    }

    public void setBinaryFloatAtName(String paramName, float x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setBinaryFloatAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setBinaryFloat(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setBinaryFloat(int paramIndex, BINARY_FLOAT bf) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setBinaryFloat(paramIndex=" + paramIndex + ", bf=" + bf + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setBinaryFloatInternal(paramIndex, bf);
    }

    void setBinaryFloatInternal(int paramIndex, BINARY_FLOAT bf) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (bf == null) {
            this.currentRowBinders[index] = this.theBINARY_FLOATNullBinder;
        } else {
            this.currentRowBinders[index] = this.theBINARY_FLOATBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][index] = bf.getBytes();
        }
        this.currentRowCharLens[index] = 0;
    }

    public void setBinaryFloatAtName(String paramName, BINARY_FLOAT x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setBinaryFloatAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setBinaryFloat(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setBinaryDouble(int paramIndex, double x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setBinaryDouble(paramIndex=" + paramIndex + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setBinaryDoubleInternal(paramIndex, x);
    }

    void setBinaryDoubleInternal(int paramIndex, double x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowBinders[index] = this.theBinaryDoubleBinder;
        if (this.parameterDouble == null) {
            this.parameterDouble = new double[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.currentRowCharLens[index] = 0;
        this.parameterDouble[this.currentRank][index] = x;
    }

    public synchronized void setBinaryDouble(int paramIndex, BINARY_DOUBLE bd) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setBinaryDouble(paramIndex=" + paramIndex + ", bd=" + bd + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setBinaryDoubleInternal(paramIndex, bd);
    }

    void setBinaryDoubleInternal(int paramIndex, BINARY_DOUBLE bd) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (bd == null) {
            this.currentRowBinders[index] = this.theBINARY_DOUBLENullBinder;
        } else {
            this.currentRowBinders[index] = this.theBINARY_DOUBLEBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][index] = bd.getBytes();
        }
        this.currentRowCharLens[index] = 0;
    }

    public void setBinaryDoubleAtName(String paramName, double x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setBinaryDoubleAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setBinaryDouble(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public void setFloatAtName(String paramName, float x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setFloatAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setFloat(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public void setBinaryDoubleAtName(String paramName, BINARY_DOUBLE x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setBinaryDoubleAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setBinaryDouble(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setDouble(int paramIndex, double x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setDouble(paramIndex=" + paramIndex + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setDoubleInternal(paramIndex, x);
    }

    void setDoubleInternal(int paramIndex, double x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.theDoubleBinder == null) {
            String prop_str;
            this.theDoubleBinder = theStaticDoubleBinder;
            Properties props = this.connection.connectionProperties;
            if (props != null && (prop_str = props.getProperty("SetFloatAndDoubleUseBinary")) != null && prop_str.equalsIgnoreCase("true")) {
                this.theDoubleBinder = theStaticBinaryDoubleBinder;
            }
        }
        this.currentRowCharLens[index] = 0;
        this.currentRowBinders[index] = this.theDoubleBinder;
        if (this.parameterDouble == null) {
            this.parameterDouble = new double[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterDouble[this.currentRank][index] = x;
    }

    public void setDoubleAtName(String paramName, double x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setDoubleAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setDouble(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setBigDecimal(int paramIndex, BigDecimal x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setBigDecimal(paramIndex=" + paramIndex + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setBigDecimalInternal(paramIndex, x);
    }

    void setBigDecimalInternal(int paramIndex, BigDecimal x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (x == null) {
            this.currentRowBinders[index] = this.theVarnumNullBinder;
        } else {
            this.currentRowBinders[index] = this.theBigDecimalBinder;
            if (this.parameterBigDecimal == null) {
                this.parameterBigDecimal = new BigDecimal[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterBigDecimal[this.currentRank][index] = x;
        }
        this.currentRowCharLens[index] = 0;
    }

    public void setBigDecimalAtName(String paramName, BigDecimal x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setBigDecimalAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setBigDecimal(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setString(int paramIndex, String x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setString(paramIndex=" + paramIndex + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setStringInternal(paramIndex, x);
    }

    void setStringInternal(int paramIndex, String x) throws SQLException {
        int stringLength;
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        int n = stringLength = x != null ? x.length() : 0;
        if (stringLength == 0) {
            this.basicBindNullString(paramIndex);
        } else if (this.currentRowFormOfUse[paramIndex - 1] == 1) {
            if (this.sqlKind == 1 || this.sqlKind == 4) {
                if (stringLength > this.maxVcsBytesPlsql || stringLength > this.maxVcsCharsPlsql && this.isServerCharSetFixedWidth) {
                    this.setStringForClobCritical(paramIndex, x);
                } else if (stringLength > this.maxVcsCharsPlsql) {
                    int bytes_length = this.connection.conversion.encodedByteLength(x, false);
                    if (bytes_length > this.maxVcsBytesPlsql) {
                        this.setStringForClobCritical(paramIndex, x);
                    } else {
                        this.basicBindString(paramIndex, x);
                    }
                } else {
                    this.basicBindString(paramIndex, x);
                }
            } else if (stringLength <= this.maxVcsCharsSql) {
                this.basicBindString(paramIndex, x);
            } else if (stringLength <= this.maxStreamCharsSql) {
                this.basicBindCharacterStream(paramIndex, new StringReader(x), stringLength);
            } else {
                this.setStringForClobCritical(paramIndex, x);
            }
        } else if (this.sqlKind == 1 || this.sqlKind == 4) {
            if (stringLength > this.maxVcsBytesPlsql || stringLength > this.maxVcsNCharsPlsql && this.isServerNCharSetFixedWidth) {
                this.setStringForClobCritical(paramIndex, x);
            } else if (stringLength > this.maxVcsNCharsPlsql) {
                int bytes_length = this.connection.conversion.encodedByteLength(x, true);
                if (bytes_length > this.maxVcsBytesPlsql) {
                    this.setStringForClobCritical(paramIndex, x);
                } else {
                    this.basicBindString(paramIndex, x);
                }
            } else {
                this.basicBindString(paramIndex, x);
            }
        } else if (stringLength <= this.maxVcsCharsSql) {
            this.basicBindString(paramIndex, x);
        } else if (stringLength <= this.maxStreamNCharsSql) {
            this.setStringForClobCritical(paramIndex, x);
        } else {
            this.setStringForClobCritical(paramIndex, x);
        }
    }

    void basicBindNullString(int paramIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINER, "OraclePreparedStatement.basicBindNullString=", this);
            OracleLog.recursiveTrace = false;
        }
        int index = paramIndex - 1;
        this.currentRowBinders[index] = this.theVarcharNullBinder;
        this.currentRowCharLens[index] = this.sqlKind == 1 || this.sqlKind == 4 ? this.minVcsBindSize : 1;
    }

    void basicBindString(int paramIndex, String x) throws SQLException {
        int min_size;
        int cur_len;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINER, "OraclePreparedStatement.basicBindString=", this);
            OracleLog.recursiveTrace = false;
        }
        int index = paramIndex - 1;
        this.currentRowBinders[index] = this.theStringBinder;
        int stringLength = x.length();
        this.currentRowCharLens[index] = this.sqlKind == 1 || this.sqlKind == 4 ? ((cur_len = stringLength + 1) < (min_size = this.connection.minVcsBindSize) ? min_size : cur_len) : stringLength + 1;
        if (this.parameterString == null) {
            this.parameterString = new String[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterString[this.currentRank][index] = x;
    }

    public void setStringAtName(String paramName, String x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setStringAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setString(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public void setStringForClob(int paramIndex, String x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setStringForClob(paramIndex=" + paramIndex + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (x == null) {
            this.setNull(paramIndex, 1);
            return;
        }
        int stringLength = x.length();
        if (stringLength == 0) {
            this.setNull(paramIndex, 1);
            return;
        }
        if (this.sqlKind == 1 || this.sqlKind == 4) {
            if (stringLength <= this.maxVcsCharsPlsql) {
                this.setStringInternal(paramIndex, x);
            } else {
                this.setStringForClobCritical(paramIndex, x);
            }
        } else if (stringLength <= this.maxVcsCharsSql) {
            this.setStringInternal(paramIndex, x);
        } else {
            this.setStringForClobCritical(paramIndex, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStringForClobCritical(int paramIndex, String x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                CLOB tclob = CLOB.createTemporary(this.connection, true, 10, this.currentRowFormOfUse[paramIndex - 1]);
                tclob.setString(1L, x);
                this.addToTempLobsToFree(tclob);
                this.setCLOBInternal(paramIndex, tclob);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReaderContentsForClobCritical(int paramIndex, Reader reader, int length) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.setReaderContentsForClobCritical(paramIndex=" + paramIndex + ", reader, length=" + length + ")", this);
            OracleLog.recursiveTrace = false;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                CLOB tclob = CLOB.createTemporary(this.connection, true, 10, this.currentRowFormOfUse[paramIndex - 1]);
                OracleClobWriter writer = (OracleClobWriter)tclob.setCharacterStream(1L);
                int bufferSize = tclob.getBufferSize();
                char[] charbuf = new char[bufferSize];
                try {
                    int lengthRemaining;
                    for (lengthRemaining = length; lengthRemaining >= bufferSize; lengthRemaining -= bufferSize) {
                        reader.read(charbuf);
                        writer.write(charbuf);
                    }
                    if (lengthRemaining > 0) {
                        reader.read(charbuf, 0, lengthRemaining);
                        writer.write(charbuf, 0, lengthRemaining);
                    }
                    writer.flush();
                }
                catch (IOException x) {
                    // empty catch block
                }
                this.addToTempLobsToFree(tclob);
                this.setCLOBInternal(paramIndex, tclob);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAsciiStreamContentsForClobCritical(int paramIndex, InputStream inputStream, int length) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.setAsciiStreamContentsForClobCritical(paramIndex=" + paramIndex + ", inputStream, length=" + length + ")", this);
            OracleLog.recursiveTrace = false;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                CLOB tclob = CLOB.createTemporary(this.connection, true, 10, this.currentRowFormOfUse[paramIndex - 1]);
                OracleClobWriter writer = (OracleClobWriter)tclob.setCharacterStream(1L);
                int bufferSize = tclob.getBufferSize();
                byte[] bytebuf = new byte[bufferSize];
                char[] charbuf = new char[bufferSize];
                try {
                    int lengthRemaining;
                    for (lengthRemaining = length; lengthRemaining >= bufferSize; lengthRemaining -= bufferSize) {
                        inputStream.read(bytebuf);
                        DBConversion cfr_ignored_0 = this.connection.conversion;
                        DBConversion.asciiBytesToJavaChars(bytebuf, bufferSize, charbuf);
                        writer.write(charbuf);
                    }
                    if (lengthRemaining > 0) {
                        inputStream.read(bytebuf, 0, lengthRemaining);
                        DBConversion cfr_ignored_1 = this.connection.conversion;
                        DBConversion.asciiBytesToJavaChars(bytebuf, lengthRemaining, charbuf);
                        writer.write(charbuf, 0, lengthRemaining);
                    }
                    writer.flush();
                }
                catch (IOException x) {
                    // empty catch block
                }
                this.addToTempLobsToFree(tclob);
                this.setCLOBInternal(paramIndex, tclob);
            }
        }
    }

    public void setStringForClobAtName(String paramName, String x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setStringForClobAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setStringForClob(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setFixedCHAR(int paramIndex, String x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setFixedCHAR(paramIndex=" + paramIndex + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setFixedCHARInternal(paramIndex, x);
    }

    void setFixedCHARInternal(int paramIndex, String x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        int stringLength = 0;
        if (x != null) {
            stringLength = x.length();
        }
        if (stringLength > 32766) {
            DatabaseError.throwSqlException(157);
        }
        if (x == null) {
            this.currentRowBinders[index] = this.theFixedCHARNullBinder;
            this.currentRowCharLens[index] = 1;
        } else {
            this.currentRowBinders[index] = this.theFixedCHARBinder;
            this.currentRowCharLens[index] = stringLength + 1;
            if (this.parameterString == null) {
                this.parameterString = new String[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterString[this.currentRank][index] = x;
        }
    }

    public void setFixedCHARAtName(String paramName, String x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setFixedCHARAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setFixedCHAR(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setCursor(int paramIndex, ResultSet rs) throws SQLException {
        this.setCursorInternal(paramIndex, rs);
    }

    void setCursorInternal(int paramIndex, ResultSet rs) throws SQLException {
        throw DatabaseError.newSqlException(23);
    }

    public void setCursorAtName(String paramName, ResultSet x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setCursorAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setCursor(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setROWID(int paramIndex, ROWID rowid) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setROWID(paramIndex=" + paramIndex + ", rowid=" + rowid + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setROWIDInternal(paramIndex, rowid);
    }

    void setROWIDInternal(int paramIndex, ROWID rowid) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (rowid == null) {
            this.currentRowBinders[index] = this.theRowidNullBinder;
        } else {
            this.currentRowBinders[index] = this.theRowidBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][index] = rowid.getBytes();
        }
        this.currentRowCharLens[index] = 0;
    }

    public void setROWIDAtName(String paramName, ROWID x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setROWIDAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setROWID(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public void setArray(int paramIndex, Array arr) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setArray(paramIndex=" + paramIndex + ", array)", this);
            OracleLog.recursiveTrace = false;
        }
        this.setARRAYInternal(paramIndex, (ARRAY)arr);
    }

    void setArrayInternal(int paramIndex, Array arr) throws SQLException {
        this.setARRAYInternal(paramIndex, (ARRAY)arr);
    }

    public void setArrayAtName(String paramName, Array x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setArrayAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setArrayInternal(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public void setARRAY(int paramIndex, ARRAY arr) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setARRAY(paramIndex=" + paramIndex + ", array)", this);
            OracleLog.recursiveTrace = false;
        }
        this.setARRAYInternal(paramIndex, arr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setARRAYInternal(int paramIndex, ARRAY arr) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (arr == null) {
            DatabaseError.throwSqlException(68);
        } else {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OraclePreparedStatement oraclePreparedStatement = this;
                synchronized (oraclePreparedStatement) {
                    this.setArrayCritical(index, arr);
                    this.currentRowCharLens[index] = 0;
                }
            }
        }
    }

    void setArrayCritical(int index, ARRAY arr) throws SQLException {
        ArrayDescriptor desc = arr.getDescriptor();
        if (desc == null) {
            DatabaseError.throwSqlException(61);
        }
        this.currentRowBinders[index] = this.theNamedTypeBinder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        this.parameterDatum[this.currentRank][index] = arr.toBytes();
        OracleTypeCOLLECTION otype = desc.getOracleTypeCOLLECTION();
        otype.getTOID();
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][index] = otype;
    }

    public void setARRAYAtName(String paramName, ARRAY x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setARRAYAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setARRAYInternal(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public void setOPAQUE(int paramIndex, OPAQUE opaque) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setOPAQUE(paramIndex=" + paramIndex + ", struct)", this);
            OracleLog.recursiveTrace = false;
        }
        this.setOPAQUEInternal(paramIndex, opaque);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOPAQUEInternal(int paramIndex, OPAQUE opaque) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (opaque == null) {
            DatabaseError.throwSqlException(68);
        } else {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OraclePreparedStatement oraclePreparedStatement = this;
                synchronized (oraclePreparedStatement) {
                    this.setOPAQUECritical(index, opaque);
                    this.currentRowCharLens[index] = 0;
                }
            }
        }
    }

    void setOPAQUECritical(int index, OPAQUE opaque) throws SQLException {
        OpaqueDescriptor desc = opaque.getDescriptor();
        if (desc == null) {
            DatabaseError.throwSqlException(61);
        }
        this.currentRowBinders[index] = this.theNamedTypeBinder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        this.parameterDatum[this.currentRank][index] = opaque.toBytes();
        OracleTypeADT otype = (OracleTypeADT)desc.getPickler();
        otype.getTOID();
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][index] = otype;
    }

    public void setOPAQUEAtName(String paramName, OPAQUE x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setOPAQUEAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setOPAQUEInternal(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public void setStructDescriptor(int paramIndex, StructDescriptor desc) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setStructDescriptor(paramIndex=" + paramIndex + ", desc)", this);
            OracleLog.recursiveTrace = false;
        }
        this.setStructDescriptorInternal(paramIndex, desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStructDescriptorInternal(int paramIndex, StructDescriptor desc) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (desc == null) {
            DatabaseError.throwSqlException(68);
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.setStructDescriptorCritical(index, desc);
                this.currentRowCharLens[index] = 0;
            }
        }
    }

    void setStructDescriptorCritical(int index, StructDescriptor desc) throws SQLException {
        this.currentRowBinders[index] = this.theNamedTypeBinder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        OracleTypeADT otype = desc.getOracleTypeADT();
        otype.getTOID();
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][index] = otype;
    }

    public void setStructDescriptorAtName(String paramName, StructDescriptor desc) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setStructDescriptor(" + paramName + ", " + desc + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setStructDescriptorInternal(i + 1, desc);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    synchronized void setPreBindsCompelete() throws SQLException {
    }

    public void setSTRUCT(int paramIndex, STRUCT struct) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setSTRUCT(paramIndex=" + paramIndex + ", struct)", this);
            OracleLog.recursiveTrace = false;
        }
        this.setSTRUCTInternal(paramIndex, struct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSTRUCTInternal(int paramIndex, STRUCT struct) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (struct == null) {
            DatabaseError.throwSqlException(68);
        } else {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OraclePreparedStatement oraclePreparedStatement = this;
                synchronized (oraclePreparedStatement) {
                    this.setSTRUCTCritical(index, struct);
                    this.currentRowCharLens[index] = 0;
                }
            }
        }
    }

    void setSTRUCTCritical(int index, STRUCT struct) throws SQLException {
        StructDescriptor desc = struct.getDescriptor();
        if (desc == null) {
            DatabaseError.throwSqlException(61);
        }
        this.currentRowBinders[index] = this.theNamedTypeBinder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        this.parameterDatum[this.currentRank][index] = struct.toBytes();
        OracleTypeADT otype = desc.getOracleTypeADT();
        otype.getTOID();
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][index] = otype;
    }

    public void setSTRUCTAtName(String paramName, STRUCT x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setSTRUCTAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setSTRUCTInternal(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setRAW(int paramIndex, RAW raw) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setRAW(paramIndex=" + paramIndex + ", raw)", this);
            OracleLog.recursiveTrace = false;
        }
        this.setRAWInternal(paramIndex, raw);
    }

    void setRAWInternal(int paramIndex, RAW raw) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[index] = 0;
        if (raw == null) {
            this.currentRowBinders[index] = this.theRawNullBinder;
        } else {
            this.setBytesInternal(paramIndex, raw.getBytes());
        }
    }

    public void setRAWAtName(String paramName, RAW x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setRAWAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setRAW(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setCHAR(int paramIndex, CHAR ch) throws SQLException {
        this.setCHARInternal(paramIndex, ch);
    }

    void setCHARInternal(int paramIndex, CHAR ch) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (ch == null || ch.shareBytes().length == 0) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setCHARInternal(paramIdx=" + paramIndex + ", CHAR=null)", this);
                OracleLog.recursiveTrace = false;
            }
            this.currentRowBinders[index] = this.theSetCHARNullBinder;
            this.currentRowCharLens[index] = 1;
        } else {
            byte[] b;
            CharacterSet targetCS;
            short char_cs_id = (short)ch.oracleId();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setCHARInternal(paramIdx=" + paramIndex + ", CHAR=(charsetid=" + char_cs_id + ")", this);
                OracleLog.recursiveTrace = false;
            }
            this.currentRowBinders[index] = this.theSetCHARBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            CharacterSet characterSet = targetCS = this.currentRowFormOfUse[index] == 2 ? this.connection.setCHARNCharSetObj : this.connection.setCHARCharSetObj;
            if (targetCS != null && targetCS.getOracleId() != char_cs_id) {
                byte[] cb = ch.shareBytes();
                b = targetCS.convert(ch.getCharacterSet(), cb, 0, cb.length);
            } else {
                b = ch.getBytes();
            }
            this.parameterDatum[this.currentRank][index] = b;
            this.currentRowCharLens[index] = (b.length + 1 >> 1) + 1;
        }
        if ((this.sqlKind == 1 || this.sqlKind == 4) && this.currentRowCharLens[index] < this.minVcsBindSize) {
            this.currentRowCharLens[index] = this.minVcsBindSize;
        }
    }

    public void setCHARAtName(String paramName, CHAR x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setCHARAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setCHAR(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setDATE(int paramIndex, DATE date) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setDATE(paramIndex=" + paramIndex + ", date=" + date + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setDATEInternal(paramIndex, date);
    }

    void setDATEInternal(int paramIndex, DATE date) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[index] = 0;
        if (date == null) {
            this.currentRowBinders[index] = this.theDateNullBinder;
        } else {
            this.currentRowBinders[index] = this.theOracleDateBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][index] = date.getBytes();
        }
    }

    public void setDATEAtName(String paramName, DATE x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setDATEAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setDATE(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setNUMBER(int paramIndex, NUMBER num) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setNUMBER(paramIndex=" + paramIndex + ", num)", this);
            OracleLog.recursiveTrace = false;
        }
        this.setNUMBERInternal(paramIndex, num);
    }

    void setNUMBERInternal(int paramIndex, NUMBER num) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[index] = 0;
        if (num == null) {
            this.currentRowBinders[index] = this.theVarnumNullBinder;
        } else {
            this.currentRowBinders[index] = this.theOracleNumberBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][index] = num.getBytes();
        }
    }

    public void setNUMBERAtName(String paramName, NUMBER x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setNUMBERAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setNUMBER(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setBLOB(int paramIndex, BLOB lob) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setBLOB(paramIndex=" + paramIndex + ", lob)", this);
            OracleLog.recursiveTrace = false;
        }
        this.setBLOBInternal(paramIndex, lob);
    }

    void setBLOBInternal(int paramIndex, BLOB lob) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[index] = 0;
        if (lob == null) {
            this.currentRowBinders[index] = this.theBlobNullBinder;
        } else {
            this.currentRowBinders[index] = this.theBlobBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][index] = lob.getBytes();
        }
    }

    public void setBLOBAtName(String paramName, BLOB x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setBLOBAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setBLOB(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setBlob(int paramIndex, Blob lob) throws SQLException {
        this.setBLOBInternal(paramIndex, (BLOB)lob);
    }

    void setBlobInternal(int paramIndex, Blob lob) throws SQLException {
        this.setBLOBInternal(paramIndex, (BLOB)lob);
    }

    public void setBlobAtName(String paramName, Blob x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setBlobAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setBlob(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setCLOB(int paramIndex, CLOB lob) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setCLOB(" + paramIndex + ", " + lob + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setCLOBInternal(paramIndex, lob);
    }

    void setCLOBInternal(int paramIndex, CLOB lob) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[index] = 0;
        if (lob == null) {
            this.currentRowBinders[index] = this.theClobNullBinder;
        } else {
            this.currentRowBinders[index] = this.theClobBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][index] = lob.getBytes();
        }
    }

    public void setCLOBAtName(String paramName, CLOB x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setCLOBAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setCLOB(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setClob(int paramIndex, Clob lob) throws SQLException {
        this.setCLOBInternal(paramIndex, (CLOB)lob);
    }

    void setClobInternal(int paramIndex, Clob lob) throws SQLException {
        this.setCLOBInternal(paramIndex, (CLOB)lob);
    }

    public void setClobAtName(String paramName, Clob x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setClobAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setClob(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setBFILE(int paramIndex, BFILE file) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setBFILE(paramIndex=" + paramIndex + ", file)", this);
            OracleLog.recursiveTrace = false;
        }
        this.setBFILEInternal(paramIndex, file);
    }

    void setBFILEInternal(int paramIndex, BFILE file) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[index] = 0;
        if (file == null) {
            this.currentRowBinders[index] = this.theBfileNullBinder;
        } else {
            this.currentRowBinders[index] = this.theBfileBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][index] = file.getBytes();
        }
    }

    public void setBFILEAtName(String paramName, BFILE x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setBFILEAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setBFILE(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setBfile(int paramIndex, BFILE file) throws SQLException {
        this.setBFILEInternal(paramIndex, file);
    }

    void setBfileInternal(int paramIndex, BFILE file) throws SQLException {
        this.setBFILEInternal(paramIndex, file);
    }

    public void setBfileAtName(String paramName, BFILE x) throws SQLException {
        this.setBFILEAtName(paramName, x);
    }

    public synchronized void setBytes(int paramIndex, byte[] x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setBytes(paramIndex=" + paramIndex + ", bytes)", this);
            OracleLog.recursiveTrace = false;
        }
        this.setBytesInternal(paramIndex, x);
    }

    void setBytesInternal(int paramIndex, byte[] x) throws SQLException {
        int byteLength;
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        int n = byteLength = x != null ? x.length : 0;
        if (byteLength == 0) {
            this.setNullInternal(paramIndex, -2);
        } else if (this.sqlKind == 1) {
            if (byteLength > this.maxRawBytesPlsql) {
                this.setBytesForBlobCritical(paramIndex, x);
            } else {
                this.basicBindBytes(paramIndex, x);
            }
        } else if (this.sqlKind == 4) {
            if (byteLength > this.maxRawBytesPlsql) {
                this.setBytesForBlobCritical(paramIndex, x);
            } else {
                this.basicBindBytes(paramIndex, x);
            }
        } else if (byteLength > this.maxRawBytesSql) {
            this.bindBytesAsStream(paramIndex, x);
        } else {
            this.basicBindBytes(paramIndex, x);
        }
    }

    void bindBytesAsStream(int paramIndex, byte[] x) throws SQLException {
        int byteLength = x.length;
        byte[] bytebuf = new byte[byteLength];
        System.arraycopy(x, 0, bytebuf, 0, byteLength);
        this.basicBindBinaryStream(paramIndex, new ByteArrayInputStream(bytebuf), byteLength);
    }

    void basicBindBytes(int paramIndex, byte[] x) throws SQLException {
        Binder binder;
        int index = paramIndex - 1;
        this.currentRowBinders[index] = binder = this.sqlKind == 1 || this.sqlKind == 4 ? this.thePlsqlRawBinder : this.theRawBinder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        this.parameterDatum[this.currentRank][index] = x;
        this.currentRowCharLens[index] = 0;
    }

    void basicBindBinaryStream(int paramIndex, InputStream istream, int length) throws SQLException {
        int index = paramIndex - 1;
        this.currentRowBinders[index] = this.theLongRawStreamBinder;
        if (this.parameterStream == null) {
            this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterStream[this.currentRank][index] = this.connection.conversion.ConvertStream(istream, 6, length);
        this.currentRowCharLens[index] = 0;
    }

    public void setBytesAtName(String paramName, byte[] x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setBytesAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setBytes(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public void setBytesForBlob(int paramIndex, byte[] x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setBytesForBlob(paramIndex=" + paramIndex + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (x == null) {
            this.setNull(paramIndex, -2);
            return;
        }
        int arrayLength = x.length;
        if (arrayLength == 0) {
            this.setNull(paramIndex, -2);
            return;
        }
        if (this.sqlKind == 1 || this.sqlKind == 4) {
            if (arrayLength <= this.maxRawBytesPlsql) {
                this.setBytes(paramIndex, x);
            } else {
                this.setBytesForBlobCritical(paramIndex, x);
            }
        } else if (arrayLength <= this.maxRawBytesSql) {
            this.setBytes(paramIndex, x);
        } else {
            this.setBytesForBlobCritical(paramIndex, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBytesForBlobCritical(int paramIndex, byte[] x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.setBytesForBlobCritical(paramIndex=" + paramIndex + " , byte array )", this);
            OracleLog.recursiveTrace = false;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                BLOB tblob = BLOB.createTemporary(this.connection, true, 10);
                tblob.putBytes(1L, x);
                this.addToTempLobsToFree(tblob);
                this.setBLOBInternal(paramIndex, tblob);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBinaryStreamContentsForBlobCritical(int paramIndex, InputStream inputStream, int length) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.setBinaryStreamContentsForBlobCritical(paramIndex=" + paramIndex + ", inputStream, length=" + length + ")", this);
            OracleLog.recursiveTrace = false;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                BLOB tblob = BLOB.createTemporary(this.connection, true, 10);
                OracleBlobOutputStream outputStream = (OracleBlobOutputStream)tblob.setBinaryStream(1L);
                int bufferSize = tblob.getBufferSize();
                byte[] bytebuf = new byte[bufferSize];
                try {
                    int lengthRemaining;
                    for (lengthRemaining = length; lengthRemaining >= bufferSize; lengthRemaining -= bufferSize) {
                        inputStream.read(bytebuf);
                        outputStream.write(bytebuf);
                    }
                    if (lengthRemaining > 0) {
                        inputStream.read(bytebuf, 0, lengthRemaining);
                        outputStream.write(bytebuf, 0, lengthRemaining);
                    }
                    outputStream.flush();
                }
                catch (IOException x) {
                    // empty catch block
                }
                this.addToTempLobsToFree(tblob);
                this.setBLOBInternal(paramIndex, tblob);
            }
        }
    }

    public void setBytesForBlobAtName(String paramName, byte[] x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setBytesForBlobAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setBytesForBlob(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setInternalBytes(int paramIndex, byte[] x, int dbtype) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setInternalBytes(paramIndex=" + paramIndex + ", bytes, dbtype=" + dbtype, this);
            OracleLog.recursiveTrace = false;
        }
        this.setInternalBytesInternal(paramIndex, x, dbtype);
    }

    void setInternalBytesInternal(int paramIndex, byte[] x, int dbtype) throws SQLException {
        DatabaseError.throwSqlException(23);
    }

    public synchronized void setDate(int paramIndex, Date x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setDate(paramIndex=" + paramIndex + ", date)", this);
            OracleLog.recursiveTrace = false;
        }
        this.setDateInternal(paramIndex, x);
    }

    void setDateInternal(int paramIndex, Date x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (x == null) {
            this.currentRowBinders[index] = this.theDateNullBinder;
        } else {
            this.currentRowBinders[index] = this.theDateBinder;
            if (this.parameterDate == null) {
                this.parameterDate = new Date[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterDate[this.currentRank][index] = x;
        }
        this.currentRowCharLens[index] = 0;
    }

    public void setDateAtName(String paramName, Date x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setDateAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setDate(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setTime(int paramIndex, Time x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setTime(paramIndex=" + paramIndex + ", time)", this);
            OracleLog.recursiveTrace = false;
        }
        this.setTimeInternal(paramIndex, x);
    }

    void setTimeInternal(int paramIndex, Time x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (x == null) {
            this.currentRowBinders[index] = this.theDateNullBinder;
        } else {
            this.currentRowBinders[index] = this.theTimeBinder;
            if (this.parameterTime == null) {
                this.parameterTime = new Time[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterTime[this.currentRank][index] = x;
        }
        this.currentRowCharLens[index] = 0;
    }

    public void setTimeAtName(String paramName, Time x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setTimeAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setTime(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setTimestamp(int paramIndex, Timestamp x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setTimestamp(paramIndex=" + paramIndex + ", timestamp)", this);
            OracleLog.recursiveTrace = false;
        }
        this.setTimestampInternal(paramIndex, x);
    }

    void setTimestampInternal(int paramIndex, Timestamp x) throws SQLException {
        if (this.connection.v8Compatible) {
            if (x == null) {
                this.setDATEInternal(paramIndex, null);
            } else {
                DATE d = new DATE(x);
                this.setDATEInternal(paramIndex, d);
            }
        } else {
            int index = paramIndex - 1;
            if (index < 0 || paramIndex > this.numberOfBindPositions) {
                DatabaseError.throwSqlException(3);
            }
            if (x == null) {
                this.currentRowBinders[index] = this.theTimestampNullBinder;
            } else {
                this.currentRowBinders[index] = this.theTimestampBinder;
                if (this.parameterTimestamp == null) {
                    this.parameterTimestamp = new Timestamp[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
                }
                this.parameterTimestamp[this.currentRank][index] = x;
            }
            this.currentRowCharLens[index] = 0;
        }
    }

    public void setTimestampAtName(String paramName, Timestamp x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setTimestampAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setTimestamp(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setINTERVALYM(int paramIndex, INTERVALYM x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setINTERVALYM(paramIndex=" + paramIndex + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setINTERVALYMInternal(paramIndex, x);
    }

    void setINTERVALYMInternal(int paramIndex, INTERVALYM x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (x == null) {
            this.currentRowBinders[index] = this.theIntervalYMNullBinder;
        } else {
            this.currentRowBinders[index] = this.theIntervalYMBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][index] = x.getBytes();
        }
        this.currentRowCharLens[index] = 0;
    }

    public void setINTERVALYMAtName(String paramName, INTERVALYM x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setINTERVALYMAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setINTERVALYM(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setINTERVALDS(int paramIndex, INTERVALDS x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setINTERVALDS(paramIndex=" + paramIndex + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setINTERVALDSInternal(paramIndex, x);
    }

    void setINTERVALDSInternal(int paramIndex, INTERVALDS x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (x == null) {
            this.currentRowBinders[index] = this.theIntervalDSNullBinder;
        } else {
            this.currentRowBinders[index] = this.theIntervalDSBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][index] = x.getBytes();
        }
        this.currentRowCharLens[index] = 0;
    }

    public void setINTERVALDSAtName(String paramName, INTERVALDS x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setINTERVALDSAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setINTERVALDS(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setTIMESTAMP(int paramIndex, TIMESTAMP x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setTIMESTAMP(paramIndex=" + paramIndex + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setTIMESTAMPInternal(paramIndex, x);
    }

    void setTIMESTAMPInternal(int paramIndex, TIMESTAMP x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (x == null) {
            this.currentRowBinders[index] = this.theTimestampNullBinder;
        } else {
            this.currentRowBinders[index] = this.theOracleTimestampBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][index] = x.getBytes();
        }
        this.currentRowCharLens[index] = 0;
    }

    public void setTIMESTAMPAtName(String paramName, TIMESTAMP x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setTIMESTAMPAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setTIMESTAMP(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setTIMESTAMPTZ(int paramIndex, TIMESTAMPTZ x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setTIMESTAMPTZ(paramIndex=" + paramIndex + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setTIMESTAMPTZInternal(paramIndex, x);
    }

    void setTIMESTAMPTZInternal(int paramIndex, TIMESTAMPTZ x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (x == null) {
            this.currentRowBinders[index] = this.theTSTZNullBinder;
        } else {
            this.currentRowBinders[index] = this.theTSTZBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][index] = x.getBytes();
        }
        this.currentRowCharLens[index] = 0;
    }

    public void setTIMESTAMPTZAtName(String paramName, TIMESTAMPTZ x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setTIMESTAMPTZAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setTIMESTAMPTZ(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setTIMESTAMPLTZ(int paramIndex, TIMESTAMPLTZ x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setTIMESTAMPLTZ(paramIndex=" + paramIndex + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setTIMESTAMPLTZInternal(paramIndex, x);
    }

    void setTIMESTAMPLTZInternal(int paramIndex, TIMESTAMPLTZ x) throws SQLException {
        int index;
        if (this.connection.getSessionTimeZone() == null) {
            DatabaseError.throwSqlException(105);
        }
        if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (x == null) {
            this.currentRowBinders[index] = this.theTSLTZNullBinder;
        } else {
            this.currentRowBinders[index] = this.theTSLTZBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][index] = x.getBytes();
        }
        this.currentRowCharLens[index] = 0;
    }

    public void setTIMESTAMPLTZAtName(String paramName, TIMESTAMPLTZ x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setTIMESTAMPLTZAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setTIMESTAMPLTZ(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public synchronized void setAsciiStream(int paramIndex, InputStream istream, int length) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setAsciiStream(paramIndex=" + paramIndex + ", istream, length=" + length + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setAsciiStreamInternal(paramIndex, istream, length);
    }

    void setAsciiStreamInternal(int paramIndex, InputStream istream, int length) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.set_execute_batch(1);
        if (istream == null) {
            this.basicBindNullString(paramIndex);
        } else if (this.userRsetType != 1 && length > this.maxVcsCharsSql) {
            DatabaseError.throwSqlException(169);
        } else if (this.currentRowFormOfUse[index] == 1) {
            if (this.sqlKind == 1 || this.sqlKind == 4) {
                if (length <= this.maxVcsCharsPlsql) {
                    this.setAsciiStreamContentsForStringInternal(paramIndex, istream, length);
                } else {
                    this.setAsciiStreamContentsForClobCritical(paramIndex, istream, length);
                }
            } else if (length <= this.maxVcsCharsSql) {
                this.setAsciiStreamContentsForStringInternal(paramIndex, istream, length);
            } else {
                this.basicBindAsciiStream(paramIndex, istream, length);
            }
        } else if (this.sqlKind == 1 || this.sqlKind == 4) {
            if (length <= this.maxVcsNCharsPlsql) {
                this.setAsciiStreamContentsForStringInternal(paramIndex, istream, length);
            } else {
                this.setAsciiStreamContentsForClobCritical(paramIndex, istream, length);
            }
        } else if (length <= this.maxVcsCharsSql) {
            this.setAsciiStreamContentsForStringInternal(paramIndex, istream, length);
        } else {
            this.setAsciiStreamContentsForClobCritical(paramIndex, istream, length);
        }
    }

    void basicBindAsciiStream(int paramIndex, InputStream istream, int length) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINER, "OraclePreparedStatement.basicBindAsciiStream=", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.userRsetType != 1) {
            DatabaseError.throwSqlException(169);
        }
        int index = paramIndex - 1;
        this.currentRowBinders[index] = this.theLongStreamBinder;
        if (this.parameterStream == null) {
            this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterStream[this.currentRank][index] = this.connection.conversion.ConvertStream(istream, 5, length);
        this.currentRowCharLens[index] = 0;
    }

    void setAsciiStreamContentsForStringInternal(int paramIndex, InputStream istream, int length) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.setAsciiStreamContentsForStringInternal(paramIndex=" + paramIndex + ", inputStream, length=" + length + ")", this);
            OracleLog.recursiveTrace = false;
        }
        byte[] bytebuf = new byte[length];
        int actual_length = 0;
        try {
            actual_length = istream.read(bytebuf, 0, length);
            if (actual_length == -1) {
                actual_length = 0;
            }
        }
        catch (IOException e) {
            DatabaseError.throwSqlException(e);
        }
        if (actual_length == 0) {
            this.basicBindNullString(paramIndex);
        }
        char[] charbuf = new char[length];
        DBConversion cfr_ignored_0 = this.connection.conversion;
        DBConversion.asciiBytesToJavaChars(bytebuf, actual_length, charbuf);
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            byte[] crap = new byte[length];
            int crud = this.connection.conversion.javaCharsToDbCsBytes(charbuf, 0, crap, 0, length);
            OracleLog.conversionLogger.log(Level.FINE, "OraclePrepareStatement.setAsciiStreamInternal(" + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(charbuf)) + OracleLog.bytesToPrintableForm("bytes[]=", crap) + "crud=" + crud + ")", this);
            crap = this.connection.conversion.asciiBytesToCHARBytes(bytebuf);
            OracleLog.conversionLogger.log(Level.FINE, "OraclePrepareStatement.setAsciiStreamInternal2(" + OracleLog.bytesToPrintableForm("in bytes[]=", bytebuf) + OracleLog.bytesToPrintableForm("outbytes[]=", crap) + "dbCS: " + this.connection.conversion.getDbCharSetObj() + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.basicBindString(paramIndex, new String(charbuf));
    }

    public void setAsciiStreamAtName(String paramName, InputStream stream, int length) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setAsciiStream(" + paramName + ", " + stream + ", " + length + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        boolean firstOccurrence = true;
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            if (firstOccurrence) {
                this.setAsciiStream(i + 1, stream, length);
                firstOccurrence = false;
                continue;
            }
            DatabaseError.throwSqlException(135);
        }
    }

    public synchronized void setBinaryStream(int paramIndex, InputStream istream, int length) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setBinaryStream(paramIndex=" + paramIndex + ", istream, length=" + length + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setBinaryStreamInternal(paramIndex, istream, length);
    }

    void setBinaryStreamInternal(int paramIndex, InputStream istream, int length) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.set_execute_batch(1);
        if (istream == null) {
            this.setRAWInternal(paramIndex, null);
        } else if (this.userRsetType != 1 && length > this.maxRawBytesSql) {
            DatabaseError.throwSqlException(169);
        } else if (this.sqlKind == 1 || this.sqlKind == 4) {
            if (length > this.maxRawBytesPlsql) {
                this.setBinaryStreamContentsForBlobCritical(paramIndex, istream, length);
            } else {
                this.setBinaryStreamContentsForByteArrayInternal(paramIndex, istream, length);
            }
        } else if (length > this.maxRawBytesSql) {
            this.basicBindBinaryStream(paramIndex, istream, length);
        } else {
            this.setBinaryStreamContentsForByteArrayInternal(paramIndex, istream, length);
        }
    }

    void setBinaryStreamContentsForByteArrayInternal(int paramIndex, InputStream inputStream, int length) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.setBinaryStreamContentsForByteArrayInternal(paramIndex=" + paramIndex + ", inputStream, length=" + length + ")", this);
            OracleLog.recursiveTrace = false;
        }
        byte[] bytebuf = new byte[length];
        int actual_length = 0;
        try {
            actual_length = inputStream.read(bytebuf, 0, length);
            if (actual_length == -1) {
                actual_length = 0;
            }
        }
        catch (IOException e) {
            DatabaseError.throwSqlException(e);
        }
        if (actual_length != length) {
            byte[] newbuf = new byte[actual_length];
            System.arraycopy(bytebuf, 0, newbuf, 0, actual_length);
            bytebuf = newbuf;
        }
        this.setBytesInternal(paramIndex, bytebuf);
    }

    public void setBinaryStreamAtName(String paramName, InputStream stream, int length) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setBinaryStream(" + paramName + ", " + stream + ", " + length + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        boolean firstOccurrence = true;
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            if (firstOccurrence) {
                this.setBinaryStream(i + 1, stream, length);
                firstOccurrence = false;
                continue;
            }
            DatabaseError.throwSqlException(135);
        }
    }

    public synchronized void setUnicodeStream(int paramIndex, InputStream istream, int length) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setUnicodeStream(paramIndex=" + paramIndex + ", istream, length=" + length + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setUnicodeStreamInternal(paramIndex, istream, length);
    }

    void setUnicodeStreamInternal(int paramIndex, InputStream istream, int length) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.set_execute_batch(1);
        if (istream == null) {
            this.setStringInternal(paramIndex, null);
        } else if (this.userRsetType != 1 && length > this.maxVcsCharsSql) {
            DatabaseError.throwSqlException(169);
        } else if (this.sqlKind == 1 || this.sqlKind == 4 || length <= this.maxVcsCharsSql) {
            byte[] bytebuf = new byte[length];
            int actual_length = 0;
            try {
                actual_length = istream.read(bytebuf, 0, length);
                if (actual_length == -1) {
                    actual_length = 0;
                }
            }
            catch (IOException e) {
                DatabaseError.throwSqlException(e);
            }
            char[] charbuf = new char[actual_length >> 1];
            DBConversion cfr_ignored_0 = this.connection.conversion;
            DBConversion.ucs2BytesToJavaChars(bytebuf, actual_length, charbuf);
            this.setStringInternal(paramIndex, new String(charbuf));
        } else {
            this.currentRowBinders[index] = this.theLongStreamBinder;
            if (this.parameterStream == null) {
                this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterStream[this.currentRank][index] = this.connection.conversion.ConvertStream(istream, 4, length);
            this.currentRowCharLens[index] = 0;
        }
    }

    public void setUnicodeStreamAtName(String paramName, InputStream stream, int length) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setUnicodeStream(" + paramName + ", " + stream + ", " + length + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        boolean firstOccurrence = true;
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            if (firstOccurrence) {
                this.setUnicodeStream(i + 1, stream, length);
                firstOccurrence = false;
                continue;
            }
            DatabaseError.throwSqlException(135);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomDatum(int paramIndex, CustomDatum x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setCustomDatum(paramIndex=" + paramIndex + ", customDatum)", this);
            OracleLog.recursiveTrace = false;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.setObjectInternal(paramIndex, this.connection.toDatum(x));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCustomDatumInternal(int paramIndex, CustomDatum x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                Datum datum = this.connection.toDatum(x);
                int sqlType = this.sqlTypeForObject(datum);
                this.setObjectCritical(paramIndex, datum, sqlType, 0);
                this.currentRowCharLens[paramIndex - 1] = 0;
            }
        }
    }

    public void setCustomDatumAtName(String paramName, CustomDatum x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setCustomDatumAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setCustomDatumInternal(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public void setORAData(int paramIndex, ORAData x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setORAData(paramIndex=" + paramIndex + ", ORAData)", this);
            OracleLog.recursiveTrace = false;
        }
        this.setORADataInternal(paramIndex, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setORADataInternal(int paramIndex, ORAData x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                Datum datum = x.toDatum(this.connection);
                int sqlType = this.sqlTypeForObject(datum);
                this.setObjectCritical(paramIndex, datum, sqlType, 0);
                this.currentRowCharLens[paramIndex - 1] = 0;
            }
        }
    }

    public void setORADataAtName(String paramName, ORAData x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setORADataAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setORADataInternal(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public void setObject(int paramIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setObject(paramIndex=" + paramIndex + ", object, targetSqlType=" + targetSqlType + ", scale=" + scale + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setObjectInternal(paramIndex, x, targetSqlType, scale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setObjectInternal(int paramIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (x == null && targetSqlType != 2002 && targetSqlType != 2008 && targetSqlType != 2003 && targetSqlType != 2007 && targetSqlType != 2006) {
            this.setNullInternal(paramIndex, targetSqlType);
        } else {
            if (targetSqlType == 2002 || targetSqlType == 2008 || targetSqlType == 2003) {
                PhysicalConnection physicalConnection = this.connection;
                synchronized (physicalConnection) {
                    OraclePreparedStatement oraclePreparedStatement = this;
                    synchronized (oraclePreparedStatement) {
                        this.setObjectCritical(paramIndex, x, targetSqlType, scale);
                        this.currentRowCharLens[paramIndex - 1] = 0;
                    }
                }
            }
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.setObjectCritical(paramIndex, x, targetSqlType, scale);
            }
        }
    }

    void setObjectCritical(int paramIndex, Object x, int targetSqlType, int scale) throws SQLException {
        switch (targetSqlType) {
            case 1: {
                if (x instanceof CHAR) {
                    this.setCHARInternal(paramIndex, (CHAR)x);
                    break;
                }
                if (x instanceof String) {
                    this.setStringInternal(paramIndex, (String)x);
                    break;
                }
                if (x instanceof Boolean) {
                    this.setStringInternal(paramIndex, "" + ((Boolean)x != false ? 1 : 0));
                    break;
                }
                if (x instanceof Integer) {
                    this.setStringInternal(paramIndex, "" + (Integer)x);
                    break;
                }
                if (x instanceof Long) {
                    this.setStringInternal(paramIndex, "" + (Long)x);
                    break;
                }
                if (x instanceof Float) {
                    this.setStringInternal(paramIndex, "" + ((Float)x).floatValue());
                    break;
                }
                if (x instanceof Double) {
                    this.setStringInternal(paramIndex, "" + (Double)x);
                    break;
                }
                if (x instanceof BigDecimal) {
                    this.setStringInternal(paramIndex, ((BigDecimal)x).toString());
                    break;
                }
                if (x instanceof Date) {
                    this.setStringInternal(paramIndex, "" + ((Date)x).toString());
                    break;
                }
                if (x instanceof Time) {
                    this.setStringInternal(paramIndex, "" + ((Time)x).toString());
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setStringInternal(paramIndex, "" + ((Timestamp)x).toString());
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 12: {
                if (x instanceof String) {
                    this.setStringInternal(paramIndex, (String)x);
                    break;
                }
                if (x instanceof Boolean) {
                    this.setStringInternal(paramIndex, "" + ((Boolean)x != false ? 1 : 0));
                    break;
                }
                if (x instanceof Integer) {
                    this.setStringInternal(paramIndex, "" + (Integer)x);
                    break;
                }
                if (x instanceof Long) {
                    this.setStringInternal(paramIndex, "" + (Long)x);
                    break;
                }
                if (x instanceof Float) {
                    this.setStringInternal(paramIndex, "" + ((Float)x).floatValue());
                    break;
                }
                if (x instanceof Double) {
                    this.setStringInternal(paramIndex, "" + (Double)x);
                    break;
                }
                if (x instanceof BigDecimal) {
                    this.setStringInternal(paramIndex, ((BigDecimal)x).toString());
                    break;
                }
                if (x instanceof Date) {
                    this.setStringInternal(paramIndex, "" + ((Date)x).toString());
                    break;
                }
                if (x instanceof Time) {
                    this.setStringInternal(paramIndex, "" + ((Time)x).toString());
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setStringInternal(paramIndex, "" + ((Timestamp)x).toString());
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 999: {
                this.setFixedCHARInternal(paramIndex, (String)x);
                break;
            }
            case -1: {
                if (x instanceof String) {
                    this.setStringInternal(paramIndex, (String)x);
                    break;
                }
                if (x instanceof Boolean) {
                    this.setStringInternal(paramIndex, "" + ((Boolean)x != false ? 1 : 0));
                    break;
                }
                if (x instanceof Integer) {
                    this.setStringInternal(paramIndex, "" + (Integer)x);
                    break;
                }
                if (x instanceof Long) {
                    this.setStringInternal(paramIndex, "" + (Long)x);
                    break;
                }
                if (x instanceof Float) {
                    this.setStringInternal(paramIndex, "" + ((Float)x).floatValue());
                    break;
                }
                if (x instanceof Double) {
                    this.setStringInternal(paramIndex, "" + (Double)x);
                    break;
                }
                if (x instanceof BigDecimal) {
                    this.setStringInternal(paramIndex, ((BigDecimal)x).toString());
                    break;
                }
                if (x instanceof Date) {
                    this.setStringInternal(paramIndex, "" + ((Date)x).toString());
                    break;
                }
                if (x instanceof Time) {
                    this.setStringInternal(paramIndex, "" + ((Time)x).toString());
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setStringInternal(paramIndex, "" + ((Timestamp)x).toString());
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 2: {
                if (x instanceof NUMBER) {
                    this.setNUMBERInternal(paramIndex, (NUMBER)x);
                    break;
                }
                if (x instanceof Integer) {
                    this.setIntInternal(paramIndex, (Integer)x);
                    break;
                }
                if (x instanceof Long) {
                    this.setLongInternal(paramIndex, (Long)x);
                    break;
                }
                if (x instanceof Float) {
                    this.setFloatInternal(paramIndex, ((Float)x).floatValue());
                    break;
                }
                if (x instanceof Double) {
                    this.setDoubleInternal(paramIndex, (Double)x);
                    break;
                }
                if (x instanceof BigDecimal) {
                    this.setBigDecimalInternal(paramIndex, (BigDecimal)x);
                    break;
                }
                if (x instanceof String) {
                    this.setNUMBERInternal(paramIndex, new NUMBER((String)x, 0));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setIntInternal(paramIndex, (Boolean)x != false ? 1 : 0);
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 3: {
                if (x instanceof BigDecimal) {
                    this.setBigDecimalInternal(paramIndex, (BigDecimal)x);
                    break;
                }
                if (x instanceof Number) {
                    this.setBigDecimalInternal(paramIndex, new BigDecimal(((Number)x).doubleValue()));
                    break;
                }
                if (x instanceof NUMBER) {
                    this.setBigDecimalInternal(paramIndex, ((NUMBER)x).bigDecimalValue());
                    break;
                }
                if (x instanceof String) {
                    this.setBigDecimalInternal(paramIndex, new BigDecimal((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setBigDecimalInternal(paramIndex, new BigDecimal((Boolean)x != false ? 1.0 : 0.0));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case -7: {
                if (x instanceof Boolean) {
                    this.setByteInternal(paramIndex, (byte)((Boolean)x != false ? 1 : 0));
                    break;
                }
                if (x instanceof String) {
                    this.setByteInternal(paramIndex, (byte)("true".equalsIgnoreCase((String)x) || "1".equals(x) ? 1 : 0));
                    break;
                }
                if (x instanceof Number) {
                    this.setIntInternal(paramIndex, ((Number)x).byteValue() != 0 ? 1 : 0);
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case -6: {
                if (x instanceof Number) {
                    this.setByteInternal(paramIndex, ((Number)x).byteValue());
                    break;
                }
                if (x instanceof String) {
                    this.setByteInternal(paramIndex, Byte.parseByte((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setByteInternal(paramIndex, (byte)((Boolean)x != false ? 1 : 0));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 5: {
                if (x instanceof Number) {
                    this.setShortInternal(paramIndex, ((Number)x).shortValue());
                    break;
                }
                if (x instanceof String) {
                    this.setShortInternal(paramIndex, Short.parseShort((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setShortInternal(paramIndex, (short)((Boolean)x != false ? 1 : 0));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 4: {
                if (x instanceof Number) {
                    this.setIntInternal(paramIndex, ((Number)x).intValue());
                    break;
                }
                if (x instanceof String) {
                    this.setIntInternal(paramIndex, Integer.parseInt((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setIntInternal(paramIndex, (Boolean)x != false ? 1 : 0);
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case -5: {
                if (x instanceof Number) {
                    this.setLongInternal(paramIndex, ((Number)x).longValue());
                    break;
                }
                if (x instanceof String) {
                    this.setLongInternal(paramIndex, Long.parseLong((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setLongInternal(paramIndex, (Boolean)x != false ? 1L : 0L);
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 7: {
                if (x instanceof Number) {
                    this.setFloatInternal(paramIndex, ((Number)x).floatValue());
                    break;
                }
                if (x instanceof String) {
                    this.setFloatInternal(paramIndex, Float.valueOf((String)x).floatValue());
                    break;
                }
                if (x instanceof Boolean) {
                    this.setFloatInternal(paramIndex, (Boolean)x != false ? 1.0f : 0.0f);
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 6: 
            case 8: {
                if (x instanceof Number) {
                    this.setDoubleInternal(paramIndex, ((Number)x).doubleValue());
                    break;
                }
                if (x instanceof String) {
                    this.setDoubleInternal(paramIndex, Double.valueOf((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setDoubleInternal(paramIndex, (Boolean)x != false ? 1.0 : 0.0);
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case -2: {
                if (x instanceof RAW) {
                    this.setRAWInternal(paramIndex, (RAW)x);
                    break;
                }
                this.setBytesInternal(paramIndex, (byte[])x);
                break;
            }
            case -3: {
                this.setBytesInternal(paramIndex, (byte[])x);
                break;
            }
            case -4: {
                this.setBytesInternal(paramIndex, (byte[])x);
                break;
            }
            case 91: {
                if (x instanceof DATE) {
                    this.setDATEInternal(paramIndex, (DATE)x);
                    break;
                }
                if (x instanceof Date) {
                    this.setDateInternal(paramIndex, (Date)x);
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setTimestampInternal(paramIndex, (Timestamp)x);
                    break;
                }
                if (x instanceof String) {
                    this.setDateInternal(paramIndex, Date.valueOf((String)x));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 92: {
                if (x instanceof Time) {
                    this.setTimeInternal(paramIndex, (Time)x);
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setTimeInternal(paramIndex, new Time(((Timestamp)x).getTime()));
                    break;
                }
                if (x instanceof Date) {
                    this.setTimeInternal(paramIndex, new Time(((Date)x).getTime()));
                    break;
                }
                if (x instanceof String) {
                    this.setTimeInternal(paramIndex, Time.valueOf((String)x));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 93: {
                if (x instanceof TIMESTAMP) {
                    this.setTIMESTAMPInternal(paramIndex, (TIMESTAMP)x);
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setTimestampInternal(paramIndex, (Timestamp)x);
                    break;
                }
                if (x instanceof Date) {
                    this.setDateInternal(paramIndex, (Date)x);
                    break;
                }
                if (x instanceof DATE) {
                    this.setDATEInternal(paramIndex, (DATE)x);
                    break;
                }
                if (x instanceof String) {
                    this.setTimestampInternal(paramIndex, Timestamp.valueOf((String)x));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case -100: {
                this.setTIMESTAMPInternal(paramIndex, (TIMESTAMP)x);
                break;
            }
            case -101: {
                this.setTIMESTAMPTZInternal(paramIndex, (TIMESTAMPTZ)x);
                break;
            }
            case -102: {
                this.setTIMESTAMPLTZInternal(paramIndex, (TIMESTAMPLTZ)x);
                break;
            }
            case -103: {
                this.setINTERVALYMInternal(paramIndex, (INTERVALYM)x);
                break;
            }
            case -104: {
                this.setINTERVALDSInternal(paramIndex, (INTERVALDS)x);
                break;
            }
            case -8: {
                this.setROWIDInternal(paramIndex, (ROWID)x);
                break;
            }
            case 100: {
                this.setBinaryFloatInternal(paramIndex, (BINARY_FLOAT)x);
                break;
            }
            case 101: {
                this.setBinaryDoubleInternal(paramIndex, (BINARY_DOUBLE)x);
                break;
            }
            case 2004: {
                this.setBLOBInternal(paramIndex, (BLOB)x);
                break;
            }
            case 2005: {
                this.setCLOBInternal(paramIndex, (CLOB)x);
                break;
            }
            case -13: {
                this.setBFILEInternal(paramIndex, (BFILE)x);
                break;
            }
            case 2002: 
            case 2008: {
                this.setSTRUCTInternal(paramIndex, STRUCT.toSTRUCT(x, this.connection));
                break;
            }
            case 2003: {
                this.setARRAYInternal(paramIndex, ARRAY.toARRAY(x, this.connection));
                break;
            }
            case 2007: {
                this.setOPAQUEInternal(paramIndex, (OPAQUE)x);
                break;
            }
            case 2006: {
                this.setREFInternal(paramIndex, (REF)x);
                break;
            }
            default: {
                DatabaseError.throwSqlException(4);
            }
        }
    }

    public void setObjectAtName(String paramName, Object x, int targetSqlType, int scale) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setObject(" + paramName + ", " + x + ", " + targetSqlType + ", " + scale + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setObjectInternal(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public void setObject(int paramIndex, Object x, int targetSqlType) throws SQLException {
        this.setObjectInternal(paramIndex, x, targetSqlType, 0);
    }

    void setObjectInternal(int paramIndex, Object x, int targetSqlType) throws SQLException {
        this.setObjectInternal(paramIndex, x, targetSqlType, 0);
    }

    public void setObjectAtName(String paramName, Object x, int targetSqlType) throws SQLException {
        this.setObjectAtName(paramName, x, targetSqlType, 0);
    }

    public void setRefType(int paramIndex, REF ref) throws SQLException {
        this.setREFInternal(paramIndex, ref);
    }

    void setRefTypeInternal(int paramIndex, REF ref) throws SQLException {
        this.setREFInternal(paramIndex, ref);
    }

    public void setRefTypeAtName(String paramName, REF x) throws SQLException {
        this.setREFAtName(paramName, x);
    }

    public void setRef(int paramIndex, Ref ref) throws SQLException {
        this.setREFInternal(paramIndex, (REF)ref);
    }

    void setRefInternal(int paramIndex, Ref ref) throws SQLException {
        this.setREFInternal(paramIndex, (REF)ref);
    }

    public void setRefAtName(String paramName, Ref x) throws SQLException {
        this.setREFAtName(paramName, (REF)x);
    }

    public void setREF(int paramIndex, REF ref) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setREF(paramIndex=" + paramIndex + ", ref)", this);
            OracleLog.recursiveTrace = false;
        }
        this.setREFInternal(paramIndex, ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setREFInternal(int paramIndex, REF ref) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (ref == null) {
            DatabaseError.throwSqlException(68);
        } else {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OraclePreparedStatement oraclePreparedStatement = this;
                synchronized (oraclePreparedStatement) {
                    this.setREFCritical(index, ref);
                    this.currentRowCharLens[index] = 0;
                }
            }
        }
    }

    void setREFCritical(int index, REF ref) throws SQLException {
        StructDescriptor desc = ref.getDescriptor();
        if (desc == null) {
            DatabaseError.throwSqlException(52);
        }
        this.currentRowBinders[index] = this.theRefTypeBinder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        this.parameterDatum[this.currentRank][index] = ref.getBytes();
        OracleTypeADT otype = desc.getOracleTypeADT();
        otype.getTOID();
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][index] = otype;
    }

    public void setREFAtName(String paramName, REF x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setREFAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setREFInternal(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public void setObject(int paramIndex, Object x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setObject(paramIndex=" + paramIndex + ", object)", this);
            OracleLog.recursiveTrace = false;
        }
        this.setObjectInternal(paramIndex, x);
    }

    void setObjectInternal(int paramIndex, Object x) throws SQLException {
        if (x instanceof ORAData) {
            this.setORADataInternal(paramIndex, (ORAData)x);
        } else if (x instanceof CustomDatum) {
            this.setCustomDatumInternal(paramIndex, (CustomDatum)x);
        } else {
            int sqlType = this.sqlTypeForObject(x);
            this.setObjectInternal(paramIndex, x, sqlType, 0);
        }
    }

    public void setObjectAtName(String paramName, Object x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setObjectAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setObjectInternal(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public void setOracleObject(int paramIndex, Datum x) throws SQLException {
        this.setObjectInternal(paramIndex, x);
    }

    void setOracleObjectInternal(int paramIndex, Datum x) throws SQLException {
        this.setObjectInternal(paramIndex, x);
    }

    public void setOracleObjectAtName(String paramName, Datum x) throws SQLException {
        this.setObjectAtName(paramName, x);
    }

    public synchronized void setPlsqlIndexTable(int paramIndex, Object arrayData, int maxLen, int curLen, int elemSqlType, int elemMaxLen) throws SQLException {
        this.setPlsqlIndexTableInternal(paramIndex, arrayData, maxLen, curLen, elemSqlType, elemMaxLen);
    }

    void setPlsqlIndexTableInternal(int paramIndex, Object arrayData, int maxLen, int curLen, int elemSqlType, int elemMaxLen) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        int elem_internal_type = this.getInternalType(elemSqlType);
        Object[] darray = null;
        switch (elem_internal_type) {
            case 1: 
            case 96: {
                String[] l_darray = null;
                int datalen = 0;
                if (arrayData instanceof CHAR[]) {
                    CHAR[] data = (CHAR[])arrayData;
                    datalen = data.length;
                    l_darray = new String[datalen];
                    for (int i = 0; i < datalen; ++i) {
                        CHAR elem = data[i];
                        if (elem == null) continue;
                        l_darray[i] = elem.getString();
                    }
                } else if (arrayData instanceof String[]) {
                    l_darray = (String[])arrayData;
                    datalen = l_darray.length;
                }
                if (elemMaxLen == 0 && l_darray != null) {
                    for (int i = 0; i < datalen; ++i) {
                        String elem = l_darray[i];
                        if (elem == null || elemMaxLen >= elem.length()) continue;
                        elemMaxLen = elem.length();
                    }
                }
                darray = l_darray;
                break;
            }
            case 2: 
            case 6: {
                darray = OracleTypeNUMBER.toNUMBERArray(arrayData, this.connection, 1L, curLen);
                if (elemMaxLen == 0 && darray != null) {
                    elemMaxLen = 22;
                }
                this.currentRowCharLens[index] = 0;
                break;
            }
            default: {
                DatabaseError.throwSqlException(97);
                return;
            }
        }
        this.currentRowBinders[index] = this.thePlsqlIbtBinder;
        if (this.parameterPlsqlIbt == null) {
            this.parameterPlsqlIbt = new PlsqlIbtBindInfo[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterPlsqlIbt[this.currentRank][index] = new PlsqlIbtBindInfo(darray, maxLen, curLen, elem_internal_type, elemMaxLen);
        this.hasIbtBind = true;
    }

    public synchronized void setPlsqlIndexTableAtName(String paramName, Object arrayData, int maxLen, int curLen, int elemSqlType, int elemMaxLen) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setPlsqlIndexTableAtName(" + paramName + ", " + arrayData + ", " + maxLen + ", " + curLen + ", " + elemSqlType + ", " + elemMaxLen + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setPlsqlIndexTableInternal(i + 1, arrayData, maxLen, curLen, elemSqlType, elemMaxLen);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    void endOfResultSet(boolean dont_call_prepare_for_new_result) throws SQLException {
        if (!dont_call_prepare_for_new_result) {
            this.prepareForNewResults(false, false);
        }
    }

    int sqlTypeForObject(Object x) {
        if (x == null) {
            return 0;
        }
        if (!(x instanceof Datum)) {
            if (x instanceof String) {
                return this.fixedString ? 999 : 12;
            }
            if (x instanceof BigDecimal) {
                return 2;
            }
            if (x instanceof Boolean) {
                return -7;
            }
            if (x instanceof Integer) {
                return 4;
            }
            if (x instanceof Long) {
                return -5;
            }
            if (x instanceof Float) {
                return 6;
            }
            if (x instanceof Double) {
                return 8;
            }
            if (x instanceof byte[]) {
                return -3;
            }
            if (x instanceof Short) {
                return 5;
            }
            if (x instanceof Byte) {
                return -6;
            }
            if (x instanceof Date) {
                return 91;
            }
            if (x instanceof Time) {
                return 92;
            }
            if (x instanceof Timestamp) {
                return 93;
            }
            if (x instanceof SQLData) {
                return 2002;
            }
            if (x instanceof ObjectData) {
                return 2002;
            }
        } else {
            if (x instanceof BINARY_FLOAT) {
                return 100;
            }
            if (x instanceof BINARY_DOUBLE) {
                return 101;
            }
            if (x instanceof BLOB) {
                return 2004;
            }
            if (x instanceof CLOB) {
                return 2005;
            }
            if (x instanceof BFILE) {
                return -13;
            }
            if (x instanceof ROWID) {
                return -8;
            }
            if (x instanceof NUMBER) {
                return 2;
            }
            if (x instanceof DATE) {
                return 91;
            }
            if (x instanceof TIMESTAMP) {
                return 93;
            }
            if (x instanceof TIMESTAMPTZ) {
                return -101;
            }
            if (x instanceof TIMESTAMPLTZ) {
                return -102;
            }
            if (x instanceof REF) {
                return 2006;
            }
            if (x instanceof CHAR) {
                return 1;
            }
            if (x instanceof RAW) {
                return -2;
            }
            if (x instanceof ARRAY) {
                return 2003;
            }
            if (x instanceof STRUCT) {
                return 2002;
            }
            if (x instanceof OPAQUE) {
                return 2007;
            }
            if (x instanceof INTERVALYM) {
                return -103;
            }
            if (x instanceof INTERVALDS) {
                return -104;
            }
        }
        return 1111;
    }

    public synchronized void clearParameters() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.clearParameters()", this);
            OracleLog.recursiveTrace = false;
        }
        this.clearParameters = true;
        for (int i = 0; i < this.numberOfBindPositions; ++i) {
            this.currentRowBinders[i] = null;
        }
    }

    void printByteArray(byte[] b) {
        if (b == null) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.driverLogger.log(Level.FINEST, "<Null byte array!>", this);
                OracleLog.recursiveTrace = false;
            }
        } else {
            int n = b.length;
            for (int i = 0; i < n; ++i) {
                int v = b[i] & 0xFF;
                if (v < 16) {
                    if (!TRACE || OracleLog.recursiveTrace) continue;
                    OracleLog.recursiveTrace = true;
                    OracleLog.driverLogger.log(Level.FINEST, "0" + Integer.toHexString(v) + " ", this);
                    OracleLog.recursiveTrace = false;
                    continue;
                }
                if (!TRACE || OracleLog.recursiveTrace) continue;
                OracleLog.recursiveTrace = true;
                OracleLog.driverLogger.log(Level.FINEST, Integer.toHexString(v) + " ", this);
                OracleLog.recursiveTrace = false;
            }
        }
    }

    public void setCharacterStream(int paramIndex, Reader reader, int length) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setCharacterStream(paramIndex=" + paramIndex + ", reader, length=" + length + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setCharacterStreamInternal(paramIndex, reader, length);
    }

    void setCharacterStreamInternal(int paramIndex, Reader reader, int length) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.set_execute_batch(1);
        if (reader == null) {
            this.basicBindNullString(paramIndex);
        } else if (this.userRsetType != 1 && length > this.maxVcsCharsSql) {
            DatabaseError.throwSqlException(169);
        } else if (this.currentRowFormOfUse[index] == 1) {
            if (this.sqlKind == 1 || this.sqlKind == 4) {
                if (length > this.maxVcsBytesPlsql || length > this.maxVcsCharsPlsql & this.isServerCharSetFixedWidth) {
                    this.setReaderContentsForClobCritical(paramIndex, reader, length);
                } else if (length <= this.maxVcsCharsPlsql) {
                    this.setReaderContentsForStringInternal(paramIndex, reader, length);
                } else {
                    this.setReaderContentsForStringOrClobInVariableWidthCase(paramIndex, reader, length, false);
                }
            } else if (length <= this.maxVcsCharsSql) {
                this.setReaderContentsForStringInternal(paramIndex, reader, length);
            } else {
                this.basicBindCharacterStream(paramIndex, reader, length);
            }
        } else if (this.sqlKind == 1 || this.sqlKind == 4) {
            if (length > this.maxVcsBytesPlsql || length > this.maxVcsNCharsPlsql & this.isServerCharSetFixedWidth) {
                this.setReaderContentsForClobCritical(paramIndex, reader, length);
            } else if (length <= this.maxVcsNCharsPlsql) {
                this.setReaderContentsForStringInternal(paramIndex, reader, length);
            } else {
                this.setReaderContentsForStringOrClobInVariableWidthCase(paramIndex, reader, length, true);
            }
        } else if (length <= this.maxVcsCharsSql) {
            this.setReaderContentsForStringInternal(paramIndex, reader, length);
        } else {
            this.setReaderContentsForClobCritical(paramIndex, reader, length);
        }
    }

    void basicBindCharacterStream(int paramIndex, Reader reader, int length) throws SQLException {
        int index = paramIndex - 1;
        this.currentRowBinders[index] = this.theLongStreamBinder;
        if (this.parameterStream == null) {
            this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterStream[this.currentRank][index] = this.connection.conversion.ConvertStream(reader, 7, length, this.currentRowFormOfUse[index]);
        this.currentRowCharLens[index] = 0;
    }

    void setReaderContentsForStringOrClobInVariableWidthCase(int paramIndex, Reader reader, int length, boolean isNChar) throws SQLException {
        int bytes_length;
        char[] charbuf = new char[length];
        int chars_length = 0;
        try {
            chars_length = reader.read(charbuf, 0, length);
            if (chars_length == -1) {
                chars_length = 0;
            }
        }
        catch (IOException e) {
            DatabaseError.throwSqlException(e);
        }
        if (chars_length != length) {
            char[] newbuf = new char[chars_length];
            System.arraycopy(charbuf, 0, newbuf, 0, chars_length);
            charbuf = newbuf;
        }
        if ((bytes_length = this.connection.conversion.encodedByteLength(charbuf, isNChar)) < this.maxVcsBytesPlsql) {
            this.setStringInternal(paramIndex, new String(charbuf));
        } else {
            this.setStringForClobCritical(paramIndex, new String(charbuf));
        }
    }

    void setReaderContentsForStringInternal(int paramIndex, Reader reader, int length) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.setReaderContentsForStringInternal(paramIndex=" + paramIndex + ", reader, length=" + length + ")", this);
            OracleLog.recursiveTrace = false;
        }
        char[] charbuf = new char[length];
        int actual_length = 0;
        try {
            actual_length = reader.read(charbuf, 0, length);
            if (actual_length == -1) {
                actual_length = 0;
            }
        }
        catch (IOException e) {
            DatabaseError.throwSqlException(e);
        }
        if (actual_length != length) {
            char[] newbuf = new char[actual_length];
            System.arraycopy(charbuf, 0, newbuf, 0, actual_length);
            charbuf = newbuf;
        }
        this.setStringInternal(paramIndex, new String(charbuf));
    }

    public void setDate(int paramIndex, Date x, Calendar cal) throws SQLException {
        this.setDATEInternal(paramIndex, x == null ? null : new DATE(x, cal));
    }

    void setDateInternal(int paramIndex, Date x, Calendar cal) throws SQLException {
        this.setDATEInternal(paramIndex, x == null ? null : new DATE(x, cal));
    }

    public void setTime(int paramIndex, Time x, Calendar cal) throws SQLException {
        this.setDATEInternal(paramIndex, x == null ? null : new DATE(x, cal));
    }

    void setTimeInternal(int paramIndex, Time x, Calendar cal) throws SQLException {
        this.setDATEInternal(paramIndex, x == null ? null : new DATE(x, cal));
    }

    public void setTimestamp(int paramIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestampInternal(paramIndex, x, cal);
    }

    void setTimestampInternal(int paramIndex, Timestamp x, Calendar cal) throws SQLException {
        if (this.connection.v8Compatible) {
            if (x == null) {
                this.setDATEInternal(paramIndex, null);
            } else {
                DATE d = new DATE(x, cal);
                this.setDATEInternal(paramIndex, d);
            }
            return;
        }
        if (x == null) {
            this.setTIMESTAMPInternal(paramIndex, null);
        } else {
            int nanos = x.getNanos();
            byte[] result = nanos == 0 ? new byte[7] : new byte[11];
            if (cal == null) {
                cal = Calendar.getInstance();
            }
            cal.clear();
            cal.setTime(x);
            int year = cal.get(1);
            if (cal.get(0) == 0) {
                year = -(year - 1);
            }
            result[0] = (byte)(year / 100 + 100);
            result[1] = (byte)(year % 100 + 100);
            result[2] = (byte)(cal.get(2) + 1);
            result[3] = (byte)cal.get(5);
            result[4] = (byte)(cal.get(11) + 1);
            result[5] = (byte)(cal.get(12) + 1);
            result[6] = (byte)(cal.get(13) + 1);
            if (nanos != 0) {
                result[7] = (byte)(nanos >> 24);
                result[8] = (byte)(nanos >> 16 & 0xFF);
                result[9] = (byte)(nanos >> 8 & 0xFF);
                result[10] = (byte)(nanos & 0xFF);
            }
            this.setTIMESTAMPInternal(paramIndex, new TIMESTAMP(result));
        }
    }

    public void setCheckBindTypes(boolean flag) {
        this.checkBindTypes = flag;
    }

    final void setOracleBatchStyle() throws SQLException {
        if (this.m_batchStyle == 2) {
            DatabaseError.throwSqlException(90, "operation cannot be mixed with JDBC-2.0-style batching");
        } else if (this.m_batchStyle == 0 && TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINER, "First detected Oracle-style batching", this);
            OracleLog.recursiveTrace = false;
        }
        this.m_batchStyle = 1;
    }

    final void setJdbcBatchStyle() throws SQLException {
        if (this.m_batchStyle == 1) {
            DatabaseError.throwSqlException(90, "operation cannot be mixed with Oracle-style batching");
        }
        this.m_batchStyle = 2;
    }

    final void checkIfJdbcBatchExists() throws SQLException {
        if (this.doesJdbcBatchExist()) {
            DatabaseError.throwSqlException(81, "batch must be either executed or cleared");
        }
    }

    boolean doesJdbcBatchExist() {
        return this.currentRank > 0 && this.m_batchStyle == 2;
    }

    boolean isJdbcBatchStyle() {
        return this.m_batchStyle == 2;
    }

    public synchronized void addBatch() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.addBatch()", this);
            OracleLog.recursiveTrace = false;
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            if (this.m_batchStyle == 0) {
                OracleLog.driverLogger.log(Level.FINER, "First detected Jdbc-style batching", this);
            }
            OracleLog.recursiveTrace = false;
        }
        this.setJdbcBatchStyle();
        this.processCompletedBindRow(this.currentRank + 2, this.currentRank > 0 && (this.sqlKind == 1 || this.sqlKind == 4));
        ++this.currentRank;
    }

    public synchronized void addBatch(String sql) throws SQLException {
        DatabaseError.throwSqlException(23);
    }

    public synchronized void clearBatch() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.clearBatch()", this);
            OracleLog.recursiveTrace = false;
        }
        for (int r = this.currentRank; r >= 0; --r) {
            for (int i = 0; i < this.numberOfBindPositions; ++i) {
                this.binders[r][i] = null;
            }
        }
        this.currentRank = 0;
        if (this.binders != null) {
            this.currentRowBinders = this.binders[0];
        }
        this.pushedBatches = null;
        this.pushedBatchesTail = null;
        this.firstRowInBatch = 0;
        this.clearParameters = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                int i = 0;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.executeBatch()", this);
                    OracleLog.recursiveTrace = false;
                }
                this.setJdbcBatchStyle();
                int[] ret_array = new int[this.currentRank];
                if (this.currentRank > 0) {
                    block27: {
                        this.ensureOpen();
                        this.prepareForNewResults(true, true);
                        if (this.sqlKind == 0) {
                            DatabaseError.throwBatchUpdateException(80, 0, null);
                        }
                        this.noMoreUpdateCounts = false;
                        int save_valid_rows = 0;
                        try {
                            Object var10_10;
                            try {
                                this.connection.needLine();
                                if (!this.isOpen) {
                                    this.connection.open(this);
                                    this.isOpen = true;
                                }
                                int saved_current_rank = this.currentRank;
                                if (this.pushedBatches == null) {
                                    this.setupBindBuffers(0, this.currentRank);
                                    this.executeForRows(false);
                                } else {
                                    if (this.currentRank > this.firstRowInBatch) {
                                        this.pushBatch(true);
                                    }
                                    boolean saved_need_to_parse = this.needToParse;
                                    do {
                                        PushedBatch pb = this.pushedBatches;
                                        this.currentBatchCharLens = pb.currentBatchCharLens;
                                        this.lastBoundCharLens = pb.lastBoundCharLens;
                                        this.lastBoundNeeded = pb.lastBoundNeeded;
                                        this.currentBatchBindAccessors = pb.currentBatchBindAccessors;
                                        this.needToParse = pb.need_to_parse;
                                        this.currentBatchNeedToPrepareBinds = pb.current_batch_need_to_prepare_binds;
                                        this.firstRowInBatch = pb.first_row_in_batch;
                                        this.setupBindBuffers(pb.first_row_in_batch, pb.number_of_rows_to_be_bound);
                                        this.currentRank = pb.number_of_rows_to_be_bound;
                                        this.executeForRows(false);
                                        if (this.sqlKind == 1 || this.sqlKind == 4) {
                                            save_valid_rows += this.validRows;
                                            ret_array[i++] = this.validRows;
                                        }
                                        this.pushedBatches = pb.next;
                                    } while (this.pushedBatches != null);
                                    this.pushedBatchesTail = null;
                                    this.firstRowInBatch = 0;
                                    this.needToParse = saved_need_to_parse;
                                }
                                this.slideDownCurrentRow(saved_current_rank);
                            }
                            catch (SQLException e) {
                                this.clearBatch();
                                this.needToParse = true;
                                if (this.sqlKind != 1 && this.sqlKind != 4) {
                                    for (i = 0; i < ret_array.length; ++i) {
                                        ret_array[i] = -3;
                                    }
                                }
                                DatabaseError.throwBatchUpdateException(e, this.sqlKind == 1 || this.sqlKind == 4 ? i : ret_array.length, ret_array);
                                var10_10 = null;
                                if (this.sqlKind == 1 || this.sqlKind == 4) {
                                    this.validRows = save_valid_rows;
                                }
                                this.checkValidRowsStatus();
                                this.currentRank = 0;
                                this.cleanOldTempLobs();
                                break block27;
                            }
                            var10_10 = null;
                            if (this.sqlKind == 1 || this.sqlKind == 4) {
                                this.validRows = save_valid_rows;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var10_11 = null;
                            if (this.sqlKind == 1 || this.sqlKind == 4) {
                                this.validRows = save_valid_rows;
                            }
                            this.checkValidRowsStatus();
                            this.currentRank = 0;
                            this.cleanOldTempLobs();
                            throw throwable;
                        }
                        this.checkValidRowsStatus();
                        this.currentRank = 0;
                        this.cleanOldTempLobs();
                    }
                    if (this.validRows < 0) {
                        for (i = 0; i < ret_array.length; ++i) {
                            ret_array[i] = -3;
                        }
                        DatabaseError.throwBatchUpdateException(81, 0, ret_array);
                    } else if (this.sqlKind != 1 && this.sqlKind != 4) {
                        for (i = 0; i < ret_array.length; ++i) {
                            ret_array[i] = -2;
                        }
                    }
                }
                return ret_array;
            }
        }
    }

    void pushBatch(boolean fromExecuteBatch) {
        PushedBatch pb = new PushedBatch();
        pb.currentBatchCharLens = new int[this.numberOfBindPositions];
        System.arraycopy(this.currentBatchCharLens, 0, pb.currentBatchCharLens, 0, this.numberOfBindPositions);
        pb.lastBoundCharLens = new int[this.numberOfBindPositions];
        System.arraycopy(this.lastBoundCharLens, 0, pb.lastBoundCharLens, 0, this.numberOfBindPositions);
        if (this.currentBatchBindAccessors != null) {
            pb.currentBatchBindAccessors = new Accessor[this.numberOfBindPositions];
            System.arraycopy(this.currentBatchBindAccessors, 0, pb.currentBatchBindAccessors, 0, this.numberOfBindPositions);
        }
        pb.lastBoundNeeded = this.lastBoundNeeded;
        pb.need_to_parse = this.needToParse;
        pb.current_batch_need_to_prepare_binds = this.currentBatchNeedToPrepareBinds;
        pb.first_row_in_batch = this.firstRowInBatch;
        pb.number_of_rows_to_be_bound = this.currentRank - this.firstRowInBatch;
        if (this.pushedBatches == null) {
            this.pushedBatches = pb;
        } else {
            this.pushedBatchesTail.next = pb;
        }
        this.pushedBatchesTail = pb;
        if (!fromExecuteBatch) {
            int[] tmp = this.currentBatchCharLens;
            this.currentBatchCharLens = this.lastBoundCharLens;
            this.lastBoundCharLens = tmp;
            this.lastBoundNeeded = false;
            for (int i = 0; i < this.numberOfBindPositions; ++i) {
                this.currentBatchCharLens[i] = 0;
            }
            this.firstRowInBatch = this.currentRank;
        }
    }

    int doScrollPstmtExecuteUpdate() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.doScrollPstmtExecuteUpdate()", this);
            OracleLog.recursiveTrace = false;
        }
        this.doScrollExecuteCommon();
        if (this.sqlKind == 0) {
            this.scrollRsetTypeSolved = true;
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.doScrollPstmtExecuteUpdate():returnvalidRows = " + this.validRows, this);
            OracleLog.recursiveTrace = false;
        }
        return this.validRows;
    }

    public int copyBinds(Statement toStmt, int offset) throws SQLException {
        if (this.numberOfBindPositions > 0) {
            OraclePreparedStatement to = (OraclePreparedStatement)toStmt;
            Binder[] binds = this.binders[0];
            int metadata_offset = this.bindIndicatorSubRange + 3;
            int byteoffset = this.bindByteSubRange;
            int charoffset = this.bindCharSubRange;
            int indoffset = this.indicatorsOffset;
            int lenoffset = this.valueLengthsOffset;
            for (int i = 0; i < this.numberOfBindPositions; ++i) {
                short type = this.bindIndicators[metadata_offset + 0];
                short bytePitch = this.bindIndicators[metadata_offset + 1];
                int charPitch = this.bindIndicators[metadata_offset + 2];
                int toPos = i + offset;
                if (this.bindIndicators[indoffset] == -1) {
                    to.currentRowBinders[toPos] = this.copiedNullBinder(type, bytePitch);
                    if (charPitch > 0) {
                        to.currentRowCharLens[toPos] = 1;
                    }
                } else if (type == 109 || type == 111) {
                    to.currentRowBinders[toPos] = type == 109 ? this.theNamedTypeBinder : this.theRefTypeBinder;
                    byte[] from = this.parameterDatum[0][i];
                    int len = from.length;
                    byte[] tob = new byte[len];
                    to.parameterDatum[0][toPos] = tob;
                    System.arraycopy(from, 0, tob, 0, len);
                    to.parameterOtype[0][toPos] = this.parameterOtype[0][i];
                } else if (bytePitch > 0) {
                    to.currentRowBinders[toPos] = this.copiedByteBinder(type, this.bindBytes, byteoffset, bytePitch, this.bindIndicators[lenoffset]);
                } else if (charPitch > 0) {
                    to.currentRowBinders[toPos] = this.copiedCharBinder(type, this.bindChars, charoffset, charPitch, this.bindIndicators[lenoffset]);
                    to.currentRowCharLens[toPos] = charPitch;
                } else {
                    throw new Error("copyBinds doesn't understand type " + type);
                }
                byteoffset += this.bindBufferCapacity * bytePitch;
                charoffset += this.bindBufferCapacity * charPitch;
                indoffset += this.numberOfBindRowsAllocated;
                lenoffset += this.numberOfBindRowsAllocated;
                metadata_offset += 10;
            }
        }
        return this.numberOfBindPositions;
    }

    Binder copiedNullBinder(short type, int bytelen) throws SQLException {
        return new CopiedNullBinder(type, bytelen);
    }

    Binder copiedByteBinder(short type, byte[] bytes, int offset, int pitch, short len) throws SQLException {
        byte[] b = new byte[pitch];
        System.arraycopy(bytes, offset, b, 0, pitch);
        return new CopiedByteBinder(type, pitch, b, len);
    }

    Binder copiedCharBinder(short type, char[] chars, int offset, int pitch, short len) throws SQLException {
        char[] c = new char[pitch];
        System.arraycopy(chars, offset, c, 0, pitch);
        return new CopiedCharBinder(type, c, len);
    }

    protected void hardClose() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.hardClose()", this);
            OracleLog.recursiveTrace = false;
        }
        super.hardClose();
        this.bindBytes = null;
        this.bindChars = null;
        this.bindIndicators = null;
        if (!this.connection.isClosed()) {
            this.cleanAllTempLobs();
        }
        this.lastBoundBytes = null;
        this.lastBoundChars = null;
        this.clearParameters();
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.hardClose : return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    protected void alwaysOnClose() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.alwaysOnClose()", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.currentRank > 0) {
            if (this.m_batchStyle == 2) {
                this.clearBatch();
            } else {
                this.sendBatch();
            }
        }
        super.alwaysOnClose();
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OraclePreparedStatement.alwaysOnClose : return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    public synchronized void setDisableStmtCaching(boolean cache) {
        if (cache) {
            this.cacheState = 3;
        }
    }

    public synchronized void setFormOfUse(int paramIndex, short formOfUse) {
        int i;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setFormOfUse(paramIndex=" + paramIndex + ", formOfUse=" + formOfUse + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.currentRowFormOfUse[i = paramIndex - 1] != formOfUse) {
            Accessor accessor;
            this.currentRowFormOfUse[i] = formOfUse;
            if (this.currentRowBindAccessors != null && (accessor = this.currentRowBindAccessors[i]) != null) {
                accessor.setFormOfUse(formOfUse);
            }
            if (this.returnParamAccessors != null && (accessor = this.returnParamAccessors[i]) != null) {
                accessor.setFormOfUse(formOfUse);
            }
        }
    }

    public synchronized void setURL(int paramIndex, URL x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setURL(paramIndex=" + paramIndex + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.setURLInternal(paramIndex, x);
    }

    void setURLInternal(int paramIndex, URL x) throws SQLException {
        this.setStringInternal(paramIndex, x.toString());
    }

    public void setURLAtName(String paramName, URL x) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.setURLAtName(paramName=" + paramName + ", x=" + x + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setURL(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            DatabaseError.throwSqlException(147, paramName);
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new oracle.jdbc.driver.OracleParameterMetaData(this.sqlObject.getParameterCount());
    }

    public OracleParameterMetaData OracleGetParameterMetaData() throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public void registerReturnParameter(int paramIndex, int externalType) throws SQLException {
        int index;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.registerReturnParameter(paramIndex=" + paramIndex + ", externalType =" + externalType + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.numberOfBindPositions <= 0) {
            DatabaseError.throwSqlException(90);
        }
        if (this.numReturnParams <= 0) {
            this.numReturnParams = OraclePreparedStatement.getReturnParameterCount(this.sqlObject.getOriginalSql());
            if (this.numReturnParams <= 0) {
                DatabaseError.throwSqlException(90);
            }
        }
        if ((index = paramIndex - 1) < this.numberOfBindPositions - this.numReturnParams || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        int internalType = this.getInternalTypeForDmlReturning(externalType);
        short form = 0;
        if (this.currentRowFormOfUse != null && this.currentRowFormOfUse[index] != 0) {
            form = this.currentRowFormOfUse[index];
        }
        this.registerReturnParameterInternal(index, internalType, externalType, -1, form, null);
        this.currentRowBinders[index] = this.theReturnParamBinder;
    }

    public void registerReturnParameter(int paramIndex, int externalType, int maxSize) throws SQLException {
        int index;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.registerReturnParameter(paramIndex=" + paramIndex + ", externalType=" + externalType + ", maxSize=" + maxSize + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.numberOfBindPositions <= 0) {
            DatabaseError.throwSqlException(90);
        }
        if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (externalType != 1 && externalType != 12 && externalType != -1 && externalType != -2 && externalType != -3 && externalType != -4 && externalType != 12) {
            DatabaseError.throwSqlException(68);
        }
        if (maxSize <= 0) {
            DatabaseError.throwSqlException(68);
        }
        int internalType = this.getInternalTypeForDmlReturning(externalType);
        short form = 0;
        if (this.currentRowFormOfUse != null && this.currentRowFormOfUse[index] != 0) {
            form = this.currentRowFormOfUse[index];
        }
        this.registerReturnParameterInternal(index, internalType, externalType, maxSize, form, null);
        this.currentRowBinders[index] = this.theReturnParamBinder;
    }

    public void registerReturnParameter(int paramIndex, int externalType, String typeName) throws SQLException {
        int internalType;
        int index;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.registerReturnParameter(paramIndex=" + paramIndex + ", externalType=" + externalType + ", typeName=" + typeName + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.numberOfBindPositions <= 0) {
            DatabaseError.throwSqlException(90);
        }
        if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if ((internalType = this.getInternalTypeForDmlReturning(externalType)) != 111 && internalType != 109) {
            DatabaseError.throwSqlException(68);
        }
        this.registerReturnParameterInternal(index, internalType, externalType, -1, (short)0, typeName);
        this.currentRowBinders[index] = this.theReturnParamBinder;
    }

    public ResultSet getReturnResultSet() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OraclePreparedStatement.getReturnResultSet()", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.returnParamAccessors == null || this.numReturnParams == 0) {
            DatabaseError.throwSqlException(144);
        }
        if (this.returnResultSet == null) {
            this.returnResultSet = new OracleReturnResultSet(this);
        }
        return this.returnResultSet;
    }

    int getInternalTypeForDmlReturning(int externalType) throws SQLException {
        int result = 0;
        switch (externalType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                result = 6;
                break;
            }
            case 100: {
                result = 100;
                break;
            }
            case 101: {
                result = 101;
                break;
            }
            case 1: {
                result = 96;
                break;
            }
            case 12: {
                result = 1;
                break;
            }
            case -1: {
                result = 8;
                break;
            }
            case 91: 
            case 92: {
                result = 12;
                break;
            }
            case 93: {
                result = 180;
                break;
            }
            case -101: {
                result = 181;
                break;
            }
            case -102: {
                result = 231;
                break;
            }
            case -103: {
                result = 182;
                break;
            }
            case -104: {
                result = 183;
                break;
            }
            case -3: 
            case -2: {
                result = 23;
                break;
            }
            case -4: {
                result = 24;
                break;
            }
            case -8: {
                result = 104;
                break;
            }
            case 2004: {
                result = 113;
                break;
            }
            case 2005: {
                result = 112;
                break;
            }
            case -13: {
                result = 114;
                break;
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                result = 109;
                break;
            }
            case 2006: {
                result = 111;
                break;
            }
            case 70: {
                result = 1;
                break;
            }
            default: {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleLog.driverLogger.log(Level.FINER, "OraclePreparedStatement.getInternalTypeForDmlReturning(" + externalType + ") error", this);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(4);
            }
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINER, "OraclePreparedStatement.getInternalTypeForDmlReturning(" + externalType + ") return " + result, this);
            OracleLog.recursiveTrace = false;
        }
        return result;
    }

    static int getReturnParameterCount(String sql) {
        int returnParameterCount = -1;
        String s = sql.toUpperCase();
        int pos = s.indexOf("RETURNING");
        if (pos >= 0) {
            char[] clauseOfReturning = new char[s.length() - pos];
            s.getChars(pos, s.length(), clauseOfReturning, 0);
            returnParameterCount = 0;
            for (int i = 0; i < clauseOfReturning.length; ++i) {
                if (clauseOfReturning[i] != '?') continue;
                ++returnParameterCount;
            }
        }
        return returnParameterCount;
    }

    void registerReturnParamsForAutoKey() throws SQLException {
        int[] returnTypes = this.autoKeyInfo.returnTypes;
        short[] formOfUses = this.autoKeyInfo.tableFormOfUses;
        int[] columnIndexes = this.autoKeyInfo.columnIndexes;
        int numberOfReturnParams = returnTypes.length;
        int startPos = this.numberOfBindPositions - numberOfReturnParams;
        for (int i = 0; i < numberOfReturnParams; ++i) {
            int index = startPos + i;
            this.currentRowBinders[index] = this.theReturnParamBinder;
            short form = 0;
            if (formOfUses != null && columnIndexes != null && formOfUses[columnIndexes[i] - 1] == 2) {
                form = 2;
                this.setFormOfUse(index + 1, form);
            }
            this.checkTypeForAutoKey(returnTypes[i]);
            String typeName = null;
            if (returnTypes[i] == 111) {
                typeName = this.autoKeyInfo.tableTypeNames[columnIndexes[i] - 1];
            }
            this.registerReturnParameterInternal(index, returnTypes[i], returnTypes[i], -1, form, typeName);
        }
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OraclePreparedStatement"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class PushedBatch {
        int[] currentBatchCharLens;
        int[] lastBoundCharLens;
        Accessor[] currentBatchBindAccessors;
        boolean lastBoundNeeded;
        boolean need_to_parse;
        boolean current_batch_need_to_prepare_binds;
        int first_row_in_batch;
        int number_of_rows_to_be_bound;
        PushedBatch next;

        PushedBatch() {
        }
    }
}

