/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleStatement;

class ResultSetAccessor
extends Accessor {
    static final int maxLength = 16;

    ResultSetAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        this.init(stmt, 102, 116, form, forBind);
        this.initForDataAccess(external_type, max_len, null);
    }

    ResultSetAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form) throws SQLException {
        this.init(stmt, 102, 116, form, false);
        this.initForDescribe(102, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
        this.initForDataAccess(0, max_len, null);
    }

    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        if (external_type != 0) {
            this.externalType = external_type;
        }
        this.internalTypeMaxLength = 16;
        if (max_len > 0 && max_len < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = max_len;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    ResultSet getCursor(int currentRow) throws SQLException {
        byte[] bytes = this.getBytes(currentRow);
        OracleStatement newstmt = this.statement.connection.RefCursorBytesToStatement(bytes, this.statement);
        newstmt.doDescribe(false);
        newstmt.prepareAccessors();
        OracleResultSetImpl rset = new OracleResultSetImpl(newstmt.connection, newstmt);
        rset.close_statement_on_close = true;
        newstmt.currentResultSet = rset;
        return rset;
    }

    Object getObject(int currentRow) throws SQLException {
        return this.getCursor(currentRow);
    }
}

