/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CTypeRep;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;

class T4CMAREngine {
    static final int TTCC_MXL = 252;
    static final int TTCC_ESC = 253;
    static final int TTCC_LNG = 254;
    static final int TTCC_ERR = 255;
    static final int TTCC_MXIN = 64;
    static final byte TTCLXMULTI = 1;
    static final byte TTCLXMCONV = 2;
    T4CTypeRep types;
    Communication net;
    DBConversion conv;
    short versionNumber = (short)-1;
    byte proSvrVer;
    InputStream inStream;
    OutputStream outStream;
    final byte[] ignored = new byte[255];
    final byte[] tmpBuffer1 = new byte[1];
    final byte[] tmpBuffer2 = new byte[2];
    final byte[] tmpBuffer3 = new byte[3];
    final byte[] tmpBuffer4 = new byte[4];
    final byte[] tmpBuffer5 = new byte[5];
    final byte[] tmpBuffer6 = new byte[6];
    final byte[] tmpBuffer7 = new byte[7];
    final byte[] tmpBuffer8 = new byte[8];
    final int[] retLen = new int[1];
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:30:54_PDT_2005";

    /*
     * WARNING - void declaration
     */
    static String toHex(long value, int bytes) {
        void var3_2;
        switch (bytes) {
            case 1: {
                String result = "00" + Long.toString(value & 0xFFL, 16);
                break;
            }
            case 2: {
                String result = "0000" + Long.toString(value & 0xFFFFL, 16);
                break;
            }
            case 3: {
                String result = "000000" + Long.toString(value & 0xFFFFFFL, 16);
                break;
            }
            case 4: {
                String result = "00000000" + Long.toString(value & 0xFFFFFFFFL, 16);
                break;
            }
            case 5: {
                String result = "0000000000" + Long.toString(value & 0xFFFFFFFFFFL, 16);
                break;
            }
            case 6: {
                String result = "000000000000" + Long.toString(value & 0xFFFFFFFFFFFFL, 16);
                break;
            }
            case 7: {
                String result = "00000000000000" + Long.toString(value & 0xFFFFFFFFFFFFFFL, 16);
                break;
            }
            case 8: {
                return T4CMAREngine.toHex(value >> 32, 4) + T4CMAREngine.toHex(value, 4).substring(2);
            }
            default: {
                return "more than 8 bytes";
            }
        }
        return "0x" + var3_2.substring(var3_2.length() - 2 * bytes);
    }

    static String toHex(byte value) {
        String result = "00" + Integer.toHexString(value & 0xFF);
        return "0x" + result.substring(result.length() - 2);
    }

    static String toHex(short value) {
        return T4CMAREngine.toHex(value, 2);
    }

    static String toHex(int value) {
        return T4CMAREngine.toHex(value, 4);
    }

    static String toHex(byte[] value, int length) {
        if (value == null) {
            return "null";
        }
        if (length > value.length) {
            return "byte array not long enough";
        }
        String result = "[";
        int len = Math.min(64, length);
        for (int i = 0; i < len; ++i) {
            result = result + T4CMAREngine.toHex(value[i]) + " ";
        }
        if (len < length) {
            result = result + "...";
        }
        return result + "]";
    }

    static String toHex(byte[] value) {
        if (value == null) {
            return "null";
        }
        return T4CMAREngine.toHex(value, value.length);
    }

    T4CMAREngine(Communication net) throws SQLException, IOException {
        if (net == null) {
            DatabaseError.throwSqlException(433);
        }
        this.net = net;
        try {
            this.inStream = net.getInputStream();
            this.outStream = net.getOutputStream();
        }
        catch (NetException ne) {
            throw new IOException(ne.getMessage());
        }
        this.types = new T4CTypeRep();
        this.types.setRep((byte)1, (byte)2);
    }

    void initBuffers() {
    }

    void marshalSB1(byte value) throws IOException {
        this.outStream.write(value);
    }

    void marshalUB1(short value) throws IOException {
        this.outStream.write((byte)(value & 0xFF));
    }

    void marshalSB2(short value) throws IOException {
        byte bytes = this.value2Buffer(value, this.tmpBuffer2, (byte)1);
        if (bytes != 0) {
            this.outStream.write(this.tmpBuffer2, 0, bytes);
        }
    }

    void marshalUB2(int value) throws IOException {
        this.marshalSB2((short)(value & 0xFFFF));
    }

    void marshalSB4(int value) throws IOException {
        byte bytes = this.value2Buffer(value, this.tmpBuffer4, (byte)2);
        if (bytes != 0) {
            this.outStream.write(this.tmpBuffer4, 0, bytes);
        }
    }

    void marshalUB4(long value) throws IOException {
        this.marshalSB4((int)(value & 0xFFFFFFFFFFFFFFFFL));
    }

    void marshalSB8(long value) throws IOException {
        byte bytes = this.value2Buffer(value, this.tmpBuffer8, (byte)3);
        if (bytes != 0) {
            this.outStream.write(this.tmpBuffer8, 0, bytes);
        }
    }

    void marshalSWORD(int value) throws IOException {
        this.marshalSB4(value);
    }

    void marshalUWORD(long value) throws IOException {
        this.marshalSB4((int)(value & 0xFFFFFFFFFFFFFFFFL));
    }

    void marshalB1Array(byte[] value) throws IOException {
        if (value.length > 0) {
            this.outStream.write(value);
        }
    }

    void marshalB1Array(byte[] value, int off, int len) throws IOException {
        if (value.length > 0) {
            this.outStream.write(value, off, len);
        }
    }

    void marshalUB4Array(long[] value) throws IOException {
        for (int i = 0; i < value.length; ++i) {
            this.marshalSB4((int)(value[i] & 0xFFFFFFFFFFFFFFFFL));
        }
    }

    void marshalO2U(boolean notnull) throws IOException {
        if (notnull) {
            this.addPtr((byte)1);
        } else {
            this.addPtr((byte)0);
        }
    }

    void marshalNULLPTR() throws IOException {
        this.addPtr((byte)0);
    }

    void marshalPTR() throws IOException {
        this.addPtr((byte)1);
    }

    void marshalCHR(byte[] value) throws IOException {
        this.marshalCHR(value, 0, value.length);
    }

    void marshalCHR(byte[] value, int offset, int length) throws IOException {
        if (length > 0) {
            if (this.types.isConvNeeded()) {
                this.marshalCLR(value, offset, length);
            } else {
                this.outStream.write(value, offset, length);
            }
        }
    }

    void marshalCLR(byte[] value, int valueLen) throws IOException {
        this.marshalCLR(value, 0, valueLen);
    }

    void marshalCLR(byte[] value, int offset, int valueLen) throws IOException {
        if (valueLen > 64) {
            int len;
            int nbBytesWritten = 0;
            this.outStream.write(-2);
            do {
                int bytesLeft;
                len = (bytesLeft = valueLen - nbBytesWritten) > 64 ? 64 : bytesLeft;
                this.outStream.write((byte)(len & 0xFF));
                this.outStream.write(value, offset + nbBytesWritten, len);
            } while ((nbBytesWritten += len) < valueLen);
            this.outStream.write(0);
        } else {
            this.outStream.write((byte)(valueLen & 0xFF));
            if (value.length != 0) {
                this.outStream.write(value, offset, valueLen);
            }
        }
    }

    void marshalKEYVAL(byte[][] keys, int[] keysSize, byte[][] values, int[] valuesSize, byte[] kvalflg, int nb) throws SQLException, IOException {
        for (int i = 0; i < nb; ++i) {
            if (keys[i] != null && keysSize[i] > 0) {
                this.marshalUB4(keysSize[i]);
                this.marshalCLR(keys[i], 0, keysSize[i]);
            } else {
                this.marshalUB4(0L);
            }
            if (values[i] != null && valuesSize[i] > 0) {
                this.marshalUB4(valuesSize[i]);
                this.marshalCLR(values[i], 0, valuesSize[i]);
            } else {
                this.marshalUB4(0L);
            }
            if (kvalflg[i] != 0) {
                this.marshalUB4(1L);
                continue;
            }
            this.marshalUB4(0L);
        }
    }

    void marshalKEYVAL(byte[][] keys, byte[][] values, byte[] kvalflg, int nb) throws SQLException, IOException {
        int[] keysSize = new int[nb];
        int[] valuesSize = new int[nb];
        for (int i = 0; i < nb; ++i) {
            if (keys[i] != null) {
                keysSize[i] = keys[i].length;
            }
            if (values[i] == null) continue;
            valuesSize[i] = values[i].length;
        }
        this.marshalKEYVAL(keys, keysSize, values, valuesSize, kvalflg, nb);
    }

    void marshalDALC(byte[] buffer) throws SQLException, IOException {
        if (buffer == null || buffer.length < 1) {
            this.outStream.write(0);
        } else {
            this.marshalSB4(0xFFFFFFFF & buffer.length);
            this.marshalCLR(buffer, buffer.length);
        }
    }

    void addPtr(byte value) throws IOException {
        if ((this.types.rep[4] & 1) > 0) {
            this.outStream.write(value);
        } else {
            byte bytes = this.value2Buffer(value, this.tmpBuffer4, (byte)4);
            if (bytes != 0) {
                this.outStream.write(this.tmpBuffer4, 0, bytes);
            }
        }
    }

    byte value2Buffer(int value, byte[] outBuffer, byte repOffset) throws IOException {
        boolean zeros = true;
        byte bytes = 0;
        for (int i = outBuffer.length - 1; i >= 0; --i) {
            outBuffer[bytes] = (byte)(value >>> 8 * i & 0xFF);
            if ((this.types.rep[repOffset] & 1) > 0) {
                if (zeros && outBuffer[bytes] == 0) continue;
                zeros = false;
                bytes = (byte)(bytes + 1);
                continue;
            }
            bytes = (byte)(bytes + 1);
        }
        if ((this.types.rep[repOffset] & 1) > 0) {
            this.outStream.write(bytes);
        }
        if ((this.types.rep[repOffset] & 2) > 0) {
            this.reverseArray(outBuffer, bytes);
        }
        return bytes;
    }

    byte value2Buffer(long value, byte[] outBuffer, byte repOffset) throws IOException {
        boolean zeros = true;
        byte bytes = 0;
        for (int i = outBuffer.length - 1; i >= 0; --i) {
            outBuffer[bytes] = (byte)(value >>> 8 * i & 0xFFL);
            if ((this.types.rep[repOffset] & 1) > 0) {
                if (zeros && outBuffer[bytes] == 0) continue;
                zeros = false;
                bytes = (byte)(bytes + 1);
                continue;
            }
            bytes = (byte)(bytes + 1);
        }
        if ((this.types.rep[repOffset] & 1) > 0) {
            this.outStream.write(bytes);
        }
        if ((this.types.rep[repOffset] & 2) > 0) {
            this.reverseArray(outBuffer, bytes);
        }
        return bytes;
    }

    void reverseArray(byte[] buffer, byte bytes) {
        for (int i = 0; i < bytes / 2; ++i) {
            byte tmp = buffer[i];
            buffer[i] = buffer[bytes - 1 - i];
            buffer[bytes - 1 - i] = tmp;
        }
    }

    byte unmarshalSB1() throws SQLException, IOException {
        byte result = (byte)this.unmarshalUB1();
        return result;
    }

    short unmarshalUB1() throws SQLException, IOException {
        short value = 0;
        try {
            value = (short)this.inStream.read();
        }
        catch (BreakNetException e) {
            this.net.sendReset();
            throw e;
        }
        if (value < 0) {
            DatabaseError.throwSqlException(410);
        }
        return value;
    }

    short unmarshalSB2() throws SQLException, IOException {
        short result = (short)this.unmarshalUB2();
        return result;
    }

    int unmarshalUB2() throws SQLException, IOException {
        int value = (int)this.buffer2Value((byte)1);
        return value & 0xFFFF;
    }

    int unmarshalUCS2(byte[] ucs2Char, long offset) throws SQLException, IOException {
        int value = this.unmarshalUB2();
        this.tmpBuffer2[0] = (byte)((value & 0xFF00) >> 8);
        this.tmpBuffer2[1] = (byte)(value & 0xFF);
        if (offset + 1L < (long)ucs2Char.length) {
            ucs2Char[(int)offset] = this.tmpBuffer2[0];
            ucs2Char[(int)offset + 1] = this.tmpBuffer2[1];
        }
        return this.tmpBuffer2[0] == 0 ? (this.tmpBuffer2[1] == 0 ? 1 : 2) : 3;
    }

    int unmarshalSB4() throws SQLException, IOException {
        int result = (int)this.unmarshalUB4();
        return result;
    }

    long unmarshalUB4() throws SQLException, IOException {
        long value = this.buffer2Value((byte)2);
        return value;
    }

    int unmarshalSB4(byte[] buffer) throws SQLException, IOException {
        long value = this.buffer2Value((byte)2, new ByteArrayInputStream(buffer));
        return (int)value;
    }

    long unmarshalSB8() throws SQLException, IOException {
        long value = this.buffer2Value((byte)3);
        return value;
    }

    int unmarshalRefCursor(byte[] buffer) throws SQLException, IOException {
        int result = this.unmarshalSB4(buffer);
        return result;
    }

    int unmarshalSWORD() throws SQLException, IOException {
        int result = (int)this.unmarshalUB4();
        return result;
    }

    long unmarshalUWORD() throws SQLException, IOException {
        long result = this.unmarshalUB4();
        return result;
    }

    byte[] unmarshalNBytes(int n) throws SQLException, IOException {
        byte[] tmpBuffer = new byte[n];
        try {
            if (this.inStream.read(tmpBuffer) < 0) {
                DatabaseError.throwSqlException(410);
            }
        }
        catch (BreakNetException e) {
            this.net.sendReset();
            throw e;
        }
        return tmpBuffer;
    }

    int unmarshalNBytes(byte[] buf, int off, int n) throws SQLException, IOException {
        int bytes;
        for (bytes = 0; bytes < n; bytes += this.getNBytes(buf, off + bytes, n - bytes)) {
        }
        return bytes;
    }

    int getNBytes(byte[] buf, int off, int len) throws SQLException, IOException {
        int cnt = 0;
        try {
            cnt = this.inStream.read(buf, off, len);
            if (cnt < 0) {
                DatabaseError.throwSqlException(410);
            }
        }
        catch (BreakNetException e) {
            this.net.sendReset();
            throw e;
        }
        return cnt;
    }

    byte[] getNBytes(int n) throws SQLException, IOException {
        byte[] tmpBuffer = new byte[n];
        try {
            if (this.inStream.read(tmpBuffer) < 0) {
                DatabaseError.throwSqlException(410);
            }
        }
        catch (BreakNetException e) {
            this.net.sendReset();
            throw e;
        }
        return tmpBuffer;
    }

    byte[] unmarshalTEXT(int bytes) throws SQLException, IOException {
        byte[] buffer;
        int offset = 0;
        byte[] tmpBuffer = new byte[bytes];
        while (offset < bytes) {
            try {
                if (this.inStream.read(tmpBuffer, offset, 1) < 0) {
                    DatabaseError.throwSqlException(410);
                }
            }
            catch (BreakNetException e) {
                this.net.sendReset();
                throw e;
            }
            if (tmpBuffer[offset++] != 0) continue;
        }
        if (tmpBuffer.length == --offset) {
            buffer = tmpBuffer;
        } else {
            buffer = new byte[offset];
            System.arraycopy(tmpBuffer, 0, buffer, 0, offset);
        }
        return buffer;
    }

    byte[] unmarshalCHR(int retLength) throws SQLException, IOException {
        byte[] resBuffer = null;
        if (this.types.isConvNeeded()) {
            resBuffer = this.unmarshalCLR(retLength, this.retLen);
            if (resBuffer.length != this.retLen[0]) {
                byte[] tmpBuf = new byte[this.retLen[0]];
                System.arraycopy(resBuffer, 0, tmpBuf, 0, this.retLen[0]);
                resBuffer = tmpBuf;
            }
        } else {
            resBuffer = this.getNBytes(retLength);
        }
        return resBuffer;
    }

    void unmarshalCLR(byte[] bytes, int offsetRow, int[] intArray) throws SQLException, IOException {
        this.unmarshalCLR(bytes, offsetRow, intArray, Integer.MAX_VALUE);
    }

    void unmarshalCLR(byte[] bytes, int offsetRow, int[] intArray, int maxSize) throws SQLException, IOException {
        short len = 0;
        int offset = offsetRow;
        boolean optimized = false;
        int nbBytesWritten = 0;
        int keepThem = 0;
        int lastread = -1;
        len = this.unmarshalUB1();
        if (len < 0) {
            DatabaseError.throwSqlException(401);
        }
        if (len == 0) {
            intArray[0] = 0;
            return;
        }
        if (this.escapeSequenceNull(len)) {
            intArray[0] = 0;
            return;
        }
        if (len != 254) {
            keepThem = Math.min(maxSize - nbBytesWritten, len);
            offset = this.unmarshalBuffer(bytes, offset, keepThem);
            nbBytesWritten += keepThem;
            int rest = len - keepThem;
            if (rest > 0) {
                this.unmarshalBuffer(this.ignored, 0, rest);
            }
        } else {
            lastread = -1;
            block5: while (lastread == -1 || (len = this.unmarshalUB1()) > 0) {
                if (len == 254) {
                    switch (lastread) {
                        case -1: {
                            lastread = 1;
                            continue block5;
                        }
                        case 1: {
                            lastread = 0;
                            break;
                        }
                        case 0: {
                            if (optimized) {
                                lastread = 0;
                                break;
                            }
                            lastread = 0;
                            continue block5;
                        }
                    }
                }
                if (offset == -1) {
                    this.unmarshalBuffer(this.ignored, 0, len);
                } else {
                    keepThem = Math.min(maxSize - nbBytesWritten, len);
                    offset = this.unmarshalBuffer(bytes, offset, keepThem);
                    nbBytesWritten += keepThem;
                    int rest = len - keepThem;
                    if (rest > 0) {
                        this.unmarshalBuffer(this.ignored, 0, rest);
                    }
                }
                lastread = 0;
                if (len <= 252) continue;
                optimized = true;
            }
        }
        if (intArray != null) {
            intArray[0] = offset != -1 ? nbBytesWritten : bytes.length - offsetRow;
        }
    }

    byte[] unmarshalCLR(int buflen, int[] intArray) throws SQLException, IOException {
        byte[] tmpBuf = new byte[buflen * this.conv.c2sNlsRatio];
        this.unmarshalCLR(tmpBuf, 0, intArray, buflen);
        return tmpBuf;
    }

    int unmarshalKEYVAL(byte[][] keys, byte[][] values, int nb) throws SQLException, IOException {
        byte[] buff = new byte[1000];
        int[] length = new int[1];
        int kvalflg = 0;
        for (int i = 0; i < nb; ++i) {
            int len = this.unmarshalSB4();
            if (len > 0) {
                this.unmarshalCLR(buff, 0, length);
                keys[i] = new byte[length[0]];
                System.arraycopy(buff, 0, keys[i], 0, length[0]);
            }
            if ((len = this.unmarshalSB4()) > 0) {
                this.unmarshalCLR(buff, 0, length);
                values[i] = new byte[length[0]];
                System.arraycopy(buff, 0, values[i], 0, length[0]);
            }
            kvalflg = this.unmarshalSB4();
        }
        buff = null;
        return kvalflg;
    }

    int unmarshalBuffer(byte[] _byteValue, int offset, int len) throws SQLException, IOException {
        if (len <= 0) {
            return offset;
        }
        if (_byteValue.length < offset + len) {
            this.unmarshalNBytes(_byteValue, offset, _byteValue.length - offset);
            this.unmarshalNBytes(this.ignored, 0, offset + len - _byteValue.length);
            offset = -1;
        } else {
            this.unmarshalNBytes(_byteValue, offset, len);
            offset += len;
        }
        return offset;
    }

    byte[] unmarshalCLRforREFS() throws SQLException, IOException {
        short len = 0;
        short totalLen = 0;
        byte[] finalBuffer = null;
        Vector<byte[]> refVector = new Vector<byte[]>(10, 10);
        short bytes = this.unmarshalUB1();
        if (bytes < 0) {
            DatabaseError.throwSqlException(401);
        }
        if (bytes == 0) {
            return null;
        }
        if (!this.escapeSequenceNull(bytes)) {
            byte[] tmpBuf;
            if (bytes == 254) {
                while ((len = this.unmarshalUB1()) > 0) {
                    if (len == 254 && this.types.isServerConversion()) continue;
                    totalLen = (short)(totalLen + len);
                    tmpBuf = new byte[len];
                    this.unmarshalBuffer(tmpBuf, 0, len);
                    refVector.addElement(tmpBuf);
                }
            } else {
                totalLen = bytes;
                tmpBuf = new byte[bytes];
                this.unmarshalBuffer(tmpBuf, 0, bytes);
                refVector.addElement(tmpBuf);
            }
            finalBuffer = new byte[totalLen];
            int start = 0;
            while (refVector.size() > 0) {
                int arrayLen = ((byte[])refVector.elementAt(0)).length;
                System.arraycopy(refVector.elementAt(0), 0, finalBuffer, start, arrayLen);
                start += arrayLen;
                refVector.removeElementAt(0);
            }
        } else {
            finalBuffer = null;
        }
        return finalBuffer;
    }

    boolean escapeSequenceNull(int bytes) throws SQLException {
        boolean is_null = false;
        switch (bytes) {
            case 0: {
                is_null = true;
                break;
            }
            case 253: {
                DatabaseError.throwSqlException(401);
            }
            case 255: {
                is_null = true;
                break;
            }
            case 254: {
                break;
            }
        }
        return is_null;
    }

    int processIndicator(boolean isNull, int dataSize) throws SQLException, IOException {
        short ind = this.unmarshalSB2();
        int res = 0;
        if (!isNull) {
            res = ind == 0 ? dataSize : (ind == -2 || ind > 0 ? (int)ind : 65536 + ind);
        }
        return res;
    }

    long unmarshalDALC(byte[] buffer, int offset, int[] returnLength) throws SQLException, IOException {
        long len = this.unmarshalUB4();
        if (len > 0L) {
            this.unmarshalCLR(buffer, offset, returnLength);
        }
        return len;
    }

    byte[] unmarshalDALC() throws SQLException, IOException {
        long len = this.unmarshalUB4();
        byte[] buffer = new byte[(int)(0xFFFFFFFFFFFFFFFFL & len)];
        if (buffer.length > 0) {
            if ((buffer = this.unmarshalCLR(buffer.length, this.retLen)) == null) {
                DatabaseError.throwSqlException(401);
            }
        } else {
            buffer = new byte[]{};
        }
        return buffer;
    }

    byte[] unmarshalDALC(int[] CLRRetLen) throws SQLException, IOException {
        long len = this.unmarshalUB4();
        byte[] buffer = new byte[(int)(0xFFFFFFFFFFFFFFFFL & len)];
        if (buffer.length > 0) {
            if ((buffer = this.unmarshalCLR(buffer.length, CLRRetLen)) == null) {
                DatabaseError.throwSqlException(401);
            }
        } else {
            buffer = new byte[]{};
        }
        return buffer;
    }

    long buffer2Value(byte repOffset) throws SQLException, IOException {
        byte[] tmpBuffer;
        int bufLength = 0;
        long value = 0L;
        boolean negative = false;
        if ((this.types.rep[repOffset] & 1) > 0) {
            try {
                bufLength = this.inStream.read();
            }
            catch (BreakNetException e) {
                this.net.sendReset();
                throw e;
            }
            if ((bufLength & 0x80) > 0) {
                bufLength &= 0x7F;
                negative = true;
            }
            if (bufLength < 0) {
                DatabaseError.throwSqlException(410);
            }
            if (bufLength == 0) {
                return 0L;
            }
            if (repOffset == 1 && bufLength > 2 || repOffset == 2 && bufLength > 4 || repOffset == 3 && bufLength > 8) {
                DatabaseError.throwSqlException(412);
            }
        } else if (repOffset == 1) {
            bufLength = 2;
        } else if (repOffset == 2) {
            bufLength = 4;
        } else if (repOffset == 3) {
            bufLength = 8;
        }
        switch (bufLength) {
            case 1: {
                tmpBuffer = this.tmpBuffer1;
                break;
            }
            case 2: {
                tmpBuffer = this.tmpBuffer2;
                break;
            }
            case 3: {
                tmpBuffer = this.tmpBuffer3;
                break;
            }
            case 4: {
                tmpBuffer = this.tmpBuffer4;
                break;
            }
            case 5: {
                tmpBuffer = this.tmpBuffer5;
                break;
            }
            case 6: {
                tmpBuffer = this.tmpBuffer6;
                break;
            }
            case 7: {
                tmpBuffer = this.tmpBuffer7;
                break;
            }
            case 8: {
                tmpBuffer = this.tmpBuffer8;
                break;
            }
            default: {
                tmpBuffer = new byte[bufLength];
            }
        }
        try {
            if (this.inStream.read(tmpBuffer) < 0) {
                DatabaseError.throwSqlException(410);
            }
        }
        catch (BreakNetException e) {
            this.net.sendReset();
            throw e;
        }
        for (int i = 0; i < tmpBuffer.length; ++i) {
            long tmpLong = (this.types.rep[repOffset] & 2) > 0 ? (long)(tmpBuffer[tmpBuffer.length - 1 - i] & 0xFF) & 0xFFL : (long)(tmpBuffer[i] & 0xFF) & 0xFFL;
            value |= tmpLong << 8 * (tmpBuffer.length - 1 - i);
        }
        if (repOffset != 3) {
            value &= 0xFFFFFFFFFFFFFFFFL;
        }
        if (negative) {
            value = -value;
        }
        return value;
    }

    long buffer2Value(byte repOffset, ByteArrayInputStream in) throws SQLException, IOException {
        byte[] tmpBuffer;
        int bufLength = 0;
        long value = 0L;
        boolean negative = false;
        if ((this.types.rep[repOffset] & 1) > 0) {
            bufLength = in.read();
            if ((bufLength & 0x80) > 0) {
                bufLength &= 0x7F;
                negative = true;
            }
            if (bufLength < 0) {
                DatabaseError.throwSqlException(410);
            }
            if (bufLength == 0) {
                return 0L;
            }
            if (repOffset == 1 && bufLength > 2 || repOffset == 2 && bufLength > 4) {
                DatabaseError.throwSqlException(412);
            }
        } else if (repOffset == 1) {
            bufLength = 2;
        } else if (repOffset == 2) {
            bufLength = 4;
        }
        if (in.read(tmpBuffer = new byte[bufLength]) < 0) {
            DatabaseError.throwSqlException(410);
        }
        for (int i = 0; i < tmpBuffer.length; ++i) {
            short tmpByte = (this.types.rep[repOffset] & 2) > 0 ? (short)(tmpBuffer[tmpBuffer.length - 1 - i] & 0xFF) : (short)(tmpBuffer[i] & 0xFF);
            value |= (long)(tmpByte << 8 * (tmpBuffer.length - 1 - i));
        }
        value &= 0xFFFFFFFFFFFFFFFFL;
        if (negative) {
            value = -value;
        }
        return value;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CMAREngine"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

