/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OracleImplicitConnectionCache;
import oracle.jdbc.pool.OraclePooledConnection;

class OracleImplicitConnectionCacheThread
extends Thread {
    private OracleImplicitConnectionCache implicitCache = null;
    protected boolean timeToLive = true;
    protected boolean isSleeping = false;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:30:56_PDT_2005";

    OracleImplicitConnectionCacheThread(OracleImplicitConnectionCache oicc) throws SQLException {
        this.implicitCache = oicc;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleImplicitConnectionCacheThread(oicc)", this);
            OracleLog.recursiveTrace = false;
        }
    }

    public void run() {
        long threadTTLTimeout = 0L;
        long threadInactivityTimeout = 0L;
        long threadAbandonedTimeout = 0L;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleImplicitConnectionCacheThread:run()", this);
            OracleLog.recursiveTrace = false;
        }
        while (this.timeToLive) {
            try {
                if (this.timeToLive && (threadTTLTimeout = (long)this.implicitCache.getCacheTimeToLiveTimeout()) > 0L) {
                    this.runTimeToLiveTimeout(threadTTLTimeout);
                }
                if (this.timeToLive && (threadInactivityTimeout = (long)this.implicitCache.getCacheInactivityTimeout()) > 0L) {
                    this.runInactivityTimeout();
                }
                if (this.timeToLive && (threadAbandonedTimeout = (long)this.implicitCache.getCacheAbandonedTimeout()) > 0L) {
                    this.runAbandonedTimeout(threadAbandonedTimeout);
                }
                if (this.timeToLive) {
                    block10: {
                        this.isSleeping = true;
                        try {
                            OracleImplicitConnectionCacheThread.sleep(this.implicitCache.getCachePropertyCheckInterval() * 1000);
                        }
                        catch (InterruptedException ie) {
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                            OracleLog.poolLogger.log(Level.FINER, "OracleImplicitConnectionCacheThread.run()" + ie, this);
                            OracleLog.recursiveTrace = false;
                        }
                    }
                    this.isSleeping = false;
                }
                if (this.implicitCache != null && (threadTTLTimeout > 0L || threadInactivityTimeout > 0L || threadAbandonedTimeout > 0L)) continue;
                this.timeToLive = false;
            }
            catch (SQLException e) {
                if (!TRACE || OracleLog.recursiveTrace) continue;
                OracleLog.recursiveTrace = true;
                OracleLog.poolLogger.log(Level.FINER, "OracleImplicitConnectionCacheThread.run()" + e, this);
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTimeToLiveTimeout(long threadTTLTimeout) throws SQLException {
        long connCurrTime = 0L;
        long connStartTime = 0L;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINER, "runTimeToLiveTimeout():timeout=<" + threadTTLTimeout + ">" + ", activeSize=<" + this.implicitCache.getNumberOfCheckedOutConnections() + ">", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.implicitCache.getNumberOfCheckedOutConnections() > 0) {
            OraclePooledConnection pc = null;
            OracleImplicitConnectionCache oracleImplicitConnectionCache = this.implicitCache;
            synchronized (oracleImplicitConnectionCache) {
                Object[] ObjArr = this.implicitCache.checkedOutConnectionList.toArray();
                int sz = this.implicitCache.checkedOutConnectionList.size();
                for (int k = 0; k < sz; ++k) {
                    pc = (OraclePooledConnection)ObjArr[k];
                    Connection conn = pc.getLogicalHandle();
                    if (conn == null) continue;
                    connStartTime = ((OracleConnection)conn).getStartTime();
                    connCurrTime = System.currentTimeMillis();
                    if (connCurrTime - connStartTime <= threadTTLTimeout * 1000L) continue;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleLog.poolLogger.log(Level.FINER, "OracleImplicitConnectionCacheThread.runTimeToLiveTimeout():TTL Timeout expired... Executing cancel()/close()", this);
                        OracleLog.recursiveTrace = false;
                    }
                    try {
                        this.implicitCache.closeCheckedOutConnection(pc, true);
                        continue;
                    }
                    catch (SQLException e) {
                        if (!TRACE || OracleLog.recursiveTrace) continue;
                        OracleLog.recursiveTrace = true;
                        OracleLog.poolLogger.log(Level.FINER, "OracleImplicitConnectionCacheThread.runTimeToLiveTimeout()" + e, this);
                        OracleLog.recursiveTrace = false;
                    }
                }
            }
        }
    }

    private void runInactivityTimeout() {
        block2: {
            try {
                this.implicitCache.doForEveryCachedConnection(4);
            }
            catch (SQLException e) {
                if (!TRACE || OracleLog.recursiveTrace) break block2;
                OracleLog.recursiveTrace = true;
                OracleLog.poolLogger.log(Level.FINER, "OracleImplicitConnectionCacheThread.runInactivityTimeout()" + e, this);
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAbandonedTimeout(long abandonedTimeout) throws SQLException {
        if (this.implicitCache.getNumberOfCheckedOutConnections() > 0) {
            OraclePooledConnection pc = null;
            OracleImplicitConnectionCache oracleImplicitConnectionCache = this.implicitCache;
            synchronized (oracleImplicitConnectionCache) {
                Object[] ObjArr = this.implicitCache.checkedOutConnectionList.toArray();
                for (int k = 0; k < ObjArr.length; ++k) {
                    pc = (OraclePooledConnection)ObjArr[k];
                    OracleConnection conn = (OracleConnection)pc.getLogicalHandle();
                    if (conn == null) continue;
                    OracleConnectionCacheCallback occc = conn.getConnectionCacheCallbackObj();
                    if (occc != null && (conn.getConnectionCacheCallbackFlag() == 4 || conn.getConnectionCacheCallbackFlag() == 1)) {
                        try {
                            occc.handleAbandonedConnection(conn, conn.getConnectionCacheCallbackPrivObj());
                        }
                        catch (SQLException e) {
                            if (!TRACE || OracleLog.recursiveTrace) continue;
                            OracleLog.recursiveTrace = true;
                            OracleLog.poolLogger.log(Level.FINER, "OracleImplicitConnectionCacheThread.runAbandonedTimeout()" + e, this);
                            OracleLog.recursiveTrace = false;
                        }
                        continue;
                    }
                    if ((long)(conn.getHeartbeatNoChangeCount() * this.implicitCache.getCachePropertyCheckInterval()) <= abandonedTimeout) continue;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleLog.poolLogger.log(Level.FINER, "OracleImplicitConnectionCacheThread.runAbandonedTimeout():Abandoned Timeout expired...Executing cancel()/close()", this);
                        OracleLog.recursiveTrace = false;
                    }
                    try {
                        this.implicitCache.closeCheckedOutConnection(pc, true);
                        continue;
                    }
                    catch (SQLException e) {
                        if (!TRACE || OracleLog.recursiveTrace) continue;
                        OracleLog.recursiveTrace = true;
                        OracleLog.poolLogger.log(Level.FINER, "OracleImplicitConnectionCacheThread.runAbandonedTimeout()" + e, this);
                        OracleLog.recursiveTrace = false;
                    }
                }
            }
        }
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleImplicitConnectionCacheThread"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

