/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.accept;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.MediaType;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;

public class FixedContentNegotiationStrategy
implements ContentNegotiationStrategy {
    private static final Log logger = LogFactory.getLog(FixedContentNegotiationStrategy.class);
    private final List<MediaType> contentType;

    public FixedContentNegotiationStrategy(MediaType contentType) {
        this.contentType = Collections.singletonList(contentType);
    }

    @Override
    public List<MediaType> resolveMediaTypes(NativeWebRequest request) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Requested media types: " + this.contentType));
        }
        return this.contentType;
    }
}

