/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class JDataSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String[] columnNames;
    private String[] columnTypeNames;
    private List<Object[]> table = new ArrayList<Object[]>();

    public JDataSet(String[] columnNames, String[] columnTypeNames) {
        this.columnNames = columnNames;
        this.columnTypeNames = columnTypeNames;
    }

    public JDataSet() {
    }

    public int getRowCount() {
        return this.table.size();
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public String[] getColumnTypeNames() {
        return this.columnTypeNames;
    }

    public void setColumnTypeNames(String[] columnTypeNames) {
        this.columnTypeNames = columnTypeNames;
    }

    public List<Object[]> getTable() {
        if (this.table == null) {
            this.table = new ArrayList<Object[]>();
        }
        return this.table;
    }

    public int getColumnCount() {
        if (this.columnNames != null) {
            return this.columnNames.length;
        }
        if (!this.table.isEmpty()) {
            return this.table.get(0).length;
        }
        return 0;
    }

    public Object[] getRow(int rowIndex) {
        this.rowRangeCheck(rowIndex);
        return this.table.get(rowIndex);
    }

    private void rowRangeCheck(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.table.size()) {
            throw new IllegalArgumentException("rowIndex overflow : " + rowIndex);
        }
    }

    private void columnRangeCheck(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnNames.length) {
            throw new IllegalArgumentException("columnIndex overflow : ????" + columnIndex);
        }
    }

    public void addRow(Object[] row) {
        this.table.add(row);
    }

    public void removeRow(int rowIndex) {
        this.table.remove(rowIndex);
    }

    public void clearRow(int rowIndex) {
        this.table.set(rowIndex, null);
    }

    public void setCell(int rowIndex, int columnIndex, String value) {
        this.rowRangeCheck(rowIndex);
        Object[] row = this.table.get(rowIndex);
        this.columnRangeCheck(columnIndex);
        row[columnIndex] = value;
    }

    public void setCell(int rowIndex, String columnName, String value) {
        int columnIndex = this.indexof(columnName.trim());
        if (columnIndex > -1) {
            this.setCell(rowIndex, columnIndex, value);
        }
    }

    public Object getCell(int rowIndex, int columnIndex) {
        this.rowRangeCheck(rowIndex);
        Object[] row = this.table.get(rowIndex);
        this.columnRangeCheck(columnIndex);
        return row[columnIndex];
    }

    public Object getCell(int rowIndex, String columnName) {
        int columnIndex = this.indexof(columnName.trim());
        if (columnIndex > -1) {
            return this.getCell(rowIndex, columnIndex);
        }
        return null;
    }

    public Object[] getColumn(int columnIndex) {
        this.columnRangeCheck(columnIndex);
        Object[] column = new Object[this.getRowCount()];
        int i = 0;
        while (i < column.length) {
            column[i] = this.table.get(i)[columnIndex];
            ++i;
        }
        return column;
    }

    public Object[] getColumn(String columnName) {
        int columnIndex = this.indexof(columnName.trim());
        if (columnIndex > -1) {
            return this.getColumn(columnIndex);
        }
        return null;
    }

    private int indexof(String columnName) {
        int i = 0;
        while (i < this.columnNames.length) {
            if (this.columnNames[i].trim().equalsIgnoreCase(columnName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

