/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.apache.commons.beanutils.MethodUtils;

public class ConstructorUtils {
    private static final Class[] EMPTY_CLASS_PARAMETERS = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static Object invokeConstructor(Class klass, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] args = new Object[]{arg};
        return ConstructorUtils.invokeConstructor(klass, args);
    }

    public static Object invokeConstructor(Class klass, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        int i = 0;
        while (i < arguments) {
            parameterTypes[i] = args[i].getClass();
            ++i;
        }
        return ConstructorUtils.invokeConstructor(klass, args, parameterTypes);
    }

    public static Object invokeConstructor(Class klass, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor ctor;
        if (parameterTypes == null) {
            parameterTypes = EMPTY_CLASS_PARAMETERS;
        }
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        if ((ctor = ConstructorUtils.getMatchingAccessibleConstructor(klass, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + klass.getName());
        }
        return ctor.newInstance(args);
    }

    public static Object invokeExactConstructor(Class klass, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] args = new Object[]{arg};
        return ConstructorUtils.invokeExactConstructor(klass, args);
    }

    public static Object invokeExactConstructor(Class klass, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        int i = 0;
        while (i < arguments) {
            parameterTypes[i] = args[i].getClass();
            ++i;
        }
        return ConstructorUtils.invokeExactConstructor(klass, args, parameterTypes);
    }

    public static Object invokeExactConstructor(Class klass, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor ctor;
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        if (parameterTypes == null) {
            parameterTypes = EMPTY_CLASS_PARAMETERS;
        }
        if ((ctor = ConstructorUtils.getAccessibleConstructor(klass, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + klass.getName());
        }
        return ctor.newInstance(args);
    }

    public static Constructor getAccessibleConstructor(Class klass, Class parameterType) {
        Class[] parameterTypes = new Class[]{parameterType};
        return ConstructorUtils.getAccessibleConstructor(klass, parameterTypes);
    }

    public static Constructor getAccessibleConstructor(Class klass, Class[] parameterTypes) {
        try {
            return ConstructorUtils.getAccessibleConstructor(klass.getConstructor(parameterTypes));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Constructor getAccessibleConstructor(Constructor ctor) {
        if (ctor == null) {
            return null;
        }
        if (!Modifier.isPublic(ctor.getModifiers())) {
            return null;
        }
        Class clazz = ctor.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return ctor;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static Constructor getMatchingAccessibleConstructor(Class clazz, Class[] parameterTypes) {
        try {
            ctor = clazz.getConstructor(parameterTypes);
            try {
                ctor.setAccessible(true);
            }
            catch (SecurityException var3_5) {
                // empty catch block
            }
            return ctor;
        }
        catch (NoSuchMethodException ctor) {
            paramSize = parameterTypes.length;
            ctors = clazz.getConstructors();
            i = 0;
            size = ctors.length;
            ** while (i < size)
        }
lbl-1000:
        // 1 sources

        {
            ctorParams = ctors[i].getParameterTypes();
            ctorParamSize = ctorParams.length;
            if (ctorParamSize == paramSize) {
                match = true;
                n = 0;
                while (n < ctorParamSize) {
                    if (!MethodUtils.isAssignmentCompatible(ctorParams[n], parameterTypes[n])) {
                        match = false;
                        break;
                    }
                    ++n;
                }
                if (match && (ctor = ConstructorUtils.getAccessibleConstructor(ctors[i])) != null) {
                    try {
                        ctor.setAccessible(true);
                    }
                    catch (SecurityException var10_14) {
                        // empty catch block
                    }
                    return ctor;
                }
            }
            ++i;
            continue;
        }
lbl35:
        // 1 sources

        return null;
    }
}

