/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import jxl.Cell;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.Parser;
import jxl.biff.formula.StringFormulaParser;
import jxl.biff.formula.TokenFormulaParser;

public class FormulaParser {
    private Parser parser;

    public FormulaParser(byte[] tokens, Cell rt, ExternalSheet es) throws FormulaException {
        if (!es.getWorkbookBof().isBiff8()) {
            throw new FormulaException(FormulaException.biff8Supported);
        }
        this.parser = new TokenFormulaParser(tokens, rt, es);
    }

    public FormulaParser(String form) {
        this.parser = new StringFormulaParser(form);
    }

    public void parse() throws FormulaException {
        this.parser.parse();
    }

    public String getFormula() throws FormulaException {
        return this.parser.getFormula();
    }

    public byte[] getBytes() {
        return this.parser.getBytes();
    }
}

