/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementReadOnly;

class BinaryFloatBinder
extends Binder {
    Binder theBinaryFloatCopyingBinder = OraclePreparedStatementReadOnly.theStaticBinaryFloatCopyingBinder;

    static void init(Binder x) {
        x.type = (short)100;
        x.bytelen = 4;
    }

    BinaryFloatBinder() {
        BinaryFloatBinder.init(this);
    }

    Binder copyingBinder() {
        return this.theBinaryFloatCopyingBinder;
    }

    void bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues) {
        int intBits;
        byte[] b = bindBytes;
        int offset = byteoffset;
        float val = stmt.parameterFloat[rank][bindPosition];
        if ((double)val == 0.0) {
            val = 0.0f;
        } else if (val != val) {
            val = Float.NaN;
        }
        int b3 = intBits = Float.floatToIntBits(val);
        int b2 = intBits >>= 8;
        int b1 = intBits >>= 8;
        int b0 = intBits >>= 8;
        if ((b0 & 0x80) == 0) {
            b0 |= 0x80;
        } else {
            b0 ^= 0xFFFFFFFF;
            b1 ^= 0xFFFFFFFF;
            b2 ^= 0xFFFFFFFF;
            b3 ^= 0xFFFFFFFF;
        }
        b[offset + 3] = (byte)b3;
        b[offset + 2] = (byte)b2;
        b[offset + 1] = (byte)b1;
        b[offset] = (byte)b0;
        bindIndicators[indoffset] = 0;
        bindIndicators[lenoffset] = 4;
    }
}

