/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import oracle.jdbc.OracleDatabaseMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleWallet;

public class OracleDriver
implements Driver {
    public static final char slash_character = '/';
    public static final char at_sign_character = '@';
    public static final char left_square_bracket_character = '[';
    public static final char right_square_bracket_character = ']';
    public static final String oracle_string = "oracle";
    public static final String protocol_string = "protocol";
    public static final String user_string = "user";
    public static final String password_string = "password";
    public static final String database_string = "database";
    public static final String server_string = "server";
    public static final String access_string = "access";
    public static final String protocolFullName_string = "protocolFullName";
    public static final String logon_as_internal_str = "internal_logon";
    public static final String proxy_client_name = "PROXY_CLIENT_NAME";
    public static final String prefetch_string = "prefetch";
    public static final String row_prefetch_string = "rowPrefetch";
    public static final String default_row_prefetch_string = "defaultRowPrefetch";
    public static final String batch_string = "batch";
    public static final String execute_batch_string = "executeBatch";
    public static final String default_execute_batch_string = "defaultExecuteBatch";
    public static final String process_escapes_string = "processEscapes";
    public static final String dms_parent_name_string = "DMSName";
    public static final String dms_parent_type_string = "DMSType";
    public static final String accumulate_batch_result = "AccumulateBatchResult";
    public static final String j2ee_compliance = "oracle.jdbc.J2EE13Compliant";
    public static final String v8compatible_string = "oracle.jdbc.V8Compatible";
    public static final String permit_timestamp_date_mismatch_string = "oracle.jdbc.internal.permitBindDateDefineTimestampMismatch";
    public static final String StreamChunkSize_string = "oracle.jdbc.StreamChunkSize";
    public static final String SetFloatAndDoubleUseBinary_string = "SetFloatAndDoubleUseBinary";
    public static final String xa_trans_loose = "oracle.jdbc.XATransLoose";
    public static final String tcp_no_delay = "oracle.jdbc.TcpNoDelay";
    public static final String read_timeout = "oracle.jdbc.ReadTimeout";
    public static final String defaultnchar_string = "oracle.jdbc.defaultNChar";
    public static final String defaultncharprop_string = "defaultNChar";
    public static final String useFetchSizeWithLongColumn_prop_string = "useFetchSizeWithLongColumn";
    public static final String useFetchSizeWithLongColumn_string = "oracle.jdbc.useFetchSizeWithLongColumn";
    public static final String remarks_string = "remarks";
    public static final String report_remarks_string = "remarksReporting";
    public static final String synonyms_string = "synonyms";
    public static final String include_synonyms_string = "includeSynonyms";
    public static final String restrict_getTables_string = "restrictGetTables";
    public static final String fixed_string_string = "fixedString";
    public static final String dll_string = "oracle.jdbc.ocinativelibrary";
    public static final String nls_lang_backdoor = "oracle.jdbc.ociNlsLangBackwardCompatible";
    public static final String disable_defineColumnType_string = "disableDefineColumnType";
    public static final String convert_nchar_literals_string = "oracle.jdbc.convertNcharLiterals";
    public static final String dataSizeUnitsPropertyName = "";
    public static final String dataSizeBytes = "";
    public static final String dataSizeChars = "";
    public static final String dms_stmt_metrics_string = "oracle.jdbc.DMSStatementMetrics";
    public static final String dms_stmt_caching_metrics_string = "oracle.jdbc.DMSStatementCachingMetrics";
    public static final String set_new_password_string = "OCINewPassword";
    public static final String retain_v9_bind_behavior_string = "oracle.jdbc.RetainV9LongBindBehavior";
    public static final String no_caching_buffers = "oracle.jdbc.FreeMemoryOnEnterImplicitCache";
    public static final String secret_store_connect = "oracle.security.client.connect_string";
    public static final String secret_store_username = "oracle.security.client.username";
    public static final String secret_store_password = "oracle.security.client.password";
    public static final String secret_store_default_username = "oracle.security.client.default_username";
    public static final String secret_store_default_password = "oracle.security.client.default_password";
    public static final String wallet_location_string = "oracle.net.wallet_location";
    private static String walletLocation = null;
    static final int EXTENSION_TYPE_ORACLE_ERROR = -3;
    static final int EXTENSION_TYPE_GEN_ERROR = -2;
    static final int EXTENSION_TYPE_TYPE4_CLIENT = 0;
    static final int EXTENSION_TYPE_TYPE4_SERVER = 1;
    static final int EXTENSION_TYPE_TYPE2_CLIENT = 2;
    static final int EXTENSION_TYPE_TYPE2_SERVER = 3;
    private static final int NUMBER_OF_EXTENSION_TYPES = 4;
    private OracleDriverExtension[] driverExtensions = new OracleDriverExtension[4];
    private static final String DRIVER_PACKAGE_STRING = "driver";
    private static final String[] driverExtensionClassNames = new String[]{"oracle.jdbc.driver.T4CDriverExtension", "oracle.jdbc.driver.T4CDriverExtension", "oracle.jdbc.driver.T2CDriverExtension", "oracle.jdbc.driver.T2SDriverExtension"};
    private static Properties driverAccess;
    protected static Connection defaultConn;
    private static OracleDriver defaultDriver;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_;
    public static boolean TRACE;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:30:51_PDT_2005";
    static /* synthetic */ Class class$oracle$jdbc$driver$OracleDriver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection connect(String url, Properties info) throws SQLException {
        String j2ee_compliance_value;
        String system_j2ee_compliance_value;
        Driver driverobj;
        String convertNcharLiterals;
        String disableDefineColumnType;
        String synonyms;
        String remarks;
        String useFetchSizeWithLongColumn;
        String defaultnchar;
        String batch;
        String prefetch;
        int login_timeout_value;
        String read_timeout_value;
        String tcp_nodelay_value;
        Hashtable url_properties;
        int extensionType;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleDriver.connect(url=" + url + ", info)", this);
            OracleLog.recursiveTrace = false;
        }
        if (url.regionMatches(0, "jdbc:default:connection", 0, 23)) {
            String url1 = "jdbc:oracle:kprb";
            int l = url.length();
            url = l > 23 ? url1.concat(url.substring(23, url.length())) : url1.concat(":");
            url1 = null;
        }
        if ((extensionType = this.oracleDriverExtensionTypeFromURL(url)) == -2) {
            return null;
        }
        if (extensionType == -3) {
            DatabaseError.throwSqlException(67);
        }
        OracleDriverExtension driverExtension = null;
        driverExtension = this.driverExtensions[extensionType];
        if (driverExtension == null) {
            try {
                OracleDriver oracleDriver = this;
                synchronized (oracleDriver) {
                    if (driverExtension == null) {
                        this.driverExtensions[extensionType] = driverExtension = (OracleDriverExtension)Class.forName(driverExtensionClassNames[extensionType]).newInstance();
                    } else {
                        driverExtension = this.driverExtensions[extensionType];
                    }
                }
            }
            catch (Exception e) {
                throw new SQLException(e.toString());
            }
        }
        if ((walletLocation = info.getProperty(wallet_location_string)) == null) {
            walletLocation = OracleDriver.getSystemProperty(wallet_location_string, null);
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINER, "OracleDriver.connect() walletLocation:(" + walletLocation + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if ((url_properties = this.parseUrl(url)) == null) {
            return null;
        }
        String user = info.getProperty(user_string);
        String password = info.getProperty(password_string);
        String database = info.getProperty(database_string);
        if (database == null) {
            database = info.getProperty(server_string);
        }
        if (user == null) {
            user = (String)url_properties.get(user_string);
        }
        user = this.parseLoginOption(user, info);
        if (password == null) {
            password = (String)url_properties.get(password_string);
        }
        if (database == null) {
            database = (String)url_properties.get(database_string);
        }
        String protocol = (String)url_properties.get(protocol_string);
        info.put(protocol_string, protocol);
        if (protocol == null) {
            DatabaseError.throwSqlException(40, "Protocol is not specified in URL");
            return null;
        }
        if (protocol.equals("oci8") || protocol.equals("oci")) {
            database = this.translateConnStr(database);
        }
        if ((tcp_nodelay_value = info.getProperty(tcp_no_delay)) == null) {
            tcp_nodelay_value = OracleDriver.getSystemProperty(tcp_no_delay, null);
        }
        if (tcp_nodelay_value != null && tcp_nodelay_value.equalsIgnoreCase("true")) {
            info.put("TCP.NODELAY", "YES");
        }
        if ((read_timeout_value = info.getProperty(read_timeout)) != null) {
            info.put("oracle.net.READ_TIMEOUT", read_timeout_value);
        }
        if ((login_timeout_value = DriverManager.getLoginTimeout()) != 0 && info.get("oracle.net.CONNECT_TIMEOUT") == null) {
            info.put("oracle.net.CONNECT_TIMEOUT", "" + login_timeout_value * 1000);
        }
        if ((prefetch = info.getProperty(prefetch_string)) == null) {
            prefetch = info.getProperty(row_prefetch_string);
        }
        if (prefetch == null) {
            prefetch = info.getProperty(default_row_prefetch_string);
        }
        if (prefetch != null && Integer.parseInt(prefetch) <= 0) {
            prefetch = null;
        }
        if ((batch = info.getProperty(batch_string)) == null) {
            batch = info.getProperty(execute_batch_string);
        }
        if (batch == null) {
            batch = info.getProperty(default_execute_batch_string);
        }
        if (batch != null && Integer.parseInt(batch) <= 0) {
            batch = null;
        }
        if ((defaultnchar = info.getProperty(defaultncharprop_string)) == null) {
            defaultnchar = OracleDriver.getSystemProperty(defaultnchar_string, null);
        }
        if ((useFetchSizeWithLongColumn = info.getProperty(useFetchSizeWithLongColumn_prop_string)) == null) {
            useFetchSizeWithLongColumn = OracleDriver.getSystemProperty(useFetchSizeWithLongColumn_string, null);
        }
        if ((remarks = info.getProperty(remarks_string)) == null) {
            remarks = info.getProperty(report_remarks_string);
        }
        if ((synonyms = info.getProperty(synonyms_string)) == null) {
            synonyms = info.getProperty(include_synonyms_string);
        }
        String restrict_getTables = info.getProperty(restrict_getTables_string);
        String fixedString = info.getProperty(fixed_string_string);
        String batching_type = info.getProperty(accumulate_batch_result);
        if (batching_type == null) {
            batching_type = "true";
        }
        if ((disableDefineColumnType = info.getProperty(disable_defineColumnType_string)) == null) {
            disableDefineColumnType = "false";
        }
        if ((convertNcharLiterals = info.getProperty(convert_nchar_literals_string)) == null) {
            convertNcharLiterals = OracleDriver.getSystemProperty(convert_nchar_literals_string, "false");
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINER, "user=" + user + ", password=" + password + ", database=" + database + ", protocol=" + protocol + ", prefetch=" + prefetch + ", batch=" + batch + ", accumulate batch result =" + batching_type + ", remarks=" + remarks + ", synonyms=" + synonyms, this);
            OracleLog.recursiveTrace = false;
        }
        Enumeration<Driver> enumdrivers = DriverManager.getDrivers();
        while (enumdrivers.hasMoreElements() && !((driverobj = enumdrivers.nextElement()) instanceof OracleDriver)) {
        }
        while (enumdrivers.hasMoreElements()) {
            driverobj = enumdrivers.nextElement();
            if (!(driverobj instanceof OracleDriver)) continue;
            DriverManager.deregisterDriver(driverobj);
        }
        PhysicalConnection conn = (PhysicalConnection)driverExtension.getConnection(url, user, password, database, info);
        if (prefetch != null) {
            conn.setDefaultRowPrefetch(Integer.parseInt(prefetch));
        }
        if (batch != null) {
            conn.setDefaultExecuteBatch(Integer.parseInt(batch));
        }
        if (remarks != null) {
            conn.setRemarksReporting(remarks.equalsIgnoreCase("true"));
        }
        if (synonyms != null) {
            conn.setIncludeSynonyms(synonyms.equalsIgnoreCase("true"));
        }
        if (restrict_getTables != null) {
            conn.setRestrictGetTables(restrict_getTables.equalsIgnoreCase("true"));
        }
        if (fixedString != null) {
            conn.setDefaultFixedString(fixedString.equalsIgnoreCase("true"));
        }
        if (defaultnchar != null) {
            conn.setDefaultNChar(defaultnchar.equalsIgnoreCase("true"));
        }
        if (useFetchSizeWithLongColumn != null) {
            conn.useFetchSizeWithLongColumn = useFetchSizeWithLongColumn.equalsIgnoreCase("true");
        }
        if (batching_type != null) {
            conn.setAccumulateBatchResult(batching_type.equalsIgnoreCase("true"));
        }
        if ((system_j2ee_compliance_value = OracleDriver.getSystemProperty(j2ee_compliance, null)) == null) {
            j2ee_compliance_value = info.getProperty(j2ee_compliance);
            if (j2ee_compliance_value == null) {
                j2ee_compliance_value = "false";
            }
        } else {
            j2ee_compliance_value = system_j2ee_compliance_value;
        }
        conn.setJ2EE13Compliant(j2ee_compliance_value.equalsIgnoreCase("true"));
        conn.disableDefineColumnType = disableDefineColumnType.equalsIgnoreCase("true");
        conn.convertNcharLiterals = convertNcharLiterals.equalsIgnoreCase("true");
        url_properties = null;
        conn.protocolId = extensionType;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleDriver.connect(url,info):return", this);
            OracleLog.recursiveTrace = false;
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection defaultConnection() throws SQLException {
        if (defaultConn == null || defaultConn.isClosed()) {
            Class clazz = class$oracle$jdbc$driver$OracleDriver == null ? (class$oracle$jdbc$driver$OracleDriver = OracleDriver.class$("oracle.jdbc.driver.OracleDriver")) : class$oracle$jdbc$driver$OracleDriver;
            synchronized (clazz) {
                if (defaultConn == null || defaultConn.isClosed()) {
                    defaultConn = DriverManager.getConnection("jdbc:oracle:kprb:");
                }
            }
        }
        return defaultConn;
    }

    private int oracleDriverExtensionTypeFromURL(String url) {
        int third_colon;
        int first_colon = url.indexOf(58) + 1;
        if (first_colon == 0) {
            return -2;
        }
        int second_colon = url.indexOf(58, first_colon);
        if (second_colon == -1) {
            return -2;
        }
        if (!url.regionMatches(true, first_colon, oracle_string, 0, second_colon - first_colon)) {
            return -2;
        }
        if ((third_colon = url.indexOf(58, ++second_colon)) == -1) {
            return -3;
        }
        String sub_name = url.substring(second_colon, third_colon);
        if (sub_name.equals("thin")) {
            return 0;
        }
        if (sub_name.equals("oci8") || sub_name.equals("oci")) {
            return 2;
        }
        return -3;
    }

    public boolean acceptsURL(String url) {
        if (url.startsWith("jdbc:oracle:")) {
            return this.oracleDriverExtensionTypeFromURL(url) > -2;
        }
        return false;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return OracleDatabaseMetaData.getDriverMajorVersionInfo();
    }

    public int getMinorVersion() {
        return OracleDatabaseMetaData.getDriverMinorVersionInfo();
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public String processSqlEscapes(String sqlString) throws SQLException {
        OracleSql sql = new OracleSql(null);
        sql.initialize(sqlString);
        return sql.parse(sqlString);
    }

    private String parseLoginOption(String user, Properties info) {
        String lowerCaseUser;
        int j = 0;
        String userOnly = null;
        String proxyClient = null;
        if (user == null) {
            return null;
        }
        int len = user.length();
        if (len == 0) {
            return null;
        }
        int i = user.indexOf(91);
        if (i > 0) {
            j = user.indexOf(93);
            proxyClient = user.substring(i + 1, j);
            if ((proxyClient = proxyClient.trim()).length() > 0) {
                info.put(proxy_client_name, proxyClient);
            }
            user = user.substring(0, i) + user.substring(j + 1, len);
        }
        if ((i = (lowerCaseUser = user.toLowerCase()).lastIndexOf(" as ")) == -1 || i < lowerCaseUser.lastIndexOf("\"")) {
            return user;
        }
        userOnly = user.substring(0, i);
        i += 4;
        while (i < len && lowerCaseUser.charAt(i) == ' ') {
            ++i;
        }
        if (i == len) {
            return user;
        }
        String loginMode = lowerCaseUser.substring(i).trim();
        if (loginMode.length() > 0) {
            info.put(logon_as_internal_str, loginMode);
        }
        return userOnly;
    }

    private Hashtable parseUrl(String url) throws SQLException {
        String alias;
        String[] tmpCreds;
        int end;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINER, "OracleDriver.parseUrl(url=" + url + ")", this);
            OracleLog.recursiveTrace = false;
        }
        Hashtable<String, String> result = new Hashtable<String, String>(5);
        int sub_sub_index = url.indexOf(58, url.indexOf(58) + 1) + 1;
        if (sub_sub_index == (end = url.length())) {
            return result;
        }
        int next_colon_index = url.indexOf(58, sub_sub_index);
        if (next_colon_index == -1) {
            return result;
        }
        result.put(protocol_string, url.substring(sub_sub_index, next_colon_index));
        int user = next_colon_index + 1;
        int slash = url.indexOf(47, user);
        int at_sign = url.indexOf(64, user);
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINER, "sub_sub_index=" + sub_sub_index + ", end=" + end + ", next_colon_index=" + next_colon_index + ", user=" + user + ", slash=" + slash + ", at_sign=" + at_sign, this);
            OracleLog.recursiveTrace = false;
        }
        if (at_sign > user && user > sub_sub_index && slash == -1) {
            return null;
        }
        if (at_sign == -1) {
            at_sign = end;
        }
        if (slash == -1) {
            slash = at_sign;
        }
        if (slash < at_sign && slash != user && at_sign != user) {
            result.put(user_string, url.substring(user, slash));
            result.put(password_string, url.substring(slash + 1, at_sign));
        }
        if (!(slash > at_sign || slash != user && at_sign != user || at_sign >= end || (tmpCreds = this.getSecretStoreCredentials(alias = url.substring(at_sign + 1)))[0] == null && tmpCreds[1] == null)) {
            result.put(user_string, tmpCreds[0]);
            result.put(password_string, tmpCreds[1]);
        }
        if (at_sign < end) {
            result.put(database_string, url.substring(at_sign + 1));
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINER, "OracleDriver.parseUrl(url):return", this);
            OracleLog.recursiveTrace = false;
        }
        return result;
    }

    private String[] getSecretStoreCredentials(String connectString) throws SQLException {
        String[] userPwd;
        block12: {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.driverLogger.log(Level.FINE, "OracleDriver.getSecretStoreCredentials(" + connectString + ")", this);
                OracleLog.recursiveTrace = false;
            }
            userPwd = new String[]{null, null};
            if (walletLocation != null) {
                try {
                    OracleWallet wallet = new OracleWallet();
                    if (!wallet.exists(walletLocation)) break block12;
                    wallet.open(walletLocation, null);
                    OracleSecretStore secretStore = wallet.getSecretStore();
                    if (secretStore.containsAlias(secret_store_default_username)) {
                        userPwd[0] = new String(secretStore.getSecret(secret_store_default_username));
                    }
                    if (secretStore.containsAlias(secret_store_default_password)) {
                        userPwd[1] = new String(secretStore.getSecret(secret_store_default_password));
                    }
                    Enumeration list = wallet.getSecretStore().internalAliases();
                    String alias = null;
                    while (list.hasMoreElements()) {
                        alias = (String)list.nextElement();
                        if (!alias.startsWith(secret_store_connect) || !connectString.equalsIgnoreCase(new String(secretStore.getSecret(alias)))) continue;
                        String idx = alias.substring(secret_store_connect.length());
                        userPwd[0] = new String(secretStore.getSecret(secret_store_username + idx));
                        userPwd[1] = new String(secretStore.getSecret(secret_store_password + idx));
                        break;
                    }
                }
                catch (NoClassDefFoundError ndef) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleLog.driverLogger.log(Level.SEVERE, "OracleDriver.getSecretStoreCredentials: oraclepki.jar not found", this);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(167);
                }
                catch (Exception s) {
                    if (s instanceof RuntimeException) {
                        throw (RuntimeException)s;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleLog.driverLogger.log(Level.SEVERE, "OracleDriver.getSecretStoreCredentials: Caught exception from wallet", this);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(168);
                }
            }
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleDriver.getSecretStoreCredentials:return:(" + userPwd[0] + ", *****)", this);
            OracleLog.recursiveTrace = false;
        }
        return userPwd;
    }

    public static String getCompileTime() {
        return BUILD_DATE;
    }

    private String translateConnStr(String database) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleDriver.translateConnStr(database =" + database + ")", this);
            OracleLog.recursiveTrace = false;
        }
        int fColon = 0;
        int sColon = 0;
        if (database == null) {
            return database;
        }
        fColon = database.indexOf(58);
        if (fColon == -1 || (sColon = database.indexOf(58, fColon + 1)) == -1) {
            return database;
        }
        if (database.indexOf(58, sColon + 1) != -1) {
            DatabaseError.throwSqlException(67, database);
        }
        String host = database.substring(0, fColon);
        String port = database.substring(fColon + 1, sColon);
        String sid = database.substring(sColon + 1, database.length());
        String translate_database = "(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=" + host + ")(PORT=" + port + "))(CONNECT_DATA=(SID=" + sid + ")))";
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "translate_database=" + translate_database, this);
            OracleLog.recursiveTrace = false;
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleDriver.translateConnStr(database):return", this);
            OracleLog.recursiveTrace = false;
        }
        return translate_database;
    }

    protected static String getSystemPropertyUserName() {
        return OracleDriver.getSystemProperty("user.name", null);
    }

    protected static String getSystemPropertyV8Compatible() {
        return OracleDriver.getSystemProperty(v8compatible_string, null);
    }

    protected static String getSystemPropertyPollInterval() {
        return OracleDriver.getSystemProperty("oracle.jdbc.TimeoutPollInterval", "1000");
    }

    public static String getSystemPropertyFastConnectionFailover(String defaultValue) {
        return OracleDriver.getSystemProperty("oracle.jdbc.FastConnectionFailover", defaultValue);
    }

    public static String getSystemPropertyJserverVersion() {
        return OracleDriver.getSystemProperty("oracle.jserver.version", null);
    }

    private static String getSystemProperty(String str) {
        return OracleDriver.getSystemProperty(str, null);
    }

    private static String getSystemProperty(String str, String defaultValue) {
        if (str != null) {
            final String fstr = str;
            final String fdefaultValue = defaultValue;
            final String[] rets = new String[]{defaultValue};
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    rets[0] = System.getProperty(fstr, fdefaultValue);
                    return null;
                }
            });
            return rets[0];
        }
        return defaultValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        defaultConn = null;
        defaultDriver = null;
        Timestamp ignore = Timestamp.valueOf("2000-01-01 00:00:00.0");
        try {
            if (defaultDriver == null) {
                defaultDriver = new OracleDriver();
                DriverManager.registerDriver(defaultDriver);
            }
        }
        catch (RuntimeException e) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleDriver"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

