/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.CharacterConverters;

class CharacterSetGB18030
extends CharacterSetWithConverter {
    static final int MAX_7BIT = 127;
    static Class m_charConvSuperclass;

    CharacterSetGB18030(int oracleId, CharacterConverters charConverter) {
        super(oracleId, charConverter);
    }

    static CharacterSetGB18030 getInstance(int oracleId, CharacterConverters charConverter) {
        if (charConverter.getGroupId() == 9) {
            return new CharacterSetGB18030(oracleId, charConverter);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int decode(CharacterWalker walker) throws SQLException {
        int c = walker.bytes[walker.next] & 0xFF;
        if (c <= 127) return c;
        if (walker.bytes.length <= walker.next + 1) throw new SQLException("destination too small");
        if ((walker.bytes[walker.next] & 0xFF) >= 129 && (walker.bytes[walker.next] & 0xFF) <= 254 && (walker.bytes[walker.next + 1] & 0xFF) >= 48 && (walker.bytes[walker.next + 1] & 0xFF) <= 57) {
            if (walker.bytes.length <= walker.next + 3) throw new SQLException("destination too small");
            if ((walker.bytes[walker.next + 2] & 0xFF) >= 129 && (walker.bytes[walker.next + 2] & 0xFF) <= 254 && (walker.bytes[walker.next + 3] & 0xFF) >= 48 && (walker.bytes[walker.next + 3] & 0xFF) <= 57) {
                c = (walker.bytes[walker.next] & 0xFF) << 24 | (walker.bytes[walker.next + 1] & 0xFF) << 16 | (walker.bytes[walker.next + 2] & 0xFF) << 8 | walker.bytes[walker.next + 3] & 0xFF;
                walker.next += 4;
                return c;
            } else {
                c = walker.bytes[walker.next] & 0xFF;
                ++walker.next;
            }
            return c;
        } else {
            c = (walker.bytes[walker.next] & 0xFF) << 8 | walker.bytes[walker.next + 1] & 0xFF;
            walker.next += 2;
        }
        return c;
    }

    void encode(CharacterBuffer buffer, int c) throws SQLException {
        int bytesToShift = 0;
        int bytesNeeded = 0;
        while (c >> bytesToShift != 0) {
            bytesToShift = (short)(bytesToShift + 8);
            bytesNeeded = (short)(bytesNeeded + 1);
        }
        if (c >> 16 != 0) {
            bytesToShift = 3;
            bytesNeeded = 4;
        } else if (c >> 8 != 0) {
            bytesToShift = 1;
            bytesNeeded = 2;
        } else {
            bytesToShift = 0;
            bytesNeeded = 1;
        }
        CharacterSetGB18030.need(buffer, bytesNeeded);
        while (bytesToShift >= 0) {
            buffer.bytes[buffer.next++] = (byte)(c >> bytesToShift & 0xFF);
            bytesToShift = (short)(bytesToShift - 8);
        }
    }
}

