package com.ylzinfo.onepay.sdk.enums;

public enum TradeMode {
	/**
	 * 收银台
	 */
	CASHIER,
	/**
	 * 收银台 (不往HIS充值)
	 */
	CASHIER_NON,
	/**
	 * 现金交易
	 */
	CASH,
	/**
	 * 银行卡交易
	 */
	POS,
	/**
	 * 现金记账
	 */
	NON_CASH,
	/**
	 * 银行刷卡记账
	 */
	NON_POS,
	/**
	 * 微信app支付
	 */
	WX_APP,
	/**
	 * 微信公众号二维码支付
	 */
	WX_QR,
	/**
	 * 微信条形码
	 */
	WX_BAR,
	/**
	 * 微信公众号支付
	 */
	WX_PUB,
	/**
	 * 支付宝app支付
	 */
	ALI_APP,
	/**
	 * 微信H5支付
	 */
	WX_WAP,
	/**
	 * 支付宝网页支付
	 */
	ALI_WEB,
	/**
	 * 支付宝wap支付
	 */
	ALI_WAP,
	/**
	 * 支付宝二维码
	 */
	ALI_QR,
	/**
	 * 支付宝扫码支付
	 */
	ALI_BAR,
	/**
	 * 银联WAP支付
	 */
	UP_WAP,
	/**
	 * 银联web支付
	 */
	UP_WEB,
	/**
	 * 健康通app支付
	 */
	JKT_APP,
	/** 医保 */
	YIBAO,
	/** 银医通 */
	YINYI_TONG,
	/** 提现到本人银行卡 */
	REFUND_BANK,
	/**
	 * 一码付
	 */
	ONE_QR,
	/**
	 * 支付平台预下单
	 */
	INIT_ORDER,
	/** e惠通记账 */
	WX_QR_NON,WX_BAR_NON,ALI_QR_NON,ALI_BAR_NON
}
