package com.ylzinfo.onepay.sdk.utils;


public class AbcUtil {

	public static final String[] CARD_16 = { "49102", "53591", "622820",
			"622830", "6353591", "6349102", "403361", "404117", "404118",
			"404119", "404120", "404121", "463758", "463759", "470607",
			"470619", "484741", "484742", "514027", "519412", "519413",
			"520082", "520083", "544243", "545206", "548478", "548598",
			"548710", "552599", "558730", "622836", "622837", "622838",
			"622839", "625996", "625997", "625998", "628268", "628269",
			"625336", "534492", "535051", "536113", "469145", "469146",
			"469147", "625170", "625171", "470606", "518802", "625653",
			"628346", "517212", "518893", "62844803" };
	public static final String[] CARD_18 = { "888001", "63" };
	public static final String[] CARD_19 = { "620059", "621282", "621619",
			"621671", "622821", "622822", "622823", "622824", "622825",
			"622826", "622827", "622828", "622843", "622844", "622845",
			"622846", "622847", "622848", "622849", "623018", "9559", "63589",
			"103", "625818", "622841", "621336", "623052", "622840" };

	/**
	 * 识别是否是农行卡
	 * 
	 * @param crCardNo
	 * @return
	 */
	public static boolean judgementCardNo(String cardNo){
		/**
		 * 判断卡度
		 */
		int length=cardNo.length();
		switch (length) {
		case 16:
			return judgementBegin(cardNo,CARD_16);
		case 19:
			return judgementBegin(cardNo,CARD_19);
		case 18:
			return judgementBegin(cardNo,CARD_18);
		default:
			return false;
		}
	}
	public static boolean judgementBegin(String card,String []cardBin){
		for (int i = 0; i < cardBin.length; i++) {
			if (card.startsWith(cardBin[i])) {
				return true;
			}
		}
		return false;
	}
	public static void main(String[] args) {
		boolean yes=AbcUtil.judgementCardNo("6228480070165669410");
		if (yes) {
			System.out.println("是农行卡");
		}else {
			System.out.println("不是农行卡");
		}
	}
}
