/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dom;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.thymeleaf.Configuration;
import org.thymeleaf.Standards;
import org.thymeleaf.dom.NestableAttributeHolderNode;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public final class Element
extends NestableAttributeHolderNode {
    private static final long serialVersionUID = -8434931215899913983L;
    private static final ConcurrentHashMap<String, ConcurrentHashMap<String, String[]>> prefixedElementNamesByPrefix = new ConcurrentHashMap(3);
    private static final ConcurrentHashMap<String, String> prefixesByElementName = new ConcurrentHashMap(100);
    private final String originalName;
    private final String normalizedName;
    private final boolean minimizableIfWeb;
    private RepresentationInTemplate representationInTemplate;

    public Element(String name) {
        this(name, null, null, null);
    }

    public Element(String name, String documentName) {
        this(name, documentName, null, null);
    }

    public Element(String name, String documentName, Integer lineNumber) {
        this(name, documentName, lineNumber, null);
    }

    public Element(String name, RepresentationInTemplate representationInTemplate) {
        this(name, null, null, representationInTemplate);
    }

    public Element(String name, String documentName, RepresentationInTemplate representationInTemplate) {
        this(name, documentName, null, representationInTemplate);
    }

    public Element(String name, String documentName, Integer lineNumber, RepresentationInTemplate representationInTemplate) {
        super(documentName, lineNumber);
        Validate.notNull(name, "Element name cannot be null");
        this.originalName = name;
        this.normalizedName = Element.normalizeElementName(name);
        this.minimizableIfWeb = Arrays.binarySearch(Standards.MINIMIZABLE_XHTML_TAGS, this.normalizedName) >= 0;
        this.representationInTemplate = representationInTemplate;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getNormalizedName() {
        return this.normalizedName;
    }

    public boolean hasNormalizedName(String dialectPrefix, String normalizedElementName) {
        String[] prefixedElementNames;
        for (String prefixedElementName : prefixedElementNames = Element.applyPrefixToElementName(normalizedElementName, dialectPrefix)) {
            if (!this.normalizedName.equals(prefixedElementName)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public String getNormalizedPrefix() {
        return Element.getPrefixFromElementName(this.normalizedName);
    }

    @Deprecated
    public String getUnprefixedNormalizedName() {
        return Element.getUnprefixedElementName(this.normalizedName);
    }

    @Deprecated
    public boolean hasPrefix() {
        int colonPos = this.normalizedName.indexOf(58);
        return colonPos != -1;
    }

    public boolean isMinimizableIfWeb() {
        return this.minimizableIfWeb;
    }

    public RepresentationInTemplate getRepresentationInTemplate() {
        return this.representationInTemplate;
    }

    public void setRepresentationInTemplate(RepresentationInTemplate representationInTemplate) {
        this.representationInTemplate = representationInTemplate;
    }

    void doAdditionalPrecomputeNestableNode(Configuration configuration) {
    }

    public Element cloneElementNodeWithNewName(NestableNode newParent, String newElementName, boolean cloneProcessors) {
        Element clonedElement = new Element(newElementName);
        this.cloneNodeInternals(clonedElement, newParent, cloneProcessors);
        return clonedElement;
    }

    Node createClonedInstance(NestableNode newParent, boolean cloneProcessors) {
        return new Element(this.originalName, this.getDocumentName(), this.getLineNumber(), this.representationInTemplate);
    }

    void doCloneNestableAttributeHolderNodeInternals(NestableNode node, NestableNode newParent, boolean cloneProcessors) {
    }

    public static String normalizeElementName(String name) {
        if (name == null) {
            return null;
        }
        return name.toLowerCase();
    }

    public static String[] applyPrefixToElementName(String name, String dialectPrefix) {
        String[] prefixedElementNames;
        if (name == null) {
            return null;
        }
        String prefix = dialectPrefix == null ? "" : dialectPrefix;
        ConcurrentHashMap<String, Object> prefixedElementNamesForPrefix = prefixedElementNamesByPrefix.get(prefix);
        if (prefixedElementNamesForPrefix == null) {
            prefixedElementNamesForPrefix = new ConcurrentHashMap(100);
            prefixedElementNamesByPrefix.put(prefix, prefixedElementNamesForPrefix);
        }
        if ((prefixedElementNames = prefixedElementNamesForPrefix.get(name)) != null) {
            return prefixedElementNames;
        }
        prefixedElementNames = StringUtils.isEmptyOrWhitespace(prefix) ? new String[]{name} : new String[]{prefix + ':' + name, prefix + '-' + name};
        prefixedElementNamesForPrefix.put(name, prefixedElementNames);
        return prefixedElementNames;
    }

    public static String getUnprefixedElementName(String elementName) {
        if (elementName == null) {
            return null;
        }
        int colonPos = elementName.indexOf(58);
        if (colonPos != -1) {
            return elementName.substring(colonPos + 1);
        }
        int dashPos = elementName.indexOf(45);
        if (dashPos != -1) {
            return elementName.substring(dashPos + 1);
        }
        return elementName;
    }

    public static String getPrefixFromElementName(String elementName) {
        if (elementName == null) {
            return null;
        }
        String prefix = prefixesByElementName.get(elementName);
        if (prefix != null) {
            if (prefix.length() == 0) {
                return null;
            }
            return prefix;
        }
        int colonPos = elementName.indexOf(58);
        if (colonPos != -1) {
            prefix = elementName.substring(0, colonPos);
        } else {
            int dashPos = elementName.indexOf(45);
            if (dashPos != -1) {
                prefix = elementName.substring(0, dashPos);
            }
        }
        if (prefix == null) {
            prefix = "";
        }
        prefixesByElementName.put(elementName, prefix);
        if (prefix.length() == 0) {
            return null;
        }
        return prefix;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RepresentationInTemplate {
        STANDALONE,
        OPEN_AND_CLOSE_NONEMPTY,
        OPEN_AND_CLOSE_EMPTY,
        ONLY_OPEN;

    }
}

