/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.io.Serializable;
import org.thymeleaf.standard.expression.AssignationSequence;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.util.StringUtils;

public final class FragmentSelection
implements Serializable {
    private static final long serialVersionUID = -5310313871594922690L;
    private final IStandardExpression templateName;
    private final IStandardExpression fragmentSelector;
    private final AssignationSequence parameters;

    public FragmentSelection(IStandardExpression templateName, IStandardExpression fragmentSelector, AssignationSequence parameters) {
        this.templateName = templateName;
        this.fragmentSelector = fragmentSelector;
        this.parameters = parameters;
    }

    public IStandardExpression getTemplateName() {
        return this.templateName;
    }

    public IStandardExpression getFragmentSelector() {
        return this.fragmentSelector;
    }

    public boolean hasFragmentSelector() {
        return this.fragmentSelector != null;
    }

    public AssignationSequence getParameters() {
        return this.parameters;
    }

    public boolean hasParameters() {
        return this.parameters != null && this.parameters.size() > 0;
    }

    public String getStringRepresentation() {
        String templateSelectionParameters;
        String templateNameStringRepresentation;
        String string = templateNameStringRepresentation = this.templateName != null ? this.templateName.getStringRepresentation() : "";
        if (this.parameters == null || this.parameters.size() > 0) {
            templateSelectionParameters = "";
        } else {
            StringBuilder paramBuilder = new StringBuilder();
            paramBuilder.append(' ');
            paramBuilder.append('(');
            paramBuilder.append(StringUtils.join(this.parameters.getAssignations(), ','));
            paramBuilder.append(')');
            templateSelectionParameters = paramBuilder.toString();
        }
        if (this.fragmentSelector == null) {
            return templateNameStringRepresentation + templateSelectionParameters;
        }
        return templateNameStringRepresentation + " :: " + this.fragmentSelector.getStringRepresentation() + templateSelectionParameters;
    }

    public String toString() {
        return this.getStringRepresentation();
    }
}

