/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.processor.attr;

import java.util.List;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Attribute;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.fragment.WholeFragmentSpec;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.attr.AbstractFragmentHandlingAttrProcessor;
import org.thymeleaf.standard.fragment.StandardFragment;
import org.thymeleaf.standard.fragment.StandardFragmentProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStandardFragmentHandlingAttrProcessor
extends AbstractFragmentHandlingAttrProcessor {
    protected AbstractStandardFragmentHandlingAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    protected AbstractStandardFragmentHandlingAttrProcessor(String attributeName) {
        super(attributeName);
    }

    @Override
    protected final List<Node> computeFragment(Arguments arguments, Element element, String attributeName, String attributeValue) {
        String dialectPrefix = Attribute.getPrefixFromAttributeName(attributeName);
        String fragmentSignatureAttributeName = this.getFragmentSignatureUnprefixedAttributeName(arguments, element, attributeName, attributeValue);
        StandardFragment fragment = StandardFragmentProcessor.computeStandardFragmentSpec(arguments.getConfiguration(), arguments, attributeValue, dialectPrefix, fragmentSignatureAttributeName);
        List<Node> extractedNodes = fragment.extractFragment(arguments.getConfiguration(), arguments, arguments.getTemplateRepository());
        boolean removeHostNode = this.getRemoveHostNode(arguments, element, attributeName, attributeValue);
        boolean isWholeDocument = fragment.getFragmentSpec() instanceof WholeFragmentSpec;
        if (extractedNodes == null || removeHostNode || isWholeDocument) {
            return extractedNodes;
        }
        Element containerElement = new Element("container");
        for (Node extractedNode : extractedNodes) {
            containerElement.addChild(extractedNode);
            containerElement.extractChild(extractedNode);
        }
        List<Node> extractedChildren = containerElement.getChildren();
        containerElement.clearChildren();
        return extractedChildren;
    }

    protected abstract String getFragmentSignatureUnprefixedAttributeName(Arguments var1, Element var2, String var3, String var4);
}

