/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.db.impl;

import com.coreframework.db.JdbcConnection;
import com.coreframework.db.impl.MysqlTimeout;
import com.coreframework.db.impl.OracleTimeout;
import com.coreframework.db.impl.TimeoutHandler;
import com.coreframework.log.LogBody;
import com.coreframework.log.Logger;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class TimeoutThread
extends Thread {
    private static final long MILL_ORIGIN = System.currentTimeMillis();
    private volatile DelayQueue<TimeoutDelayed> queue = new DelayQueue();
    private List<TimeoutHandler> handlers = new ArrayList<TimeoutHandler>(2);

    @Override
    public void run() {
        try {
            TimeoutHandler[] hs = new TimeoutHandler[]{new MysqlTimeout(), new OracleTimeout()};
            int i = 0;
            while (i < hs.length) {
                TimeoutHandler h = hs[i];
                hs[i] = null;
                if (h.validDriver()) {
                    this.handlers.add(h);
                }
                ++i;
            }
            hs = null;
            while (true) {
                TimeoutDelayed delay = (TimeoutDelayed)this.queue.take();
                this.doTimeout(delay);
            }
        }
        catch (InterruptedException e) {
            System.out.println("Timeout thread exit !!!");
            return;
        }
    }

    public void addTask(JdbcConnection request, long timeout) {
        this.queue.put(new TimeoutDelayed(request, timeout));
    }

    public void removeTask(JdbcConnection request, long timeout) {
        this.queue.remove(new TimeoutDelayed(request, timeout));
    }

    public void doTimeout(TimeoutDelayed delay) {
        long begin = System.currentTimeMillis();
        boolean handled = false;
        try {
            Connection conn = delay.request.getConn();
            for (TimeoutHandler h : this.handlers) {
                if (!h.handle(conn)) continue;
                handled = true;
                break;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        Logger.get().trace("DAC", LogBody.me().set("timeout", (Object)delay.request.getTimeout()).set("time-in-handle", (Object)(System.currentTimeMillis() - begin)).set("handled", (Object)String.valueOf(handled)).set("sql", (Object)delay.request.getSqls()));
    }

    public class TimeoutDelayed
    implements Delayed {
        private JdbcConnection request;
        private long now;
        private long timeout;

        public TimeoutDelayed(JdbcConnection request, long timeout) {
            this.request = request;
            this.timeout = timeout;
            this.now = System.currentTimeMillis() - MILL_ORIGIN;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long currNow = System.currentTimeMillis() - MILL_ORIGIN;
            long d = unit.convert(this.now + this.timeout - currNow, TimeUnit.MILLISECONDS);
            return d;
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof TimeoutDelayed) {
                TimeoutDelayed x = (TimeoutDelayed)other;
                long diff = this.now + this.timeout - (x.now + x.timeout);
                return diff < 0L ? 1 : (diff > 0L ? 1 : (this.now > x.now ? 1 : -1));
            }
            long d = this.getDelay(TimeUnit.MILLISECONDS) - other.getDelay(TimeUnit.MILLISECONDS);
            return d == 0L ? 0 : (d < 0L ? -1 : 1);
        }

        public boolean equals(Object obj) {
            if (obj instanceof TimeoutDelayed) {
                TimeoutDelayed tmp = (TimeoutDelayed)obj;
                return tmp.request.getConnid() == this.request.getConnid();
            }
            return false;
        }
    }
}

