/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import org.apache.geronimo.mail.util.ASCIIUtil;
import org.apache.geronimo.mail.util.RFC2231Encoder;
import org.apache.geronimo.mail.util.SessionUtil;

public class ParameterList {
    private static final String MIME_ENCODEPARAMETERS = "mail.mime.encodeparameters";
    private static final String MIME_DECODEPARAMETERS = "mail.mime.decodeparameters";
    private static final String MIME_DECODEPARAMETERS_STRICT = "mail.mime.decodeparameters.strict";
    private static final int HEADER_SIZE_LIMIT = 76;
    private Map _parameters;
    private boolean encodeParameters;
    private boolean decodeParameters;
    private boolean decodeParametersStrict;

    public ParameterList() {
        this._parameters = new HashMap();
        this.encodeParameters = false;
        this.decodeParameters = false;
        this.decodeParametersStrict = false;
        this.getInitialProperties();
    }

    /*
     * Unable to fully structure code
     */
    public ParameterList(String list) throws ParseException {
        super();
        this._parameters = new HashMap<K, V>();
        this.encodeParameters = false;
        this.decodeParameters = false;
        this.decodeParametersStrict = false;
        this.getInitialProperties();
        tokenizer = new HeaderTokenizer(list, "()<>@,;:\\\"\t []/?=");
        block6: while (true) {
            token = tokenizer.next();
            switch (token.getType()) {
                case -4: {
                    return;
                }
                case 59: {
                    token = tokenizer.next();
                    if (token.getType() == -4) {
                        return;
                    }
                    if (token.getType() != -1) {
                        throw new ParseException("Invalid parameter name: " + token.getValue());
                    }
                    name = token.getValue().toLowerCase();
                    token = tokenizer.next();
                    if (token.getType() != 61) {
                        throw new ParseException("Missing '='");
                    }
                    token = tokenizer.next();
                    if (token.getType() != -1 && token.getType() != -2) {
                        throw new ParseException("Invalid parameter value: " + token.getValue());
                    }
                    value = token.getValue();
                    encodedValue = null;
                    if (!this.decodeParameters || !name.endsWith("*")) ** GOTO lbl37
                    name = name.substring(0, name.length() - 1);
                    decoder = new RFC2231Encoder("()<>@,;:\\\"\t []/?=");
                    try {
                        encodedValue = decoder.decode(value);
                    }
                    catch (Exception e) {
                        if (!this.decodeParametersStrict) ** GOTO lbl37
                        throw new ParseException("Invalid RFC2231 encoded parameter");
                    }
lbl37:
                    // 3 sources

                    this._parameters.put(name, new ParameterValue(name, value, encodedValue));
                    continue block6;
                }
            }
            break;
        }
        throw new ParseException("Missing ';'");
    }

    private void getInitialProperties() {
        this.decodeParameters = SessionUtil.getBooleanProperty((String)MIME_DECODEPARAMETERS, (boolean)false);
        this.decodeParametersStrict = SessionUtil.getBooleanProperty((String)MIME_DECODEPARAMETERS_STRICT, (boolean)false);
        this.encodeParameters = SessionUtil.getBooleanProperty((String)MIME_ENCODEPARAMETERS, (boolean)false);
    }

    public int size() {
        return this._parameters.size();
    }

    public String get(String name) {
        ParameterValue value = (ParameterValue)this._parameters.get(name.toLowerCase());
        if (value != null) {
            return value.value;
        }
        return null;
    }

    public void set(String name, String value) {
        name = name.toLowerCase();
        this._parameters.put(name, new ParameterValue(name, value));
    }

    public void remove(String name) {
        this._parameters.remove(name);
    }

    public Enumeration getNames() {
        return Collections.enumeration(this._parameters.keySet());
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int used) {
        StringBuffer stringValue = new StringBuffer();
        Iterator values = this._parameters.values().iterator();
        while (values.hasNext()) {
            ParameterValue parm = (ParameterValue)values.next();
            String name = parm.getEncodedName();
            String value = parm.toString();
            stringValue.append("; ");
            if ((used += 2) + name.length() + value.length() + 1 > 76) {
                stringValue.append("\r\n ");
                used = 3;
            }
            stringValue.append(name);
            stringValue.append("=");
            if ((used += name.length() + 1) + value.length() > 76) {
                String foldedValue = ASCIIUtil.fold((int)used, (String)value);
                stringValue.append(foldedValue);
                int lastLineBreak = foldedValue.lastIndexOf(10);
                if (lastLineBreak != -1) {
                    used = foldedValue.length() - lastLineBreak + 1;
                    continue;
                }
                used += foldedValue.length();
                continue;
            }
            stringValue.append(value);
            used += value.length();
        }
        return stringValue.toString();
    }

    class ParameterValue {
        public String name;
        public String value;
        public String encodedValue;

        public ParameterValue(String name, String value) {
            this.name = name;
            this.value = value;
            this.encodedValue = null;
        }

        public ParameterValue(String name, String value, String encodedValue) {
            this.name = name;
            this.value = value;
            this.encodedValue = encodedValue;
        }

        public String toString() {
            if (this.encodedValue != null) {
                return MimeUtility.quote(this.encodedValue, "()<>@,;:\\\"\t []/?=");
            }
            return MimeUtility.quote(this.value, "()<>@,;:\\\"\t []/?=");
        }

        public String getEncodedName() {
            if (this.encodedValue != null) {
                return this.name + "*";
            }
            return this.name;
        }
    }
}

