/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchException;
import org.elasticsearch.search.SearchShardTarget;

public class ShardSearchFailure
implements ShardOperationFailedException {
    public static final ShardSearchFailure[] EMPTY_ARRAY = new ShardSearchFailure[0];
    private SearchShardTarget shardTarget;
    private String reason;
    private RestStatus status;
    private Throwable cause;

    private ShardSearchFailure() {
    }

    public ShardSearchFailure(Throwable t) {
        this(t, null);
    }

    public ShardSearchFailure(Throwable t, @Nullable SearchShardTarget shardTarget) {
        Throwable actual = ExceptionsHelper.unwrapCause(t);
        if (actual != null && actual instanceof SearchException) {
            this.shardTarget = ((SearchException)actual).shard();
        } else if (shardTarget != null) {
            this.shardTarget = shardTarget;
        }
        this.status = ExceptionsHelper.status(actual);
        this.reason = ExceptionsHelper.detailedMessage(t);
        this.cause = actual;
    }

    public ShardSearchFailure(String reason, SearchShardTarget shardTarget) {
        this(reason, shardTarget, RestStatus.INTERNAL_SERVER_ERROR);
    }

    public ShardSearchFailure(String reason, SearchShardTarget shardTarget, RestStatus status) {
        this.shardTarget = shardTarget;
        this.reason = reason;
        this.status = status;
    }

    @Nullable
    public SearchShardTarget shard() {
        return this.shardTarget;
    }

    @Override
    public RestStatus status() {
        return this.status;
    }

    @Override
    public String index() {
        if (this.shardTarget != null) {
            return this.shardTarget.index();
        }
        return null;
    }

    @Override
    public int shardId() {
        if (this.shardTarget != null) {
            return this.shardTarget.shardId();
        }
        return -1;
    }

    @Override
    public String reason() {
        return this.reason;
    }

    public String toString() {
        return "shard [" + (this.shardTarget == null ? "_na" : this.shardTarget) + "], reason [" + this.reason + "], cause [" + (this.cause == null ? "_na" : ExceptionsHelper.stackTrace(this.cause)) + "]";
    }

    public static ShardSearchFailure readShardSearchFailure(StreamInput in) throws IOException {
        ShardSearchFailure shardSearchFailure = new ShardSearchFailure();
        shardSearchFailure.readFrom(in);
        return shardSearchFailure;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.shardTarget = SearchShardTarget.readSearchShardTarget(in);
        }
        this.reason = in.readString();
        this.status = RestStatus.readFrom(in);
        this.cause = in.readThrowable();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.shardTarget == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.shardTarget.writeTo(out);
        }
        out.writeString(this.reason);
        RestStatus.writeTo(out, this.status);
        out.writeThrowable(this.cause);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("shard", this.shardId());
        builder.field("index", this.index());
        if (this.shardTarget != null) {
            builder.field("node", this.shardTarget.nodeId());
        }
        if (this.cause != null) {
            builder.field("reason");
            builder.startObject();
            ElasticsearchException.toXContent(builder, params, this.cause);
            builder.endObject();
        }
        return builder;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }
}

