/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.action.search.type.TransportSearchTypeAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;
import org.elasticsearch.threadpool.ThreadPool;

public class TransportSearchQueryAndFetchAction
extends TransportSearchTypeAction {
    @Inject
    public TransportSearchQueryAndFetchAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, threadPool, clusterService, searchService, searchPhaseController, actionFilters, indexNameExpressionResolver);
    }

    @Override
    protected void doExecute(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        new AsyncAction(searchRequest, listener).start();
    }

    private class AsyncAction
    extends TransportSearchTypeAction.BaseAsyncAction<QueryFetchSearchResult> {
        private AsyncAction(SearchRequest request, ActionListener<SearchResponse> listener) {
            super(request, listener);
        }

        @Override
        protected String firstPhaseName() {
            return "query_fetch";
        }

        @Override
        protected void sendExecuteFirstPhase(DiscoveryNode node, ShardSearchTransportRequest request, ActionListener<QueryFetchSearchResult> listener) {
            TransportSearchQueryAndFetchAction.this.searchService.sendExecuteFetch(node, request, listener);
        }

        @Override
        protected void moveToSecondPhase() throws Exception {
            TransportSearchQueryAndFetchAction.this.threadPool.executor("search").execute(new ActionRunnable<SearchResponse>(this.listener){

                @Override
                public void doRun() throws IOException {
                    boolean useScroll = AsyncAction.this.request.scroll() != null;
                    AsyncAction.this.sortedShardList = TransportSearchQueryAndFetchAction.this.searchPhaseController.sortDocs(useScroll, AsyncAction.this.firstResults);
                    InternalSearchResponse internalResponse = TransportSearchQueryAndFetchAction.this.searchPhaseController.merge(AsyncAction.this.sortedShardList, AsyncAction.this.firstResults, AsyncAction.this.firstResults, AsyncAction.this.request);
                    String scrollId = null;
                    if (AsyncAction.this.request.scroll() != null) {
                        scrollId = TransportSearchHelper.buildScrollId(AsyncAction.this.request.searchType(), (AtomicArray<? extends SearchPhaseResult>)AsyncAction.this.firstResults, null);
                    }
                    this.listener.onResponse(new SearchResponse(internalResponse, scrollId, AsyncAction.this.expectedSuccessfulOps, AsyncAction.this.successfulOps.get(), AsyncAction.this.buildTookInMillis(), AsyncAction.this.buildShardFailures()));
                }

                @Override
                public void onFailure(Throwable t) {
                    ReduceSearchPhaseException failure = new ReduceSearchPhaseException("merge", "", t, AsyncAction.this.buildShardFailures());
                    if (TransportSearchQueryAndFetchAction.this.logger.isDebugEnabled()) {
                        TransportSearchQueryAndFetchAction.this.logger.debug("failed to reduce search", failure, new Object[0]);
                    }
                    super.onFailure(failure);
                }
            });
        }
    }
}

