/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvectors;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.elasticsearch.action.termvectors.TermVectorsResponse;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportTermVectorsAction
extends TransportSingleShardAction<TermVectorsRequest, TermVectorsResponse> {
    private final IndicesService indicesService;

    @Override
    protected void doExecute(TermVectorsRequest request, ActionListener<TermVectorsResponse> listener) {
        request.startTime = System.currentTimeMillis();
        super.doExecute(request, listener);
    }

    @Inject
    public TransportTermVectorsAction(Settings settings, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:data/read/tv", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, TermVectorsRequest.class, "get");
        this.indicesService = indicesService;
    }

    @Override
    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return this.clusterService.operationRouting().getShards(state, request.concreteIndex(), ((TermVectorsRequest)request.request()).type(), ((TermVectorsRequest)request.request()).id(), ((TermVectorsRequest)request.request()).routing(), ((TermVectorsRequest)request.request()).preference());
    }

    @Override
    protected boolean resolveIndex(TermVectorsRequest request) {
        return true;
    }

    @Override
    protected void resolveRequest(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        ((TermVectorsRequest)request.request()).routing(state.metaData().resolveIndexRouting(((TermVectorsRequest)request.request()).routing(), ((TermVectorsRequest)request.request()).index()));
        if (((TermVectorsRequest)request.request()).routing() == null && state.getMetaData().routingRequired(request.concreteIndex(), ((TermVectorsRequest)request.request()).type())) {
            throw new RoutingMissingException(request.concreteIndex(), ((TermVectorsRequest)request.request()).type(), ((TermVectorsRequest)request.request()).id());
        }
    }

    @Override
    protected TermVectorsResponse shardOperation(TermVectorsRequest request, ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.shardSafe(shardId.id());
        TermVectorsResponse response = indexShard.termVectorsService().getTermVectors(request, shardId.getIndex());
        response.updateTookInMillis(request.startTime());
        return response;
    }

    @Override
    protected TermVectorsResponse newResponse() {
        return new TermVectorsResponse();
    }
}

