/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingExplanations;
import org.elasticsearch.cluster.routing.allocation.command.AllocateAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.CancelAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.MoveAllocationCommand;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class AllocationCommands {
    private static Map<String, AllocationCommand.Factory> factories = new HashMap<String, AllocationCommand.Factory>();
    private final List<AllocationCommand> commands = new ArrayList<AllocationCommand>();

    public static void registerFactory(String type, AllocationCommand.Factory factory) {
        factories.put(type, factory);
    }

    @Nullable
    public static <T extends AllocationCommand> AllocationCommand.Factory<T> lookupFactory(String name) {
        return factories.get(name);
    }

    public static <T extends AllocationCommand> AllocationCommand.Factory<T> lookupFactorySafe(String name) {
        AllocationCommand.Factory factory = factories.get(name);
        if (factory == null) {
            throw new IllegalArgumentException("No allocation command factory registered for name [" + name + "]");
        }
        return factory;
    }

    public AllocationCommands(AllocationCommand ... commands) {
        if (commands != null) {
            this.commands.addAll(Arrays.asList(commands));
        }
    }

    public AllocationCommands add(AllocationCommand ... commands) {
        if (commands != null) {
            this.commands.addAll(Arrays.asList(commands));
        }
        return this;
    }

    public List<AllocationCommand> commands() {
        return this.commands;
    }

    public RoutingExplanations execute(RoutingAllocation allocation, boolean explain) {
        RoutingExplanations explanations = new RoutingExplanations();
        for (AllocationCommand command : this.commands) {
            explanations.add(command.execute(allocation, explain));
        }
        return explanations;
    }

    public static AllocationCommands readFrom(StreamInput in) throws IOException {
        AllocationCommands commands = new AllocationCommands(new AllocationCommand[0]);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            String name = in.readString();
            commands.add(new AllocationCommand[]{AllocationCommands.lookupFactorySafe(name).readFrom(in)});
        }
        return commands;
    }

    public static void writeTo(AllocationCommands commands, StreamOutput out) throws IOException {
        out.writeVInt(commands.commands.size());
        for (AllocationCommand command : commands.commands) {
            out.writeString(command.name());
            AllocationCommands.lookupFactorySafe(command.name()).writeTo(command, out);
        }
    }

    public static AllocationCommands fromXContent(XContentParser parser) throws IOException {
        AllocationCommands commands = new AllocationCommands(new AllocationCommand[0]);
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            throw new ElasticsearchParseException("No commands", new Object[0]);
        }
        if (token == XContentParser.Token.FIELD_NAME) {
            if (!parser.currentName().equals("commands")) {
                throw new ElasticsearchParseException("expected field name to be named [commands], got [{}] instead", parser.currentName());
            }
            if (!parser.currentName().equals("commands")) {
                throw new ElasticsearchParseException("expected field name to be named [commands], got [{}] instead", parser.currentName());
            }
            token = parser.nextToken();
            if (token != XContentParser.Token.START_ARRAY) {
                throw new ElasticsearchParseException("commands should follow with an array element", new Object[0]);
            }
        } else if (token != XContentParser.Token.START_ARRAY) {
            throw new ElasticsearchParseException("expected either field name [commands], or start array, got [{}] instead", new Object[]{token});
        }
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token == XContentParser.Token.START_OBJECT) {
                token = parser.nextToken();
                String commandName = parser.currentName();
                token = parser.nextToken();
                commands.add(new AllocationCommand[]{AllocationCommands.lookupFactorySafe(commandName).fromXContent(parser)});
                if (parser.nextToken() == XContentParser.Token.END_OBJECT) continue;
                throw new ElasticsearchParseException("allocation command is malformed, done parsing a command, but didn't get END_OBJECT, got [{}] instead", new Object[]{token});
            }
            throw new ElasticsearchParseException("allocation command is malformed, got [{}] instead", new Object[]{token});
        }
        return commands;
    }

    public static void toXContent(AllocationCommands commands, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("commands");
        for (AllocationCommand command : commands.commands) {
            builder.startObject();
            builder.field(command.name());
            AllocationCommands.lookupFactorySafe(command.name()).toXContent(command, builder, params, null);
            builder.endObject();
        }
        builder.endArray();
    }

    static {
        AllocationCommands.registerFactory("allocate", new AllocateAllocationCommand.Factory());
        AllocationCommands.registerFactory("cancel", new CancelAllocationCommand.Factory());
        AllocationCommands.registerFactory("move", new MoveAllocationCommand.Factory());
    }
}

