/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Locale;

public class LocaleUtils {
    public static Locale parse(String localeStr) {
        String[] parts = localeStr.split("_", -1);
        switch (parts.length) {
            case 3: {
                return new Locale(parts[0], parts[1], parts[2]);
            }
            case 2: {
                return new Locale(parts[0], parts[1]);
            }
            case 1: {
                if ("ROOT".equalsIgnoreCase(parts[0])) {
                    return Locale.ROOT;
                }
                return new Locale(parts[0]);
            }
        }
        throw new IllegalArgumentException("Can't parse locale: [" + localeStr + "]");
    }

    public static String toString(Locale locale) {
        return locale.toString();
    }
}

