/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.shingle.ShingleFilter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettingsService;

public class ShingleTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final Factory factory;

    @Inject
    public ShingleTokenFilterFactory(Index index, IndexSettingsService indexSettingsService, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettingsService.getSettings(), name, settings);
        Integer maxShingleSize = settings.getAsInt("max_shingle_size", (Integer)2);
        Integer minShingleSize = settings.getAsInt("min_shingle_size", (Integer)2);
        Boolean outputUnigrams = settings.getAsBoolean("output_unigrams", (Boolean)true);
        Boolean outputUnigramsIfNoShingles = settings.getAsBoolean("output_unigrams_if_no_shingles", (Boolean)false);
        String tokenSeparator = settings.get("token_separator", " ");
        String fillerToken = settings.get("filler_token", "_");
        this.factory = new Factory("shingle", minShingleSize, maxShingleSize, outputUnigrams, outputUnigramsIfNoShingles, tokenSeparator, fillerToken);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return this.factory.create(tokenStream);
    }

    public Factory getInnerFactory() {
        return this.factory;
    }

    public static final class Factory
    implements TokenFilterFactory {
        private final int maxShingleSize;
        private final boolean outputUnigrams;
        private final boolean outputUnigramsIfNoShingles;
        private final String tokenSeparator;
        private final String fillerToken;
        private int minShingleSize;
        private final String name;

        public Factory(String name) {
            this(name, 2, 2, true, false, " ", "_");
        }

        Factory(String name, int minShingleSize, int maxShingleSize, boolean outputUnigrams, boolean outputUnigramsIfNoShingles, String tokenSeparator, String fillerToken) {
            this.maxShingleSize = maxShingleSize;
            this.outputUnigrams = outputUnigrams;
            this.outputUnigramsIfNoShingles = outputUnigramsIfNoShingles;
            this.tokenSeparator = tokenSeparator;
            this.minShingleSize = minShingleSize;
            this.fillerToken = fillerToken;
            this.name = name;
        }

        @Override
        public TokenStream create(TokenStream tokenStream) {
            ShingleFilter filter = new ShingleFilter(tokenStream, this.minShingleSize, this.maxShingleSize);
            filter.setOutputUnigrams(this.outputUnigrams);
            filter.setOutputUnigramsIfNoShingles(this.outputUnigramsIfNoShingles);
            filter.setTokenSeparator(this.tokenSeparator);
            filter.setFillerToken(this.fillerToken);
            return filter;
        }

        public int getMaxShingleSize() {
            return this.maxShingleSize;
        }

        public int getMinShingleSize() {
            return this.minShingleSize;
        }

        public boolean getOutputUnigrams() {
            return this.outputUnigrams;
        }

        public boolean getOutputUnigramsIfNoShingles() {
            return this.outputUnigramsIfNoShingles;
        }

        @Override
        public String name() {
            return this.name;
        }
    }
}

