/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SimpleQueryStringFlag;

public class SimpleQueryStringBuilder
extends QueryBuilder
implements BoostableQueryBuilder<SimpleQueryStringBuilder> {
    private Map<String, Float> fields = new HashMap<String, Float>();
    private String analyzer;
    private Operator operator;
    private final String queryText;
    private String queryName;
    private String minimumShouldMatch;
    private int flags = -1;
    private float boost = -1.0f;
    private Boolean lowercaseExpandedTerms;
    private Boolean lenient;
    private Boolean analyzeWildcard;
    private Locale locale;

    public SimpleQueryStringBuilder(String text) {
        this.queryText = text;
    }

    @Override
    public SimpleQueryStringBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public float boost() {
        return this.boost;
    }

    public SimpleQueryStringBuilder field(String field) {
        this.fields.put(field, null);
        return this;
    }

    public SimpleQueryStringBuilder field(String field, float boost) {
        this.fields.put(field, Float.valueOf(boost));
        return this;
    }

    public SimpleQueryStringBuilder queryName(String name) {
        this.queryName = name;
        return this;
    }

    public SimpleQueryStringBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public SimpleQueryStringBuilder defaultOperator(Operator defaultOperator) {
        this.operator = defaultOperator;
        return this;
    }

    public SimpleQueryStringBuilder flags(SimpleQueryStringFlag ... flags) {
        int value = 0;
        if (flags.length == 0) {
            value = SimpleQueryStringFlag.ALL.value;
        } else {
            for (SimpleQueryStringFlag flag : flags) {
                value |= flag.value;
            }
        }
        this.flags = value;
        return this;
    }

    public SimpleQueryStringBuilder lowercaseExpandedTerms(boolean lowercaseExpandedTerms) {
        this.lowercaseExpandedTerms = lowercaseExpandedTerms;
        return this;
    }

    public SimpleQueryStringBuilder locale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public SimpleQueryStringBuilder lenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    public SimpleQueryStringBuilder analyzeWildcard(boolean analyzeWildcard) {
        this.analyzeWildcard = analyzeWildcard;
        return this;
    }

    public SimpleQueryStringBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("simple_query_string");
        builder.field("query", this.queryText);
        if (this.fields.size() > 0) {
            builder.startArray("fields");
            for (Map.Entry<String, Float> entry : this.fields.entrySet()) {
                String field = entry.getKey();
                Float boost = entry.getValue();
                if (boost != null) {
                    builder.value(field + "^" + boost);
                    continue;
                }
                builder.value(field);
            }
            builder.endArray();
        }
        if (this.flags != -1) {
            builder.field("flags", this.flags);
        }
        if (this.analyzer != null) {
            builder.field("analyzer", this.analyzer);
        }
        if (this.operator != null) {
            builder.field("default_operator", this.operator.name().toLowerCase(Locale.ROOT));
        }
        if (this.lowercaseExpandedTerms != null) {
            builder.field("lowercase_expanded_terms", (Object)this.lowercaseExpandedTerms);
        }
        if (this.lenient != null) {
            builder.field("lenient", (Object)this.lenient);
        }
        if (this.analyzeWildcard != null) {
            builder.field("analyze_wildcard", (Object)this.analyzeWildcard);
        }
        if (this.locale != null) {
            builder.field("locale", this.locale.toString());
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        if (this.minimumShouldMatch != null) {
            builder.field("minimum_should_match", this.minimumShouldMatch);
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        builder.endObject();
    }

    public static enum Operator {
        AND,
        OR;

    }
}

