/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore.script;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.common.lucene.search.function.ScriptScoreFunction;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.functionscore.ScoreFunctionParser;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptParameterParser;
import org.elasticsearch.script.SearchScript;

public class ScriptScoreFunctionParser
implements ScoreFunctionParser {
    public static String[] NAMES = new String[]{"script_score", "scriptScore"};

    @Inject
    public ScriptScoreFunctionParser() {
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public ScoreFunction parse(QueryParseContext parseContext, XContentParser parser) throws IOException, QueryParsingException {
        XContentParser.Token token;
        ScriptParameterParser scriptParameterParser = new ScriptParameterParser();
        Script script = null;
        Map<Object, Object> vars = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (parseContext.parseFieldMatcher().match(currentFieldName, Script.ScriptField.SCRIPT)) {
                    script = Script.parse(parser, parseContext.parseFieldMatcher());
                    continue;
                }
                if ("params".equals(currentFieldName)) {
                    vars = parser.map();
                    continue;
                }
                throw new QueryParsingException(parseContext, NAMES[0] + " query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (!token.isValue() || scriptParameterParser.token(currentFieldName, token, parser, parseContext.parseFieldMatcher())) continue;
            throw new QueryParsingException(parseContext, NAMES[0] + " query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (script == null) {
            ScriptParameterParser.ScriptParameterValue scriptValue = scriptParameterParser.getDefaultScriptParameterValue();
            if (scriptValue != null) {
                if (vars == null) {
                    vars = Maps.newHashMap();
                }
                script = new Script(scriptValue.script(), scriptValue.scriptType(), scriptParameterParser.lang(), vars);
            }
        } else if (vars != null) {
            throw new QueryParsingException(parseContext, "script params must be specified inside script object", new Object[0]);
        }
        if (script == null) {
            throw new QueryParsingException(parseContext, NAMES[0] + " requires 'script' field", new Object[0]);
        }
        try {
            SearchScript searchScript = parseContext.scriptService().search(parseContext.lookup(), script, ScriptContext.Standard.SEARCH);
            return new ScriptScoreFunction(script, searchScript);
        }
        catch (Exception e) {
            throw new QueryParsingException(parseContext, NAMES[0] + " the script could not be loaded", e, new Object[0]);
        }
    }
}

