/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.support;

import java.io.IOException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.search.fetch.fielddata.FieldDataFieldsParseElement;
import org.elasticsearch.search.fetch.innerhits.InnerHitsSubSearchContext;
import org.elasticsearch.search.fetch.script.ScriptFieldsParseElement;
import org.elasticsearch.search.fetch.source.FetchSourceParseElement;
import org.elasticsearch.search.highlight.HighlighterParseElement;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.SubSearchContext;
import org.elasticsearch.search.sort.SortParseElement;

public class InnerHitsQueryParserHelper {
    private final SortParseElement sortParseElement;
    private final FetchSourceParseElement sourceParseElement;
    private final HighlighterParseElement highlighterParseElement;
    private final ScriptFieldsParseElement scriptFieldsParseElement;
    private final FieldDataFieldsParseElement fieldDataFieldsParseElement;

    @Inject
    public InnerHitsQueryParserHelper(SortParseElement sortParseElement, FetchSourceParseElement sourceParseElement, HighlighterParseElement highlighterParseElement, ScriptFieldsParseElement scriptFieldsParseElement, FieldDataFieldsParseElement fieldDataFieldsParseElement) {
        this.sortParseElement = sortParseElement;
        this.sourceParseElement = sourceParseElement;
        this.highlighterParseElement = highlighterParseElement;
        this.scriptFieldsParseElement = scriptFieldsParseElement;
        this.fieldDataFieldsParseElement = fieldDataFieldsParseElement;
    }

    public InnerHitsSubSearchContext parse(QueryParseContext parserContext) throws IOException, QueryParsingException {
        String fieldName = null;
        String innerHitName = null;
        SubSearchContext subSearchContext = new SubSearchContext(SearchContext.current());
        try {
            XContentParser.Token token;
            XContentParser parser = parserContext.parser();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    fieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if ("name".equals(fieldName)) {
                        innerHitName = parser.textOrNull();
                        continue;
                    }
                    InnerHitsQueryParserHelper.parseCommonInnerHitOptions(parser, token, fieldName, subSearchContext, this.sortParseElement, this.sourceParseElement, this.highlighterParseElement, this.scriptFieldsParseElement, this.fieldDataFieldsParseElement);
                    continue;
                }
                InnerHitsQueryParserHelper.parseCommonInnerHitOptions(parser, token, fieldName, subSearchContext, this.sortParseElement, this.sourceParseElement, this.highlighterParseElement, this.scriptFieldsParseElement, this.fieldDataFieldsParseElement);
            }
        }
        catch (Exception e) {
            throw new QueryParsingException(parserContext, "Failed to parse [_inner_hits]", e, new Object[0]);
        }
        return new InnerHitsSubSearchContext(innerHitName, subSearchContext);
    }

    public static void parseCommonInnerHitOptions(XContentParser parser, XContentParser.Token token, String fieldName, SubSearchContext subSearchContext, SortParseElement sortParseElement, FetchSourceParseElement sourceParseElement, HighlighterParseElement highlighterParseElement, ScriptFieldsParseElement scriptFieldsParseElement, FieldDataFieldsParseElement fieldDataFieldsParseElement) throws Exception {
        block39: {
            block42: {
                block41: {
                    block40: {
                        block38: {
                            if (!"sort".equals(fieldName)) break block38;
                            sortParseElement.parse(parser, subSearchContext);
                            break block39;
                        }
                        if (!"_source".equals(fieldName)) break block40;
                        sourceParseElement.parse(parser, subSearchContext);
                        break block39;
                    }
                    if (token != XContentParser.Token.START_OBJECT) break block41;
                    switch (fieldName) {
                        case "highlight": {
                            highlighterParseElement.parse(parser, subSearchContext);
                            break;
                        }
                        case "scriptFields": 
                        case "script_fields": {
                            scriptFieldsParseElement.parse(parser, subSearchContext);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown key for a " + (Object)((Object)token) + " for nested query: [" + fieldName + "].");
                        }
                    }
                    break block39;
                }
                if (token != XContentParser.Token.START_ARRAY) break block42;
                switch (fieldName) {
                    case "fielddataFields": 
                    case "fielddata_fields": {
                        fieldDataFieldsParseElement.parse(parser, subSearchContext);
                        break;
                    }
                    case "fields": {
                        boolean added = false;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            String name = parser.text();
                            added = true;
                            subSearchContext.fieldNames().add(name);
                        }
                        if (!added) {
                            subSearchContext.emptyFieldNames();
                            break;
                        }
                        break block39;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown key for a " + (Object)((Object)token) + " for nested query: [" + fieldName + "].");
                    }
                }
                break block39;
            }
            if (token.isValue()) {
                switch (fieldName) {
                    case "from": {
                        subSearchContext.from(parser.intValue());
                        break;
                    }
                    case "size": {
                        subSearchContext.size(parser.intValue());
                        break;
                    }
                    case "track_scores": 
                    case "trackScores": {
                        subSearchContext.trackScores(parser.booleanValue());
                        break;
                    }
                    case "version": {
                        subSearchContext.version(parser.booleanValue());
                        break;
                    }
                    case "explain": {
                        subSearchContext.explain(parser.booleanValue());
                        break;
                    }
                    case "fields": {
                        subSearchContext.fieldNames().add(parser.text());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown key for a " + (Object)((Object)token) + " for nested query: [" + fieldName + "].");
                    }
                }
            }
        }
    }
}

