/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;

public final class MergeSchedulerConfig {
    public static final String MAX_THREAD_COUNT = "index.merge.scheduler.max_thread_count";
    public static final String MAX_MERGE_COUNT = "index.merge.scheduler.max_merge_count";
    public static final String AUTO_THROTTLE = "index.merge.scheduler.auto_throttle";
    public static final String NOTIFY_ON_MERGE_FAILURE = "index.merge.scheduler.notify_on_failure";
    private volatile boolean autoThrottle;
    private volatile int maxThreadCount;
    private volatile int maxMergeCount;
    private final boolean notifyOnMergeFailure;

    public MergeSchedulerConfig(Settings indexSettings) {
        this.maxThreadCount = indexSettings.getAsInt(MAX_THREAD_COUNT, (Integer)Math.max(1, Math.min(4, EsExecutors.boundedNumberOfProcessors(indexSettings) / 2)));
        this.maxMergeCount = indexSettings.getAsInt(MAX_MERGE_COUNT, (Integer)(this.maxThreadCount + 5));
        this.autoThrottle = indexSettings.getAsBoolean(AUTO_THROTTLE, (Boolean)true);
        this.notifyOnMergeFailure = indexSettings.getAsBoolean(NOTIFY_ON_MERGE_FAILURE, (Boolean)true);
    }

    public boolean isAutoThrottle() {
        return this.autoThrottle;
    }

    public void setAutoThrottle(boolean autoThrottle) {
        this.autoThrottle = autoThrottle;
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public void setMaxThreadCount(int maxThreadCount) {
        this.maxThreadCount = maxThreadCount;
    }

    public int getMaxMergeCount() {
        return this.maxMergeCount;
    }

    public void setMaxMergeCount(int maxMergeCount) {
        this.maxMergeCount = maxMergeCount;
    }

    public boolean isNotifyOnMergeFailure() {
        return this.notifyOnMergeFailure;
    }
}

