/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.breaker;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.breaker.ChildMemoryCircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.breaker.NoopCircuitBreaker;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.indices.breaker.AllCircuitBreakerStats;
import org.elasticsearch.indices.breaker.BreakerSettings;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.CircuitBreakerStats;
import org.elasticsearch.node.settings.NodeSettingsService;

public class HierarchyCircuitBreakerService
extends CircuitBreakerService {
    private static final String CHILD_LOGGER_PREFIX = "org.elasticsearch.indices.breaker.";
    private final ConcurrentMap<String, CircuitBreaker> breakers = new ConcurrentHashMap<String, CircuitBreaker>();
    public static final String OLD_CIRCUIT_BREAKER_MAX_BYTES_SETTING = "indices.fielddata.breaker.limit";
    public static final String OLD_CIRCUIT_BREAKER_OVERHEAD_SETTING = "indices.fielddata.breaker.overhead";
    public static final String TOTAL_CIRCUIT_BREAKER_LIMIT_SETTING = "indices.breaker.total.limit";
    public static final String DEFAULT_TOTAL_CIRCUIT_BREAKER_LIMIT = "70%";
    public static final String FIELDDATA_CIRCUIT_BREAKER_LIMIT_SETTING = "indices.breaker.fielddata.limit";
    public static final String FIELDDATA_CIRCUIT_BREAKER_OVERHEAD_SETTING = "indices.breaker.fielddata.overhead";
    public static final String FIELDDATA_CIRCUIT_BREAKER_TYPE_SETTING = "indices.breaker.fielddata.type";
    public static final String DEFAULT_FIELDDATA_BREAKER_LIMIT = "60%";
    public static final double DEFAULT_FIELDDATA_OVERHEAD_CONSTANT = 1.03;
    public static final String REQUEST_CIRCUIT_BREAKER_LIMIT_SETTING = "indices.breaker.request.limit";
    public static final String REQUEST_CIRCUIT_BREAKER_OVERHEAD_SETTING = "indices.breaker.request.overhead";
    public static final String REQUEST_CIRCUIT_BREAKER_TYPE_SETTING = "indices.breaker.request.type";
    public static final String DEFAULT_REQUEST_BREAKER_LIMIT = "40%";
    public static final String DEFAULT_BREAKER_TYPE = "memory";
    private volatile BreakerSettings parentSettings;
    private volatile BreakerSettings fielddataSettings;
    private volatile BreakerSettings requestSettings;
    private final AtomicLong parentTripCount = new AtomicLong(0L);

    @Inject
    public HierarchyCircuitBreakerService(Settings settings, NodeSettingsService nodeSettingsService) {
        super(settings);
        String compatibilityFielddataLimitDefault = DEFAULT_FIELDDATA_BREAKER_LIMIT;
        ByteSizeValue compatibilityFielddataLimit = settings.getAsMemory(OLD_CIRCUIT_BREAKER_MAX_BYTES_SETTING, null);
        if (compatibilityFielddataLimit != null) {
            compatibilityFielddataLimitDefault = compatibilityFielddataLimit.toString();
        }
        double compatibilityFielddataOverheadDefault = 1.03;
        Double compatibilityFielddataOverhead = settings.getAsDouble(OLD_CIRCUIT_BREAKER_OVERHEAD_SETTING, null);
        if (compatibilityFielddataOverhead != null) {
            compatibilityFielddataOverheadDefault = compatibilityFielddataOverhead;
        }
        this.fielddataSettings = new BreakerSettings("fielddata", settings.getAsMemory(FIELDDATA_CIRCUIT_BREAKER_LIMIT_SETTING, compatibilityFielddataLimitDefault).bytes(), settings.getAsDouble(FIELDDATA_CIRCUIT_BREAKER_OVERHEAD_SETTING, (Double)compatibilityFielddataOverheadDefault), CircuitBreaker.Type.parseValue(settings.get(FIELDDATA_CIRCUIT_BREAKER_TYPE_SETTING, DEFAULT_BREAKER_TYPE)));
        this.requestSettings = new BreakerSettings("request", settings.getAsMemory(REQUEST_CIRCUIT_BREAKER_LIMIT_SETTING, DEFAULT_REQUEST_BREAKER_LIMIT).bytes(), settings.getAsDouble(REQUEST_CIRCUIT_BREAKER_OVERHEAD_SETTING, (Double)1.0), CircuitBreaker.Type.parseValue(settings.get(REQUEST_CIRCUIT_BREAKER_TYPE_SETTING, DEFAULT_BREAKER_TYPE)));
        this.parentSettings = new BreakerSettings("parent", settings.getAsMemory(TOTAL_CIRCUIT_BREAKER_LIMIT_SETTING, DEFAULT_TOTAL_CIRCUIT_BREAKER_LIMIT).bytes(), 1.0, CircuitBreaker.Type.PARENT);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("parent circuit breaker with settings {}", this.parentSettings);
        }
        this.registerBreaker(this.requestSettings);
        this.registerBreaker(this.fielddataSettings);
        nodeSettingsService.addListener(new ApplySettings());
    }

    public static void validateSettings(BreakerSettings[] childrenSettings) throws IllegalStateException {
        for (BreakerSettings childSettings : childrenSettings) {
            if (childSettings.getLimit() == -1L || !(childSettings.getOverhead() < 0.0)) continue;
            throw new IllegalStateException("Child breaker overhead " + childSettings + " must be non-negative");
        }
    }

    @Override
    public CircuitBreaker getBreaker(String name) {
        return (CircuitBreaker)this.breakers.get(name);
    }

    @Override
    public AllCircuitBreakerStats stats() {
        long parentEstimated = 0L;
        ArrayList<CircuitBreakerStats> allStats = new ArrayList<CircuitBreakerStats>();
        for (CircuitBreaker breaker : this.breakers.values()) {
            allStats.add(this.stats(breaker.getName()));
            parentEstimated += breaker.getUsed();
        }
        allStats.add(new CircuitBreakerStats("parent", this.parentSettings.getLimit(), parentEstimated, 1.0, this.parentTripCount.get()));
        return new AllCircuitBreakerStats(allStats.toArray(new CircuitBreakerStats[allStats.size()]));
    }

    @Override
    public CircuitBreakerStats stats(String name) {
        CircuitBreaker breaker = (CircuitBreaker)this.breakers.get(name);
        return new CircuitBreakerStats(breaker.getName(), breaker.getLimit(), breaker.getUsed(), breaker.getOverhead(), breaker.getTrippedCount());
    }

    public void checkParentLimit(String label) throws CircuitBreakingException {
        long totalUsed = 0L;
        for (CircuitBreaker breaker : this.breakers.values()) {
            totalUsed = (long)((double)totalUsed + (double)breaker.getUsed() * breaker.getOverhead());
        }
        long parentLimit = this.parentSettings.getLimit();
        if (totalUsed > parentLimit) {
            this.parentTripCount.incrementAndGet();
            throw new CircuitBreakingException("[parent] Data too large, data for [" + label + "] would be larger than limit of [" + parentLimit + "/" + new ByteSizeValue(parentLimit) + "]", totalUsed, parentLimit);
        }
    }

    @Override
    public void registerBreaker(BreakerSettings breakerSettings) {
        HierarchyCircuitBreakerService.validateSettings(new BreakerSettings[]{breakerSettings});
        if (breakerSettings.getType() != CircuitBreaker.Type.NOOP) {
            CircuitBreaker oldBreaker;
            ChildMemoryCircuitBreaker breaker = new ChildMemoryCircuitBreaker(breakerSettings, Loggers.getLogger(CHILD_LOGGER_PREFIX + breakerSettings.getName()), this, breakerSettings.getName());
            do {
                if ((oldBreaker = this.breakers.putIfAbsent(breakerSettings.getName(), breaker)) == null) {
                    return;
                }
                breaker = new ChildMemoryCircuitBreaker(breakerSettings, (ChildMemoryCircuitBreaker)oldBreaker, Loggers.getLogger(CHILD_LOGGER_PREFIX + breakerSettings.getName()), this, breakerSettings.getName());
            } while (!this.breakers.replace(breakerSettings.getName(), oldBreaker, breaker));
            return;
        }
        NoopCircuitBreaker breaker = new NoopCircuitBreaker(breakerSettings.getName());
        this.breakers.put(breakerSettings.getName(), breaker);
    }

    public class ApplySettings
    implements NodeSettingsService.Listener {
        @Override
        public void onRefreshSettings(Settings settings) {
            ByteSizeValue newFielddataMax = settings.getAsMemory(HierarchyCircuitBreakerService.FIELDDATA_CIRCUIT_BREAKER_LIMIT_SETTING, null);
            Double newFielddataOverhead = settings.getAsDouble(HierarchyCircuitBreakerService.FIELDDATA_CIRCUIT_BREAKER_OVERHEAD_SETTING, null);
            if (newFielddataMax != null || newFielddataOverhead != null) {
                long newFielddataLimitBytes = newFielddataMax == null ? HierarchyCircuitBreakerService.this.fielddataSettings.getLimit() : newFielddataMax.bytes();
                newFielddataOverhead = newFielddataOverhead == null ? HierarchyCircuitBreakerService.this.fielddataSettings.getOverhead() : newFielddataOverhead.doubleValue();
                BreakerSettings newFielddataSettings = new BreakerSettings("fielddata", newFielddataLimitBytes, newFielddataOverhead, HierarchyCircuitBreakerService.this.fielddataSettings.getType());
                HierarchyCircuitBreakerService.this.registerBreaker(newFielddataSettings);
                HierarchyCircuitBreakerService.this.fielddataSettings = newFielddataSettings;
                HierarchyCircuitBreakerService.this.logger.info("Updated breaker settings fielddata: {}", newFielddataSettings);
            }
            ByteSizeValue newRequestMax = settings.getAsMemory(HierarchyCircuitBreakerService.REQUEST_CIRCUIT_BREAKER_LIMIT_SETTING, null);
            Double newRequestOverhead = settings.getAsDouble(HierarchyCircuitBreakerService.REQUEST_CIRCUIT_BREAKER_OVERHEAD_SETTING, null);
            if (newRequestMax != null || newRequestOverhead != null) {
                long newRequestLimitBytes = newRequestMax == null ? HierarchyCircuitBreakerService.this.requestSettings.getLimit() : newRequestMax.bytes();
                newRequestOverhead = newRequestOverhead == null ? HierarchyCircuitBreakerService.this.requestSettings.getOverhead() : newRequestOverhead.doubleValue();
                BreakerSettings newRequestSettings = new BreakerSettings("request", newRequestLimitBytes, newRequestOverhead, HierarchyCircuitBreakerService.this.requestSettings.getType());
                HierarchyCircuitBreakerService.this.registerBreaker(newRequestSettings);
                HierarchyCircuitBreakerService.this.requestSettings = newRequestSettings;
                HierarchyCircuitBreakerService.this.logger.info("Updated breaker settings request: {}", newRequestSettings);
            }
            long oldParentMax = HierarchyCircuitBreakerService.this.parentSettings.getLimit();
            ByteSizeValue newParentMax = settings.getAsMemory(HierarchyCircuitBreakerService.TOTAL_CIRCUIT_BREAKER_LIMIT_SETTING, null);
            if (newParentMax != null && newParentMax.bytes() != oldParentMax) {
                BreakerSettings newParentSettings = new BreakerSettings("parent", newParentMax.bytes(), 1.0, CircuitBreaker.Type.PARENT);
                HierarchyCircuitBreakerService.validateSettings(new BreakerSettings[]{newParentSettings});
                HierarchyCircuitBreakerService.this.parentSettings = newParentSettings;
                HierarchyCircuitBreakerService.this.logger.info("Updated breaker settings parent: {}", newParentSettings);
            }
        }
    }
}

