/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.fs;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class FsInfo
implements Iterable<Path>,
Streamable,
ToXContent {
    long timestamp;
    Path total;
    Path[] paths;

    FsInfo() {
    }

    public FsInfo(long timestamp, Path[] paths) {
        this.timestamp = timestamp;
        this.paths = paths;
        this.total = null;
    }

    public Path getTotal() {
        return this.total();
    }

    public Path total() {
        if (this.total != null) {
            return this.total;
        }
        Path res = new Path();
        HashSet<String> seenDevices = new HashSet<String>(this.paths.length);
        for (Path subPath : this.paths) {
            if (subPath.path != null && !seenDevices.add(subPath.path)) continue;
            res.add(subPath);
        }
        this.total = res;
        return res;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Iterator<Path> iterator() {
        return Iterators.forArray((Object[])this.paths);
    }

    public static FsInfo readFsInfo(StreamInput in) throws IOException {
        FsInfo stats = new FsInfo();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.timestamp = in.readVLong();
        this.paths = new Path[in.readVInt()];
        for (int i = 0; i < this.paths.length; ++i) {
            this.paths[i] = Path.readInfoFrom(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        out.writeVInt(this.paths.length);
        for (Path path : this.paths) {
            path.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.FS);
        builder.field(Fields.TIMESTAMP, this.timestamp);
        builder.field(Fields.TOTAL);
        this.total().toXContent(builder, params);
        builder.startArray(Fields.DATA);
        for (Path path : this.paths) {
            path.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString FS = new XContentBuilderString("fs");
        static final XContentBuilderString TIMESTAMP = new XContentBuilderString("timestamp");
        static final XContentBuilderString DATA = new XContentBuilderString("data");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");

        Fields() {
        }
    }

    public static class Path
    implements Streamable,
    ToXContent {
        String path;
        @Nullable
        String mount;
        @Nullable
        String type;
        long total = -1L;
        long free = -1L;
        long available = -1L;
        Boolean spins = null;

        public Path() {
        }

        public Path(String path, @Nullable String mount, long total, long free, long available) {
            this.path = path;
            this.mount = mount;
            this.total = total;
            this.free = free;
            this.available = available;
        }

        public static Path readInfoFrom(StreamInput in) throws IOException {
            Path i = new Path();
            i.readFrom(in);
            return i;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.path = in.readOptionalString();
            this.mount = in.readOptionalString();
            this.type = in.readOptionalString();
            this.total = in.readLong();
            this.free = in.readLong();
            this.available = in.readLong();
            this.spins = in.readOptionalBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.path);
            out.writeOptionalString(this.mount);
            out.writeOptionalString(this.type);
            out.writeLong(this.total);
            out.writeLong(this.free);
            out.writeLong(this.available);
            out.writeOptionalBoolean(this.spins);
        }

        public String getPath() {
            return this.path;
        }

        public String getMount() {
            return this.mount;
        }

        public String getType() {
            return this.type;
        }

        public ByteSizeValue getTotal() {
            return new ByteSizeValue(this.total);
        }

        public ByteSizeValue getFree() {
            return new ByteSizeValue(this.free);
        }

        public ByteSizeValue getAvailable() {
            return new ByteSizeValue(this.available);
        }

        public Boolean getSpins() {
            return this.spins;
        }

        private long addLong(long current, long other) {
            if (other == -1L) {
                return current;
            }
            if (current == -1L) {
                return other;
            }
            return current + other;
        }

        private double addDouble(double current, double other) {
            if (other == -1.0) {
                return current;
            }
            if (current == -1.0) {
                return other;
            }
            return current + other;
        }

        public void add(Path path) {
            this.total = this.addLong(this.total, path.total);
            this.free = this.addLong(this.free, path.free);
            this.available = this.addLong(this.available, path.available);
            if (path.spins != null && path.spins.booleanValue()) {
                this.spins = Boolean.TRUE;
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.path != null) {
                builder.field(Fields.PATH, this.path, XContentBuilder.FieldCaseConversion.NONE);
            }
            if (this.mount != null) {
                builder.field(Fields.MOUNT, this.mount, XContentBuilder.FieldCaseConversion.NONE);
            }
            if (this.type != null) {
                builder.field(Fields.TYPE, this.type, XContentBuilder.FieldCaseConversion.NONE);
            }
            if (this.total != -1L) {
                builder.byteSizeField(Fields.TOTAL_IN_BYTES, Fields.TOTAL, this.total);
            }
            if (this.free != -1L) {
                builder.byteSizeField(Fields.FREE_IN_BYTES, Fields.FREE, this.free);
            }
            if (this.available != -1L) {
                builder.byteSizeField(Fields.AVAILABLE_IN_BYTES, Fields.AVAILABLE, this.available);
            }
            if (this.spins != null) {
                builder.field(Fields.SPINS, this.spins.toString());
            }
            builder.endObject();
            return builder;
        }

        static final class Fields {
            static final XContentBuilderString PATH = new XContentBuilderString("path");
            static final XContentBuilderString MOUNT = new XContentBuilderString("mount");
            static final XContentBuilderString TYPE = new XContentBuilderString("type");
            static final XContentBuilderString TOTAL = new XContentBuilderString("total");
            static final XContentBuilderString TOTAL_IN_BYTES = new XContentBuilderString("total_in_bytes");
            static final XContentBuilderString FREE = new XContentBuilderString("free");
            static final XContentBuilderString FREE_IN_BYTES = new XContentBuilderString("free_in_bytes");
            static final XContentBuilderString AVAILABLE = new XContentBuilderString("available");
            static final XContentBuilderString AVAILABLE_IN_BYTES = new XContentBuilderString("available_in_bytes");
            static final XContentBuilderString SPINS = new XContentBuilderString("spins");

            Fields() {
            }
        }
    }
}

