/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.ExtensionPoint;
import org.elasticsearch.index.snapshots.IndexShardRepository;
import org.elasticsearch.repositories.Repository;

public class RepositoryTypesRegistry {
    private final ExtensionPoint.SelectedType<Repository> repositoryTypes = new ExtensionPoint.SelectedType<Repository>("repository", Repository.class);
    private final ExtensionPoint.SelectedType<IndexShardRepository> shardRepositoryTypes = new ExtensionPoint.SelectedType<IndexShardRepository>("index_repository", IndexShardRepository.class);

    public void registerRepository(String name, Class<? extends Repository> repositoryType, Class<? extends IndexShardRepository> shardRepositoryType) {
        this.repositoryTypes.registerExtension(name, repositoryType);
        this.shardRepositoryTypes.registerExtension(name, shardRepositoryType);
    }

    public void bindType(Binder binder, String type) {
        Settings settings = Settings.builder().put("type", type).build();
        this.repositoryTypes.bindType(binder, settings, "type", null);
        this.shardRepositoryTypes.bindType(binder, settings, "type", null);
    }
}

