/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.forcemerge;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestBuilderListener;

public class RestForceMergeAction
extends BaseRestHandler {
    @Inject
    public RestForceMergeAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.POST, "/_forcemerge", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_forcemerge", this);
        controller.registerHandler(RestRequest.Method.GET, "/_forcemerge", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_forcemerge", this);
        controller.registerHandler(RestRequest.Method.POST, "/_optimize", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_optimize", this);
        controller.registerHandler(RestRequest.Method.GET, "/_optimize", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_optimize", this);
    }

    @Override
    public void handleRequest(final RestRequest request, RestChannel channel, Client client) {
        ForceMergeRequest mergeRequest = new ForceMergeRequest(Strings.splitStringByCommaToArray(request.param("index")));
        mergeRequest.indicesOptions(IndicesOptions.fromRequest(request, mergeRequest.indicesOptions()));
        mergeRequest.maxNumSegments(request.paramAsInt("max_num_segments", mergeRequest.maxNumSegments()));
        mergeRequest.onlyExpungeDeletes(request.paramAsBoolean("only_expunge_deletes", mergeRequest.onlyExpungeDeletes()));
        mergeRequest.flush(request.paramAsBoolean("flush", mergeRequest.flush()));
        client.admin().indices().forceMerge(mergeRequest, (ActionListener<ForceMergeResponse>)new RestBuilderListener<ForceMergeResponse>(channel){

            @Override
            public RestResponse buildResponse(ForceMergeResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                RestActions.buildBroadcastShardsHeader(builder, request, response);
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

