/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.cat;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.support.RestResponseListener;
import org.elasticsearch.rest.action.support.RestTable;

public class RestRepositoriesAction
extends AbstractCatAction {
    @Inject
    public RestRepositoriesAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/_cat/repositories", this);
    }

    @Override
    protected void doRequest(final RestRequest request, RestChannel channel, Client client) {
        GetRepositoriesRequest getRepositoriesRequest = new GetRepositoriesRequest();
        getRepositoriesRequest.local(request.paramAsBoolean("local", getRepositoriesRequest.local()));
        getRepositoriesRequest.masterNodeTimeout(request.paramAsTime("master_timeout", getRepositoriesRequest.masterNodeTimeout()));
        client.admin().cluster().getRepositories(getRepositoriesRequest, (ActionListener<GetRepositoriesResponse>)new RestResponseListener<GetRepositoriesResponse>(channel){

            @Override
            public RestResponse buildResponse(GetRepositoriesResponse getRepositoriesResponse) throws Exception {
                return RestTable.buildResponse(RestRepositoriesAction.this.buildTable(request, getRepositoriesResponse), this.channel);
            }
        });
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/repositories\n");
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        return new Table().startHeaders().addCell("id", "alias:id,repoId;desc:unique repository id").addCell("type", "alias:t,type;text-align:right;desc:repository type").endHeaders();
    }

    private Table buildTable(RestRequest req, GetRepositoriesResponse getRepositoriesResponse) {
        Table table = this.getTableWithHeader(req);
        for (RepositoryMetaData repositoryMetaData : getRepositoriesResponse.repositories()) {
            table.startRow();
            table.addCell(repositoryMetaData.name());
            table.addCell(repositoryMetaData.type());
            table.endRow();
        }
        return table;
    }
}

