/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.exists;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.exists.ExistsRequest;
import org.elasticsearch.action.exists.ExistsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.QuerySourceBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestBuilderListener;

@Deprecated
public class RestExistsAction
extends BaseRestHandler {
    public RestExistsAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        ExistsRequest existsRequest = new ExistsRequest(Strings.splitStringByCommaToArray(request.param("index")));
        existsRequest.indicesOptions(IndicesOptions.fromRequest(request, existsRequest.indicesOptions()));
        if (RestActions.hasBodyContent(request)) {
            existsRequest.source(RestActions.getRestContent(request));
        } else {
            QuerySourceBuilder querySourceBuilder = RestActions.parseQuerySource(request);
            if (querySourceBuilder != null) {
                existsRequest.source(querySourceBuilder);
            }
        }
        existsRequest.routing(request.param("routing"));
        existsRequest.minScore(request.paramAsFloat("min_score", -1.0f));
        existsRequest.types(Strings.splitStringByCommaToArray(request.param("type")));
        existsRequest.preference(request.param("preference"));
        client.exists(existsRequest, (ActionListener<ExistsResponse>)new RestBuilderListener<ExistsResponse>(channel){

            @Override
            public RestResponse buildResponse(ExistsResponse response, XContentBuilder builder) throws Exception {
                RestStatus status = response.exists() ? RestStatus.OK : RestStatus.NOT_FOUND;
                builder.startObject();
                builder.field("exists", response.exists());
                builder.endObject();
                return new BytesRestResponse(status, builder);
            }
        });
    }
}

