/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles;

import org.elasticsearch.common.ParseField;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.percentiles.AbstractPercentilesParser;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesMethod;
import org.elasticsearch.search.aggregations.metrics.percentiles.hdr.HDRPercentilesAggregator;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.InternalTDigestPercentiles;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.TDigestPercentilesAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;

public class PercentilesParser
extends AbstractPercentilesParser {
    public static final ParseField PERCENTS_FIELD = new ParseField("percents", new String[0]);
    private static final double[] DEFAULT_PERCENTS = new double[]{1.0, 5.0, 25.0, 50.0, 75.0, 95.0, 99.0};

    public PercentilesParser() {
        super(true);
    }

    @Override
    public String type() {
        return InternalTDigestPercentiles.TYPE.name();
    }

    @Override
    protected ParseField keysField() {
        return PERCENTS_FIELD;
    }

    @Override
    protected AggregatorFactory buildFactory(SearchContext context, String aggregationName, ValuesSourceConfig<ValuesSource.Numeric> valuesSourceConfig, double[] keys, PercentilesMethod method, Double compression, Integer numberOfSignificantValueDigits, boolean keyed) {
        if (keys == null) {
            keys = DEFAULT_PERCENTS;
        }
        if (method == PercentilesMethod.TDIGEST) {
            return new TDigestPercentilesAggregator.Factory(aggregationName, valuesSourceConfig, keys, compression, keyed);
        }
        if (method == PercentilesMethod.HDR) {
            return new HDRPercentilesAggregator.Factory(aggregationName, valuesSourceConfig, keys, numberOfSignificantValueDigits, keyed);
        }
        throw new AssertionError();
    }
}

