/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.tophits;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.util.LongObjectPagedHashMap;
import org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.tophits.InternalTopHits;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.InternalSearchHits;
import org.elasticsearch.search.internal.SubSearchContext;

public class TopHitsAggregator
extends MetricsAggregator {
    final FetchPhase fetchPhase;
    final SubSearchContext subSearchContext;
    final LongObjectPagedHashMap<TopDocsAndLeafCollector> topDocsCollectors;

    public TopHitsAggregator(FetchPhase fetchPhase, SubSearchContext subSearchContext, String name, AggregationContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, pipelineAggregators, metaData);
        this.fetchPhase = fetchPhase;
        this.topDocsCollectors = new LongObjectPagedHashMap(1L, context.bigArrays());
        this.subSearchContext = subSearchContext;
    }

    @Override
    public boolean needsScores() {
        Sort sort = this.subSearchContext.sort();
        if (sort != null) {
            return sort.needsScores() || this.subSearchContext.trackScores();
        }
        return true;
    }

    @Override
    public LeafBucketCollector getLeafCollector(final LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        for (LongObjectPagedHashMap.Cursor<TopDocsAndLeafCollector> cursor : this.topDocsCollectors) {
            ((TopDocsAndLeafCollector)cursor.value).leafCollector = ((TopDocsAndLeafCollector)cursor.value).topLevelCollector.getLeafCollector(ctx);
        }
        return new LeafBucketCollectorBase(sub, null){
            Scorer scorer;

            @Override
            public void setScorer(Scorer scorer) throws IOException {
                this.scorer = scorer;
                for (LongObjectPagedHashMap.Cursor<TopDocsAndLeafCollector> cursor : TopHitsAggregator.this.topDocsCollectors) {
                    ((TopDocsAndLeafCollector)cursor.value).leafCollector.setScorer(scorer);
                }
                super.setScorer(scorer);
            }

            @Override
            public void collect(int docId, long bucket) throws IOException {
                TopDocsAndLeafCollector collectors = TopHitsAggregator.this.topDocsCollectors.get(bucket);
                if (collectors == null) {
                    Sort sort = TopHitsAggregator.this.subSearchContext.sort();
                    int topN = TopHitsAggregator.this.subSearchContext.from() + TopHitsAggregator.this.subSearchContext.size();
                    topN = Math.min(topN, TopHitsAggregator.this.subSearchContext.searcher().getIndexReader().maxDoc());
                    TopScoreDocCollector topLevelCollector = sort != null ? TopFieldCollector.create((Sort)sort, (int)topN, (boolean)true, (boolean)TopHitsAggregator.this.subSearchContext.trackScores(), (boolean)TopHitsAggregator.this.subSearchContext.trackScores()) : TopScoreDocCollector.create((int)topN);
                    collectors = new TopDocsAndLeafCollector((TopDocsCollector<?>)topLevelCollector);
                    collectors.leafCollector = collectors.topLevelCollector.getLeafCollector(ctx);
                    collectors.leafCollector.setScorer(this.scorer);
                    TopHitsAggregator.this.topDocsCollectors.put(bucket, collectors);
                }
                collectors.leafCollector.collect(docId);
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        InternalTopHits topHits;
        TopDocsAndLeafCollector topDocsCollector = this.topDocsCollectors.get(owningBucketOrdinal);
        if (topDocsCollector == null) {
            topHits = this.buildEmptyAggregation();
        } else {
            TopDocs topDocs = topDocsCollector.topLevelCollector.topDocs();
            this.subSearchContext.queryResult().topDocs(topDocs);
            int[] docIdsToLoad = new int[topDocs.scoreDocs.length];
            for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
                docIdsToLoad[i] = topDocs.scoreDocs[i].doc;
            }
            this.subSearchContext.docIdsToLoad(docIdsToLoad, 0, docIdsToLoad.length);
            this.fetchPhase.execute(this.subSearchContext);
            FetchSearchResult fetchResult = this.subSearchContext.fetchResult();
            InternalSearchHit[] internalHits = fetchResult.fetchResult().hits().internalHits();
            for (int i = 0; i < internalHits.length; ++i) {
                ScoreDoc scoreDoc = topDocs.scoreDocs[i];
                InternalSearchHit searchHitFields = internalHits[i];
                searchHitFields.shard(this.subSearchContext.shardTarget());
                searchHitFields.score(scoreDoc.score);
                if (!(scoreDoc instanceof FieldDoc)) continue;
                FieldDoc fieldDoc = (FieldDoc)scoreDoc;
                searchHitFields.sortValues(fieldDoc.fields);
            }
            topHits = new InternalTopHits(this.name, this.subSearchContext.from(), this.subSearchContext.size(), topDocs, fetchResult.hits(), this.pipelineAggregators(), this.metaData());
        }
        return topHits;
    }

    @Override
    public InternalTopHits buildEmptyAggregation() {
        Object topDocs = this.subSearchContext.sort() != null ? new TopFieldDocs(0, (ScoreDoc[])new FieldDoc[0], this.subSearchContext.sort().getSort(), Float.NaN) : Lucene.EMPTY_TOP_DOCS;
        return new InternalTopHits(this.name, this.subSearchContext.from(), this.subSearchContext.size(), (TopDocs)topDocs, InternalSearchHits.empty(), this.pipelineAggregators(), this.metaData());
    }

    @Override
    protected void doClose() {
        Releasables.close(new Releasable[]{this.topDocsCollectors});
    }

    public static class Factory
    extends AggregatorFactory {
        private final FetchPhase fetchPhase;
        private final SubSearchContext subSearchContext;

        public Factory(String name, FetchPhase fetchPhase, SubSearchContext subSearchContext) {
            super(name, InternalTopHits.TYPE.name());
            this.fetchPhase = fetchPhase;
            this.subSearchContext = subSearchContext;
        }

        @Override
        public Aggregator createInternal(AggregationContext aggregationContext, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            return new TopHitsAggregator(this.fetchPhase, this.subSearchContext, this.name, aggregationContext, parent, pipelineAggregators, metaData);
        }

        @Override
        public AggregatorFactory subFactories(AggregatorFactories subFactories) {
            throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.type + "] cannot accept sub-aggregations");
        }
    }

    private static class TopDocsAndLeafCollector {
        final TopDocsCollector<?> topLevelCollector;
        LeafCollector leafCollector;

        TopDocsAndLeafCollector(TopDocsCollector<?> topLevelCollector) {
            this.topLevelCollector = topLevelCollector;
        }
    }
}

