/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.extended;

import java.text.ParseException;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorFactory;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.BucketMetricsParser;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.extended.ExtendedStatsBucketPipelineAggregator;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class ExtendedStatsBucketParser
extends BucketMetricsParser {
    static final ParseField SIGMA = new ParseField("sigma", new String[0]);

    @Override
    public String type() {
        return ExtendedStatsBucketPipelineAggregator.TYPE.name();
    }

    @Override
    protected PipelineAggregatorFactory buildFactory(String pipelineAggregatorName, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, ValueFormatter formatter, Map<String, Object> unparsedParams) throws ParseException {
        double sigma = 2.0;
        Object param = unparsedParams.get(SIGMA.getPreferredName());
        if (param != null) {
            if (param instanceof Double) {
                sigma = (Double)param;
                unparsedParams.remove(SIGMA.getPreferredName());
            } else {
                throw new ParseException("Parameter [" + SIGMA.getPreferredName() + "] must be a Double, type `" + param.getClass().getSimpleName() + "` provided instead", 0);
            }
        }
        return new ExtendedStatsBucketPipelineAggregator.Factory(pipelineAggregatorName, bucketsPaths, sigma, gapPolicy, formatter);
    }
}

