/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.movavg.models;

import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.pipeline.movavg.MovAvgParser;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModel;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModelBuilder;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModelStreams;

public class EwmaModel
extends MovAvgModel {
    protected static final ParseField NAME_FIELD = new ParseField("ewma", new String[0]);
    private final double alpha;
    public static final MovAvgModelStreams.Stream STREAM = new MovAvgModelStreams.Stream(){

        @Override
        public MovAvgModel readResult(StreamInput in) throws IOException {
            return new EwmaModel(in.readDouble());
        }

        @Override
        public String getName() {
            return NAME_FIELD.getPreferredName();
        }
    };

    public EwmaModel(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public boolean canBeMinimized() {
        return true;
    }

    @Override
    public MovAvgModel neighboringModel() {
        double alpha = Math.random();
        return new EwmaModel(alpha);
    }

    @Override
    public MovAvgModel clone() {
        return new EwmaModel(this.alpha);
    }

    @Override
    protected <T extends Number> double[] doPredict(Collection<T> values, int numPredictions) {
        double[] predictions = new double[numPredictions];
        Arrays.fill(predictions, this.next(values));
        return predictions;
    }

    @Override
    public <T extends Number> double next(Collection<T> values) {
        double avg = 0.0;
        boolean first = true;
        for (Number v : values) {
            if (first) {
                avg = v.doubleValue();
                first = false;
                continue;
            }
            avg = v.doubleValue() * this.alpha + avg * (1.0 - this.alpha);
        }
        return avg;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(STREAM.getName());
        out.writeDouble(this.alpha);
    }

    public static class EWMAModelBuilder
    implements MovAvgModelBuilder {
        private Double alpha;

        public EWMAModelBuilder alpha(double alpha) {
            this.alpha = alpha;
            return this;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(MovAvgParser.MODEL.getPreferredName(), NAME_FIELD.getPreferredName());
            builder.startObject(MovAvgParser.SETTINGS.getPreferredName());
            if (this.alpha != null) {
                builder.field("alpha", this.alpha);
            }
            builder.endObject();
            return builder;
        }
    }

    public static class SingleExpModelParser
    extends MovAvgModel.AbstractModelParser {
        @Override
        public String getName() {
            return NAME_FIELD.getPreferredName();
        }

        @Override
        public MovAvgModel parse(@Nullable Map<String, Object> settings, String pipelineName, int windowSize, ParseFieldMatcher parseFieldMatcher) throws ParseException {
            double alpha = this.parseDoubleParam(settings, "alpha", 0.3);
            this.checkUnrecognizedParams(settings);
            return new EwmaModel(alpha);
        }
    }
}

