/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.util.Counter;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.lucene.search.function.BoostScoreFunction;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.SearchContextAggregations;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.FetchSubPhaseContext;
import org.elasticsearch.search.fetch.innerhits.InnerHitsContext;
import org.elasticsearch.search.fetch.script.ScriptFieldsContext;
import org.elasticsearch.search.fetch.source.FetchSourceContext;
import org.elasticsearch.search.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.profile.Profilers;
import org.elasticsearch.search.query.QueryPhaseExecutionException;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.rescore.RescoreSearchContext;
import org.elasticsearch.search.scan.ScanContext;
import org.elasticsearch.search.suggest.SuggestionSearchContext;

public class DefaultSearchContext
extends SearchContext {
    public static final String MAX_RESULT_WINDOW = "index.max_result_window";
    private final long id;
    private final ShardSearchRequest request;
    private final SearchShardTarget shardTarget;
    private final Counter timeEstimateCounter;
    private SearchType searchType;
    private final Engine.Searcher engineSearcher;
    private final ScriptService scriptService;
    private final PageCacheRecycler pageCacheRecycler;
    private final BigArrays bigArrays;
    private final IndexShard indexShard;
    private final IndexService indexService;
    private final ContextIndexSearcher searcher;
    private final DfsSearchResult dfsResult;
    private final QuerySearchResult queryResult;
    private final FetchSearchResult fetchResult;
    private ScanContext scanContext;
    private float queryBoost = 1.0f;
    private long timeoutInMillis;
    private int terminateAfter = 0;
    private List<String> groupStats;
    private ScrollContext scrollContext;
    private boolean explain;
    private boolean version = false;
    private List<String> fieldNames;
    private ScriptFieldsContext scriptFields;
    private FetchSourceContext fetchSourceContext;
    private int from = -1;
    private int size = -1;
    private Sort sort;
    private Float minimumScore;
    private boolean trackScores = false;
    private ParsedQuery originalQuery;
    private Query query;
    private ParsedQuery postFilter;
    private Query aliasFilter;
    private int[] docIdsToLoad;
    private int docsIdsToLoadFrom;
    private int docsIdsToLoadSize;
    private SearchContextAggregations aggregations;
    private SearchContextHighlight highlight;
    private SuggestionSearchContext suggest;
    private List<RescoreSearchContext> rescore;
    private SearchLookup searchLookup;
    private volatile long keepAlive;
    private final long originNanoTime = System.nanoTime();
    private volatile long lastAccessTime = -1L;
    private InnerHitsContext innerHitsContext;
    private Profilers profilers;
    private final Map<String, FetchSubPhaseContext> subPhaseContexts = new HashMap<String, FetchSubPhaseContext>();
    private final Map<Class<?>, Collector> queryCollectors = new HashMap();

    public DefaultSearchContext(long id, ShardSearchRequest request, SearchShardTarget shardTarget, Engine.Searcher engineSearcher, IndexService indexService, IndexShard indexShard, ScriptService scriptService, PageCacheRecycler pageCacheRecycler, BigArrays bigArrays, Counter timeEstimateCounter, ParseFieldMatcher parseFieldMatcher, TimeValue timeout) {
        super(parseFieldMatcher, request);
        this.id = id;
        this.request = request;
        this.searchType = request.searchType();
        this.shardTarget = shardTarget;
        this.engineSearcher = engineSearcher;
        this.scriptService = scriptService;
        this.pageCacheRecycler = pageCacheRecycler;
        this.bigArrays = bigArrays.withCircuitBreaking();
        this.dfsResult = new DfsSearchResult(id, shardTarget);
        this.queryResult = new QuerySearchResult(id, shardTarget);
        this.fetchResult = new FetchSearchResult(id, shardTarget);
        this.indexShard = indexShard;
        this.indexService = indexService;
        this.searcher = new ContextIndexSearcher(engineSearcher, indexService.cache().query(), indexShard.getQueryCachingPolicy());
        this.timeEstimateCounter = timeEstimateCounter;
        this.timeoutInMillis = timeout.millis();
    }

    @Override
    public void doClose() {
        this.scanContext = null;
        Releasables.close(this.searcher, this.engineSearcher);
    }

    @Override
    public void preProcess() {
        Query searchFilter;
        int maxResultWindow;
        long size;
        long from;
        long resultWindow;
        if (this.scrollContext == null && (resultWindow = (from = this.from() == -1 ? 0L : (long)this.from()) + (size = this.size() == -1 ? 10L : (long)this.size())) > (long)(maxResultWindow = this.indexService.indexSettings().getAsInt(MAX_RESULT_WINDOW, (Integer)10000).intValue())) {
            throw new QueryPhaseExecutionException(this, "Result window is too large, from + size must be less than or equal to: [" + maxResultWindow + "] but was [" + resultWindow + "]. See the scroll api for a more efficient way to request large data sets. " + "This limit can be set by changing the [" + MAX_RESULT_WINDOW + "] index level parameter.");
        }
        this.aliasFilter = this.indexService.aliasesService().aliasFilter(this.request.filteringAliases());
        if (this.query() == null) {
            this.parsedQuery(ParsedQuery.parsedMatchAllQuery());
        }
        if (this.queryBoost() != 1.0f) {
            this.parsedQuery(new ParsedQuery((Query)new FunctionScoreQuery(this.query(), new BoostScoreFunction(this.queryBoost)), this.parsedQuery()));
        }
        if ((searchFilter = this.searchFilter(this.types())) != null) {
            if (Queries.isConstantMatchAllQuery(this.query())) {
                ConstantScoreQuery q = new ConstantScoreQuery(searchFilter);
                q.setBoost(this.query().getBoost());
                this.parsedQuery(new ParsedQuery((Query)q, this.parsedQuery()));
            } else {
                BooleanQuery filtered = new BooleanQuery.Builder().add(this.query(), BooleanClause.Occur.MUST).add(searchFilter, BooleanClause.Occur.FILTER).build();
                this.parsedQuery(new ParsedQuery((Query)filtered, this.parsedQuery()));
            }
        }
        try {
            this.query = this.searcher().rewrite(this.query);
        }
        catch (IOException e) {
            throw new QueryPhaseExecutionException(this, "Failed to rewrite main query", (Throwable)e);
        }
    }

    @Override
    public Query searchFilter(String[] types) {
        Query filter = this.mapperService().searchFilter(types);
        if (filter == null && this.aliasFilter == null) {
            return null;
        }
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        if (filter != null) {
            bq.add(filter, BooleanClause.Occur.MUST);
        }
        if (this.aliasFilter != null) {
            bq.add(this.aliasFilter, BooleanClause.Occur.MUST);
        }
        return new ConstantScoreQuery((Query)bq.build());
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public String source() {
        return this.engineSearcher.source();
    }

    @Override
    public ShardSearchRequest request() {
        return this.request;
    }

    @Override
    public SearchType searchType() {
        return this.searchType;
    }

    @Override
    public SearchContext searchType(SearchType searchType) {
        this.searchType = searchType;
        return this;
    }

    @Override
    public SearchShardTarget shardTarget() {
        return this.shardTarget;
    }

    @Override
    public int numberOfShards() {
        return this.request.numberOfShards();
    }

    @Override
    public boolean hasTypes() {
        return this.request.types() != null && this.request.types().length > 0;
    }

    @Override
    public String[] types() {
        return this.request.types();
    }

    @Override
    public float queryBoost() {
        return this.queryBoost;
    }

    @Override
    public SearchContext queryBoost(float queryBoost) {
        this.queryBoost = queryBoost;
        return this;
    }

    @Override
    public long getOriginNanoTime() {
        return this.originNanoTime;
    }

    @Override
    protected long nowInMillisImpl() {
        return this.request.nowInMillis();
    }

    @Override
    public ScrollContext scrollContext() {
        return this.scrollContext;
    }

    @Override
    public SearchContext scrollContext(ScrollContext scrollContext) {
        this.scrollContext = scrollContext;
        return this;
    }

    @Override
    public SearchContextAggregations aggregations() {
        return this.aggregations;
    }

    @Override
    public SearchContext aggregations(SearchContextAggregations aggregations) {
        this.aggregations = aggregations;
        return this;
    }

    @Override
    public <SubPhaseContext extends FetchSubPhaseContext> SubPhaseContext getFetchSubPhaseContext(FetchSubPhase.ContextFactory<SubPhaseContext> contextFactory) {
        String subPhaseName = contextFactory.getName();
        if (this.subPhaseContexts.get(subPhaseName) == null) {
            this.subPhaseContexts.put(subPhaseName, (FetchSubPhaseContext)contextFactory.newContextInstance());
        }
        return (SubPhaseContext)this.subPhaseContexts.get(subPhaseName);
    }

    @Override
    public SearchContextHighlight highlight() {
        return this.highlight;
    }

    @Override
    public void highlight(SearchContextHighlight highlight) {
        this.highlight = highlight;
    }

    @Override
    public SuggestionSearchContext suggest() {
        return this.suggest;
    }

    @Override
    public void suggest(SuggestionSearchContext suggest) {
        this.suggest = suggest;
    }

    @Override
    public List<RescoreSearchContext> rescore() {
        if (this.rescore == null) {
            return Collections.emptyList();
        }
        return this.rescore;
    }

    @Override
    public void addRescore(RescoreSearchContext rescore) {
        if (this.rescore == null) {
            this.rescore = new ArrayList<RescoreSearchContext>();
        }
        this.rescore.add(rescore);
    }

    @Override
    public boolean hasScriptFields() {
        return this.scriptFields != null;
    }

    @Override
    public ScriptFieldsContext scriptFields() {
        if (this.scriptFields == null) {
            this.scriptFields = new ScriptFieldsContext();
        }
        return this.scriptFields;
    }

    @Override
    public boolean sourceRequested() {
        return this.fetchSourceContext != null && this.fetchSourceContext.fetchSource();
    }

    @Override
    public boolean hasFetchSourceContext() {
        return this.fetchSourceContext != null;
    }

    @Override
    public FetchSourceContext fetchSourceContext() {
        return this.fetchSourceContext;
    }

    @Override
    public SearchContext fetchSourceContext(FetchSourceContext fetchSourceContext) {
        this.fetchSourceContext = fetchSourceContext;
        return this;
    }

    @Override
    public ContextIndexSearcher searcher() {
        return this.searcher;
    }

    @Override
    public IndexShard indexShard() {
        return this.indexShard;
    }

    @Override
    public MapperService mapperService() {
        return this.indexService.mapperService();
    }

    @Override
    public AnalysisService analysisService() {
        return this.indexService.analysisService();
    }

    @Override
    public IndexQueryParserService queryParserService() {
        return this.indexService.queryParserService();
    }

    @Override
    public SimilarityService similarityService() {
        return this.indexService.similarityService();
    }

    @Override
    public ScriptService scriptService() {
        return this.scriptService;
    }

    @Override
    public PageCacheRecycler pageCacheRecycler() {
        return this.pageCacheRecycler;
    }

    @Override
    public BigArrays bigArrays() {
        return this.bigArrays;
    }

    @Override
    public BitsetFilterCache bitsetFilterCache() {
        return this.indexService.bitsetFilterCache();
    }

    @Override
    public IndexFieldDataService fieldData() {
        return this.indexService.fieldData();
    }

    @Override
    public long timeoutInMillis() {
        return this.timeoutInMillis;
    }

    @Override
    public void timeoutInMillis(long timeoutInMillis) {
        this.timeoutInMillis = timeoutInMillis;
    }

    @Override
    public int terminateAfter() {
        return this.terminateAfter;
    }

    @Override
    public void terminateAfter(int terminateAfter) {
        this.terminateAfter = terminateAfter;
    }

    @Override
    public SearchContext minimumScore(float minimumScore) {
        this.minimumScore = Float.valueOf(minimumScore);
        return this;
    }

    @Override
    public Float minimumScore() {
        return this.minimumScore;
    }

    @Override
    public SearchContext sort(Sort sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public Sort sort() {
        return this.sort;
    }

    @Override
    public SearchContext trackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this;
    }

    @Override
    public boolean trackScores() {
        return this.trackScores;
    }

    @Override
    public SearchContext parsedPostFilter(ParsedQuery postFilter) {
        this.postFilter = postFilter;
        return this;
    }

    @Override
    public ParsedQuery parsedPostFilter() {
        return this.postFilter;
    }

    @Override
    public Query aliasFilter() {
        return this.aliasFilter;
    }

    @Override
    public SearchContext parsedQuery(ParsedQuery query) {
        this.originalQuery = query;
        this.query = query.query();
        return this;
    }

    @Override
    public ParsedQuery parsedQuery() {
        return this.originalQuery;
    }

    @Override
    public Query query() {
        return this.query;
    }

    @Override
    public int from() {
        return this.from;
    }

    @Override
    public SearchContext from(int from) {
        this.from = from;
        return this;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public SearchContext size(int size) {
        this.size = size;
        return this;
    }

    @Override
    public boolean hasFieldNames() {
        return this.fieldNames != null;
    }

    @Override
    public List<String> fieldNames() {
        if (this.fieldNames == null) {
            this.fieldNames = new ArrayList<String>();
        }
        return this.fieldNames;
    }

    @Override
    public void emptyFieldNames() {
        this.fieldNames = Collections.emptyList();
    }

    @Override
    public boolean explain() {
        return this.explain;
    }

    @Override
    public void explain(boolean explain) {
        this.explain = explain;
    }

    @Override
    @Nullable
    public List<String> groupStats() {
        return this.groupStats;
    }

    @Override
    public void groupStats(List<String> groupStats) {
        this.groupStats = groupStats;
    }

    @Override
    public boolean version() {
        return this.version;
    }

    @Override
    public void version(boolean version) {
        this.version = version;
    }

    @Override
    public int[] docIdsToLoad() {
        return this.docIdsToLoad;
    }

    @Override
    public int docIdsToLoadFrom() {
        return this.docsIdsToLoadFrom;
    }

    @Override
    public int docIdsToLoadSize() {
        return this.docsIdsToLoadSize;
    }

    @Override
    public SearchContext docIdsToLoad(int[] docIdsToLoad, int docsIdsToLoadFrom, int docsIdsToLoadSize) {
        this.docIdsToLoad = docIdsToLoad;
        this.docsIdsToLoadFrom = docsIdsToLoadFrom;
        this.docsIdsToLoadSize = docsIdsToLoadSize;
        return this;
    }

    @Override
    public void accessed(long accessTime) {
        this.lastAccessTime = accessTime;
    }

    @Override
    public long lastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public long keepAlive() {
        return this.keepAlive;
    }

    @Override
    public void keepAlive(long keepAlive) {
        this.keepAlive = keepAlive;
    }

    @Override
    public SearchLookup lookup() {
        if (this.searchLookup == null) {
            this.searchLookup = new SearchLookup(this.mapperService(), this.fieldData(), this.request.types());
        }
        return this.searchLookup;
    }

    @Override
    public DfsSearchResult dfsResult() {
        return this.dfsResult;
    }

    @Override
    public QuerySearchResult queryResult() {
        return this.queryResult;
    }

    @Override
    public FetchSearchResult fetchResult() {
        return this.fetchResult;
    }

    @Override
    public ScanContext scanContext() {
        if (this.scanContext == null) {
            this.scanContext = new ScanContext();
        }
        return this.scanContext;
    }

    @Override
    public MappedFieldType smartNameFieldType(String name) {
        return this.mapperService().smartNameFieldType(name, this.request.types());
    }

    @Override
    public MappedFieldType smartNameFieldTypeFromAnyType(String name) {
        return this.mapperService().smartNameFieldType(name);
    }

    @Override
    public ObjectMapper getObjectMapper(String name) {
        return this.mapperService().getObjectMapper(name, this.request.types());
    }

    @Override
    public Counter timeEstimateCounter() {
        return this.timeEstimateCounter;
    }

    @Override
    public void innerHits(InnerHitsContext innerHitsContext) {
        this.innerHitsContext = innerHitsContext;
    }

    @Override
    public InnerHitsContext innerHits() {
        return this.innerHitsContext;
    }

    @Override
    public Map<Class<?>, Collector> queryCollectors() {
        return this.queryCollectors;
    }

    @Override
    public Profilers getProfilers() {
        return this.profilers;
    }

    public void setProfilers(Profilers profilers) {
        this.profilers = profilers;
    }

    public static class Defaults {
        public static final int MAX_RESULT_WINDOW = 10000;
    }
}

