/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

final class ProfileResult
implements Writeable<ProfileResult>,
ToXContent {
    private static final ParseField QUERY_TYPE = new ParseField("query_type", new String[0]);
    private static final ParseField LUCENE_DESCRIPTION = new ParseField("lucene", new String[0]);
    private static final ParseField NODE_TIME = new ParseField("time", new String[0]);
    private static final ParseField CHILDREN = new ParseField("children", new String[0]);
    private static final ParseField BREAKDOWN = new ParseField("breakdown", new String[0]);
    private final String queryType;
    private final String luceneDescription;
    private final Map<String, Long> timings;
    private final long nodeTime;
    private final List<ProfileResult> children;

    public ProfileResult(String queryType, String luceneDescription, Map<String, Long> timings, List<ProfileResult> children, long nodeTime) {
        this.queryType = queryType;
        this.luceneDescription = luceneDescription;
        this.timings = timings;
        this.children = children;
        this.nodeTime = nodeTime;
    }

    public ProfileResult(StreamInput in) throws IOException {
        this.queryType = in.readString();
        this.luceneDescription = in.readString();
        this.nodeTime = in.readLong();
        int timingsSize = in.readVInt();
        this.timings = new HashMap<String, Long>(timingsSize);
        for (int i = 0; i < timingsSize; ++i) {
            this.timings.put(in.readString(), in.readLong());
        }
        int size = in.readVInt();
        this.children = new ArrayList<ProfileResult>(size);
        for (int i = 0; i < size; ++i) {
            this.children.add(new ProfileResult(in));
        }
    }

    public String getLuceneDescription() {
        return this.luceneDescription;
    }

    public String getQueryName() {
        return this.queryType;
    }

    public Map<String, Long> getTimeBreakdown() {
        return Collections.unmodifiableMap(this.timings);
    }

    public long getTime() {
        return this.nodeTime;
    }

    public List<ProfileResult> getProfiledChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public ProfileResult readFrom(StreamInput in) throws IOException {
        return new ProfileResult(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.queryType);
        out.writeString(this.luceneDescription);
        out.writeLong(this.nodeTime);
        out.writeVInt(this.timings.size());
        for (Map.Entry<String, Long> entry : this.timings.entrySet()) {
            out.writeString(entry.getKey());
            out.writeLong(entry.getValue());
        }
        out.writeVInt(this.children.size());
        for (ProfileResult child : this.children) {
            child.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder = builder.startObject().field(QUERY_TYPE.getPreferredName(), this.queryType).field(LUCENE_DESCRIPTION.getPreferredName(), this.luceneDescription).field(NODE_TIME.getPreferredName(), String.format(Locale.US, "%.10gms", (double)this.getTime() / 1000000.0)).field(BREAKDOWN.getPreferredName(), (Object)this.timings);
        if (!this.children.isEmpty()) {
            builder = builder.startArray(CHILDREN.getPreferredName());
            for (ProfileResult child : this.children) {
                builder = child.toXContent(builder, params);
            }
            builder = builder.endArray();
        }
        builder = builder.endObject();
        return builder;
    }
}

