/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.transport.TransportAddressSerializers;
import org.elasticsearch.transport.TransportException;

public class ActionTransportException
extends TransportException {
    private final TransportAddress address;
    private final String action;

    public ActionTransportException(StreamInput in) throws IOException {
        super(in);
        this.address = in.readBoolean() ? TransportAddressSerializers.addressFromStream(in) : null;
        this.action = in.readOptionalString();
    }

    public ActionTransportException(String name, TransportAddress address, String action, Throwable cause) {
        super(ActionTransportException.buildMessage(name, address, action, null), cause);
        this.address = address;
        this.action = action;
    }

    public ActionTransportException(String name, TransportAddress address, String action, String msg, Throwable cause) {
        super(ActionTransportException.buildMessage(name, address, action, msg), cause);
        this.address = address;
        this.action = action;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.address != null) {
            out.writeBoolean(true);
            TransportAddressSerializers.addressToStream(out, this.address);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.action);
    }

    public TransportAddress address() {
        return this.address;
    }

    public String action() {
        return this.action;
    }

    private static String buildMessage(String name, TransportAddress address, String action, String msg) {
        StringBuilder sb = new StringBuilder();
        if (name != null) {
            sb.append('[').append(name).append(']');
        }
        if (address != null) {
            sb.append('[').append(address).append(']');
        }
        if (action != null) {
            sb.append('[').append(action).append(']');
        }
        if (msg != null) {
            sb.append(" ").append(msg);
        }
        return sb.toString();
    }
}

