/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import jxl.biff.formula.ArgumentSeparator;
import jxl.biff.formula.Attribute;
import jxl.biff.formula.BuiltInFunction;
import jxl.biff.formula.CloseParentheses;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.Function;
import jxl.biff.formula.OpenParentheses;
import jxl.biff.formula.Operand;
import jxl.biff.formula.Operator;
import jxl.biff.formula.Parenthesis;
import jxl.biff.formula.ParseItem;
import jxl.biff.formula.Parser;
import jxl.biff.formula.StringFunction;
import jxl.biff.formula.VariableArgFunction;
import jxl.biff.formula.Yylex;

class StringFormulaParser
implements Parser {
    private String formula;
    private String parsedFormula;
    private ParseItem root;
    private Stack arguments;

    public StringFormulaParser(String f) {
        this.formula = f;
    }

    public void parse() throws FormulaException {
        ArrayList tokens = this.getTokens();
        Iterator i = tokens.iterator();
        this.root = this.parseCurrent(i);
    }

    private ParseItem parseCurrent(Iterator i) throws FormulaException {
        Stack<ParseItem> stack = new Stack<ParseItem>();
        Stack<Operator> operators = new Stack<Operator>();
        Stack<ParseItem> args = null;
        boolean parenthesesClosed = false;
        while (i.hasNext() && !parenthesesClosed) {
            ParseItem pi = (ParseItem)i.next();
            if (pi instanceof Operand) {
                stack.push(pi);
                continue;
            }
            if (pi instanceof StringFunction) {
                this.handleFunction((StringFunction)pi, i, stack);
                continue;
            }
            if (pi instanceof Operator) {
                Operator op = (Operator)pi;
                if (operators.empty()) {
                    operators.push(op);
                    continue;
                }
                Operator operator = (Operator)operators.peek();
                if (op.getPrecedence() < operator.getPrecedence()) {
                    operators.push(op);
                    continue;
                }
                operators.pop();
                operator.getOperands(stack);
                stack.push(operator);
                operators.push(op);
                continue;
            }
            if (pi instanceof ArgumentSeparator) {
                while (!operators.isEmpty()) {
                    Operator o = (Operator)operators.pop();
                    o.getOperands(stack);
                    stack.push(o);
                }
                if (args == null) {
                    args = new Stack<ParseItem>();
                }
                args.push((ParseItem)stack.pop());
                stack.clear();
                continue;
            }
            if (pi instanceof OpenParentheses) {
                ParseItem pi2 = this.parseCurrent(i);
                Parenthesis p = new Parenthesis();
                pi2.setParent(p);
                p.add(pi2);
                stack.push(p);
                continue;
            }
            if (!(pi instanceof CloseParentheses)) continue;
            parenthesesClosed = true;
        }
        while (!operators.isEmpty()) {
            Operator o = (Operator)operators.pop();
            o.getOperands(stack);
            stack.push(o);
        }
        ParseItem rt = (ParseItem)stack.pop();
        if (args != null) {
            args.push(rt);
        }
        this.arguments = args;
        if (!stack.empty() || !operators.empty()) {
            System.err.println("Warning:  formula " + this.formula + " has a non-empty parse stack");
        }
        return rt;
    }

    private ArrayList getTokens() throws FormulaException {
        ArrayList<ParseItem> tokens = new ArrayList<ParseItem>();
        StringReader sr = new StringReader(this.formula);
        Yylex lex = new Yylex(sr);
        try {
            ParseItem pi = lex.yylex();
            while (pi != null) {
                tokens.add(pi);
                pi = lex.yylex();
            }
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
        catch (Error e) {
            throw new FormulaException(FormulaException.lexicalError, this.formula + " at char  " + lex.getPos());
        }
        return tokens;
    }

    public String getFormula() {
        if (this.parsedFormula == null) {
            StringBuffer sb = new StringBuffer();
            this.root.getString(sb);
            this.parsedFormula = sb.toString();
        }
        return this.parsedFormula;
    }

    public byte[] getBytes() {
        return this.root.getBytes();
    }

    private void handleFunction(StringFunction sf, Iterator i, Stack stack) throws FormulaException {
        ParseItem pi2 = this.parseCurrent(i);
        if (sf.getFunction() == Function.UNKNOWN) {
            throw new FormulaException(FormulaException.unrecognizedFunction);
        }
        if (sf.getFunction() == Function.SUM && this.arguments == null) {
            Attribute a = new Attribute(sf);
            a.add(pi2);
            stack.push(a);
            return;
        }
        if (sf.getFunction() == Function.IF) {
            Attribute a = new Attribute(sf);
            VariableArgFunction vaf = new VariableArgFunction();
            int numargs = this.arguments.size();
            int j = 0;
            while (j < numargs) {
                ParseItem pi3 = (ParseItem)this.arguments.get(j);
                vaf.add(pi3);
                ++j;
            }
            a.setIfConditions(vaf);
            stack.push(a);
            return;
        }
        if (sf.getFunction().numArgs == 255) {
            if (this.arguments == null) {
                VariableArgFunction vaf = new VariableArgFunction(sf.getFunction(), 1);
                vaf.add(pi2);
                stack.push(vaf);
            } else {
                int numargs = this.arguments.size();
                VariableArgFunction vaf = new VariableArgFunction(sf.getFunction(), numargs);
                int j = 0;
                while (j < numargs) {
                    ParseItem pi3 = (ParseItem)this.arguments.pop();
                    vaf.add(pi3);
                    ++j;
                }
                stack.push(vaf);
                this.arguments.clear();
                this.arguments = null;
            }
            return;
        }
        BuiltInFunction bif = new BuiltInFunction(sf.getFunction());
        int numargs = sf.getFunction().numArgs;
        if (numargs == 1) {
            bif.add(pi2);
        } else {
            if (this.arguments == null || numargs != this.arguments.size()) {
                throw new FormulaException(FormulaException.incorrectArguments);
            }
            int j = 0;
            while (j < numargs) {
                ParseItem pi3 = (ParseItem)this.arguments.get(j);
                bif.add(pi3);
                ++j;
            }
        }
        stack.push(bif);
    }
}

